/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.adventure.spectator.bossbar;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import sba.k.a.bossbar.BossBar;
import sba.sl.spectator.bossbar.BossBarColor;
import sba.sl.spectator.bossbar.BossBarDivision;
import sba.sl.spectator.bossbar.BossBarFlag;

public final class BossBarUtils {
    public static BossBarColor convertColor(BossBar.Color color) {
        try {
            return BossBarColor.valueOf(color.name());
        }
        catch (Throwable t) {
            return BossBarColor.PURPLE;
        }
    }

    public static BossBar.Color convertColor(BossBarColor color) {
        return BossBar.Color.valueOf(color.name());
    }

    public static BossBarDivision convertDivision(BossBar.Overlay overlay) {
        try {
            return BossBarDivision.valueOf(overlay.name());
        }
        catch (Throwable t) {
            return BossBarDivision.NO_DIVISION;
        }
    }

    public static BossBar.Overlay convertDivision(BossBarDivision division) {
        if (division == BossBarDivision.NO_DIVISION) {
            return BossBar.Overlay.PROGRESS;
        }
        return BossBar.Overlay.valueOf(division.name());
    }

    public static List<BossBarFlag> convertFlags(@Nullable Set<BossBar.Flag> flags) {
        return flags == null ? List.of() : flags.stream().map(flag -> BossBarFlag.valueOf(flag.name())).collect(Collectors.toUnmodifiableList());
    }

    public static Set<BossBar.Flag> convertFlags(@Nullable Collection<BossBarFlag> flags) {
        return flags == null ? Set.of() : flags.stream().map(bossBarFlag -> BossBar.Flag.valueOf(bossBarFlag.name())).collect(Collectors.toUnmodifiableSet());
    }

    @Generated
    private BossBarUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

