/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.adventure.spectator.sound;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.k.a.key.Key;
import sba.k.a.sound.Sound;
import sba.k.a.sound.SoundStop;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.adventure.spectator.sound.AdventureSoundSource;
import sba.sl.spectator.sound.SoundSource;
import sba.sl.spectator.sound.SoundStop;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;

public class AdventureSoundStop
extends BasicWrapper<SoundStop>
implements sba.sl.spectator.sound.SoundStop {
    public AdventureSoundStop(@NotNull SoundStop wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @Nullable
    public ResourceLocation soundKey() {
        Key sound = ((SoundStop)this.wrappedObject).sound();
        if (sound == null) {
            return null;
        }
        return ResourceLocation.of(sound.namespace(), sound.value());
    }

    @Override
    @Nullable
    public SoundSource source() {
        Sound.Source source = ((SoundStop)this.wrappedObject).source();
        return source == null ? null : new AdventureSoundSource(source);
    }

    @Override
    public @NotNull sba.sl.spectator.sound.SoundStop withSoundKey(@Nullable ResourceLocation soundKey) {
        return this.toBuilder().soundKey(soundKey).build();
    }

    @Override
    public @NotNull sba.sl.spectator.sound.SoundStop withSource(@Nullable SoundSource source) {
        return this.toBuilder().source(source).build();
    }

    @Override
    public  @NotNull SoundStop.Builder toBuilder() {
        return new AdventureSoundStopBuilder(this.soundKey(), this.source());
    }

    public static class AdventureSoundStopBuilder
    implements SoundStop.Builder {
        @Nullable
        private ResourceLocation soundKey;
        @Nullable
        private SoundSource source;

        @Override
        @NotNull
        public SoundStop.Builder soundKey(@Nullable ResourceLocation key) {
            if (key == null) {
                this.soundKey = null;
                return this;
            }
            this.soundKey = "minecraft".equals(key.namespace()) ? ResourceLocation.of("minecraft", AdventureBackend.getSoundKeyNormalizer().apply(key.path())) : key;
            return this;
        }

        @Override
        @NotNull
        public SoundStop.Builder soundKey(@Nullable String key) {
            if (key == null) {
                this.soundKey = null;
                return this;
            }
            return this.soundKey(ResourceLocation.of(key));
        }

        @Override
        public @NotNull sba.sl.spectator.sound.SoundStop build() {
            if (this.soundKey == null && this.source == null) {
                return new AdventureSoundStop(SoundStop.all());
            }
            if (this.source == null) {
                return new AdventureSoundStop(SoundStop.named(Key.key(this.soundKey.namespace(), this.soundKey.path())));
            }
            if (this.soundKey == null) {
                return new AdventureSoundStop(SoundStop.source(this.source.as(Sound.Source.class)));
            }
            return new AdventureSoundStop(SoundStop.namedOnSource(Key.key(this.soundKey.namespace(), this.soundKey.path()), this.source.as(Sound.Source.class)));
        }

        @Generated
        public AdventureSoundStopBuilder() {
        }

        @Generated
        public AdventureSoundStopBuilder(@Nullable ResourceLocation soundKey, @Nullable SoundSource source) {
            this.soundKey = soundKey;
            this.source = source;
        }

        @Override
        @Generated
        public AdventureSoundStopBuilder source(@Nullable SoundSource source) {
            this.source = source;
            return this;
        }
    }
}

