/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit;

import java.util.Locale;
import java.util.Map;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import sba.sl.impl.ItemBlockIdsRemapper;
import sba.sl.impl.block.BlockRegistry;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.block.BukkitBlock1_8;
import sba.sl.impl.bukkit.block.BukkitBlockRegistry1_8;
import sba.sl.impl.bukkit.item.BukkitItemType1_8;
import sba.sl.impl.bukkit.item.BukkitItemTypeRegistry1_8;
import sba.sl.impl.bukkit.utils.Version;
import sba.sl.impl.item.ItemTypeRegistry;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostConstruct;

@Service
public class BukkitItemBlockIdsRemapper
extends ItemBlockIdsRemapper {
    public BukkitItemBlockIdsRemapper(@NotNull ItemTypeRegistry itemTypeMapper, @NotNull BlockRegistry blockTypeMapper) {
        super(itemTypeMapper, blockTypeMapper);
        if (!BukkitFeature.COLORED_BEDS.isSupported()) {
            this.mappingFlags.add(ItemBlockIdsRemapper.MappingFlags.NO_COLORED_BEDS);
        }
    }

    @Override
    @OnPostConstruct
    public void doMapping() {
        if (!BukkitFeature.FLATTENING.isSupported()) {
            this.flatteningLegacyMappingJava();
        }
        super.doMapping();
    }

    private void flatteningLegacyMappingJava() {
        this.f2l("AIR");
        this.f2l("STONE");
        this.f2l("GRANITE", "STONE", 1);
        this.f2l("POLISHED_GRANITE", "STONE", 2);
        this.f2l("DIORITE", "STONE", 3);
        this.f2l("POLISHED_DIORITE", "STONE", 4);
        this.f2l("ANDESITE", "STONE", 5);
        this.f2l("POLISHED_ANDESITE", "STONE", 6);
        this.f2l("GRASS_BLOCK", "GRASS");
        this.f2l("DIRT");
        this.f2l("COARSE_DIRT", "DIRT", 1);
        this.f2l("PODZOL", "DIRT", 2);
        this.f2l("COBBLESTONE");
        this.f2l("OAK_PLANKS", "WOOD");
        this.f2l("SPRUCE_PLANKS", "WOOD", 1);
        this.f2l("BIRCH_PLANKS", "WOOD", 2);
        this.f2l("JUNGLE_PLANKS", "WOOD", 3);
        this.f2l("ACACIA_PLANKS", "WOOD", 4);
        this.f2l("DARK_OAK_PLANKS", "WOOD", 5);
        this.f2l("OAK_SAPLING", "SAPLING");
        this.f2l("SPRUCE_SAPLING", "SAPLING", 1);
        this.f2l("BIRCH_SAPLING", "SAPLING", 2);
        this.f2l("JUNGLE_SAPLING", "SAPLING", 3);
        this.f2l("ACACIA_SAPLING", "SAPLING", 4);
        this.f2l("DARK_OAK_SAPLING", "SAPLING", 5);
        this.f2l("BEDROCK");
        this.f2lBlock("WATER");
        this.f2lBlock("LAVA");
        this.f2l("SAND");
        this.f2l("RED_SAND", "SAND", 1);
        this.f2l("GRAVEL");
        this.f2l("GOLD_ORE");
        this.f2l("IRON_ORE");
        this.f2l("COAL_ORE");
        this.f2l("OAK_LOG", "LOG", 0);
        this.f2l("SPRUCE_LOG", "LOG", 1);
        this.f2l("BIRCH_LOG", "LOG", 2);
        this.f2l("JUNGLE_LOG", "LOG", 3);
        this.f2l("OAK_WOOD", "LOG", 12);
        this.f2l("SPRUCE_WOOD", "LOG", 13);
        this.f2l("BIRCH_WOOD", "LOG", 14);
        this.f2l("JUNGLE_WOOD", "LOG", 15);
        this.f2l("OAK_LEAVES", "LEAVES", 0);
        this.f2l("SPRUCE_LEAVES", "LEAVES", 1);
        this.f2l("BIRCH_LEAVES", "LEAVES", 2);
        this.f2l("JUNGLE_LEAVES", "LEAVES", 3);
        this.f2l("SPONGE");
        this.f2l("WET_SPONGE", "SPONGE", 1);
        this.f2l("GLASS");
        this.f2l("LAPIS_ORE");
        this.f2l("LAPIS_BLOCK");
        this.f2l("DISPENSER");
        this.f2l("SANDSTONE");
        this.f2l("CHISELED_SANDSTONE", "SANDSTONE", 1);
        this.f2l("CUT_SANDSTONE", "SANDSTONE", 2);
        this.f2l("NOTE_BLOCK");
        if (this.mappingFlags.contains((Object)ItemBlockIdsRemapper.MappingFlags.NO_COLORED_BEDS)) {
            this.f2lBlock("RED_BED", "BED_BLOCK");
            this.f2lColoredToNonColoredBlock("BED", "BED_BLOCK");
        } else {
            this.f2lBlock("WHITE_BED", "BED_BLOCK", 0, 0);
            this.f2lBlock("ORANGE_BED", "BED_BLOCK", 0, 1);
            this.f2lBlock("MAGENTA_BED", "BED_BLOCK", 0, 2);
            this.f2lBlock("LIGHT_BLUE_BED", "BED_BLOCK", 0, 3);
            this.f2lBlock("YELLOW_BED", "BED_BLOCK", 0, 4);
            this.f2lBlock("LIME_BED", "BED_BLOCK", 0, 5);
            this.f2lBlock("PINK_BED", "BED_BLOCK", 0, 6);
            this.f2lBlock("GRAY_BED", "BED_BLOCK", 0, 7);
            this.f2lBlock("LIGHT_GRAY_BED", "BED_BLOCK", 0, 8);
            this.f2lBlock("CYAN_BED", "BED_BLOCK", 0, 9);
            this.f2lBlock("PURPLE_BED", "BED_BLOCK", 0, 10);
            this.f2lBlock("BLUE_BED", "BED_BLOCK", 0, 11);
            this.f2lBlock("BROWN_BED", "BED_BLOCK", 0, 12);
            this.f2lBlock("GREEN_BED", "BED_BLOCK", 0, 13);
            this.f2lBlock("RED_BED", "BED_BLOCK", 0, 14);
            this.f2lBlock("BLACK_BED", "BED_BLOCK", 0, 15);
        }
        this.f2l("POWERED_RAIL");
        this.f2l("DETECTOR_RAIL");
        this.f2l("STICKY_PISTON", "PISTON_STICKY_BASE");
        this.f2l("COBWEB", "WEB");
        this.f2l("DEAD_BUSH");
        this.f2l("DEAD_BUSH", "LONG_GRASS");
        this.f2l("GRASS", "LONG_GRASS", 1);
        this.f2l("FERN", "LONG_GRASS", 2);
        this.f2l("DEAD_BUSH", "LONG_GRASS", 3);
        this.f2l("PISTON", "PISTON_BASE");
        this.f2lBlock("PISTON_HEAD", "PISTON_EXTENSION");
        this.f2lColored("WOOL");
        this.f2lBlock("MOVING_PISTON", "PISTON_MOVING_PIECE", 0);
        this.f2l("DANDELION", "YELLOW_FLOWER", 0);
        this.f2l("POPPY", "RED_ROSE");
        this.f2l("BLUE_ORCHID", "RED_ROSE", 1);
        this.f2l("ALLIUM", "RED_ROSE", 2);
        this.f2l("AZURE_BLUET", "RED_ROSE", 3);
        this.f2l("RED_TULIP", "RED_ROSE", 4);
        this.f2l("ORANGE_TULIP", "RED_ROSE", 5);
        this.f2l("WHITE_TULIP", "RED_ROSE", 6);
        this.f2l("PINK_TULIP", "RED_ROSE", 7);
        this.f2l("OXEYE_DAISY", "RED_ROSE", 8);
        this.f2l("BROWN_MUSHROOM");
        this.f2l("RED_MUSHROOM");
        this.f2l("GOLD_BLOCK");
        this.f2l("IRON_BLOCK");
        this.f2l("SMOOTH_STONE_SLAB", "STEP", 0);
        this.f2l("SANDSTONE_SLAB", "STEP", 1);
        this.f2l("PETRIFIED_OAK_SLAB", "STEP", 2);
        this.f2l("COBBLESTONE_SLAB", "STEP", 3);
        this.f2l("BRICK_SLAB", "STEP", 4);
        this.f2l("STONE_BRICK_SLAB", "STEP", 5);
        this.f2l("NETHER_BRICK_SLAB", "STEP", 6);
        this.f2l("QUARTZ_SLAB", "STEP", 7);
        this.f2l("BRICKS", "BRICK");
        this.f2l("TNT");
        this.f2l("BOOKSHELF");
        this.f2l("MOSSY_COBBLESTONE");
        this.f2l("OBSIDIAN");
        this.f2lItem("TORCH");
        this.f2lBlock("WALL_TORCH", "TORCH", 4);
        this.f2lBlock("TORCH", "TORCH", 5);
        this.f2lBlock("FIRE");
        this.f2l("SPAWNER", "MOB_SPAWNER");
        this.f2l("OAK_STAIRS", "WOOD_STAIRS");
        this.f2lItem("CHEST");
        this.f2lBlock("CHEST", "CHEST", 2);
        this.f2lBlock("REDSTONE_WIRE");
        this.f2l("DIAMOND_ORE");
        this.f2l("DIAMOND_BLOCK");
        this.f2l("CRAFTING_TABLE", "WORKBENCH");
        this.f2lBlock("WHEAT", "CROPS");
        this.f2l("FARMLAND", "SOIL");
        this.f2lItem("FURNACE");
        this.f2lBlock("FURNACE", "FURNACE", 2);
        this.f2lBlock("OAK_SIGN", "SIGN_POST");
        this.f2lBlock("OAK_DOOR", "WOODEN_DOOR", 64);
        this.f2lItem("LADDER");
        this.f2lBlock("LADDER", "LADDER", 2);
        this.f2l("RAIL", "RAILS");
        this.f2l("COBBLESTONE_STAIRS");
        this.f2lBlock("OAK_WALL_SIGN", "WALL_SIGN");
        this.f2l("LEVER");
        this.f2l("STONE_PRESSURE_PLATE", "STONE_PLATE");
        this.f2lBlock("IRON_DOOR", "IRON_DOOR_BLOCK");
        this.f2l("OAK_PRESSURE_PLATE", "WOOD_PLATE");
        this.f2l("REDSTONE_ORE");
        this.f2lItem("REDSTONE_TORCH", "REDSTONE_TORCH_ON");
        this.f2lBlock("WALL_REDSTONE_TORCH", "REDSTONE_TORCH_ON", 4);
        this.f2lBlock("REDSTONE_TORCH", "REDSTONE_TORCH_ON", 5);
        this.f2l("STONE_BUTTON");
        this.f2l("SNOW");
        this.f2l("ICE");
        this.f2l("SNOW_BLOCK");
        this.f2l("CACTUS");
        this.f2l("CLAY");
        this.f2lBlock("SUGAR_CANE", "SUGAR_CANE_BLOCK");
        this.f2l("JUKEBOX");
        this.f2l("OAK_FENCE", "FENCE");
        this.f2l("PUMPKIN");
        this.f2l("CARVED_PUMPKIN", "PUMPKIN");
        this.f2l("NETHERRACK");
        this.f2l("SOUL_SAND");
        this.f2l("GLOWSTONE");
        this.f2lBlock("NETHER_PORTAL", "PORTAL", 1);
        this.f2l("JACK_O_LANTERN");
        this.f2lBlock("CAKE", "CAKE_BLOCK");
        this.f2lBlock("REPEATER", "DIODE_BLOCK_OFF");
        this.f2lColored("STAINED_GLASS");
        this.f2l("OAK_TRAPDOOR", "TRAP_DOOR");
        this.f2l("INFESTED_STONE", "MONSTER_EGGS", 0);
        this.f2l("INFESTED_COBBLESTONE", "MONSTER_EGGS", 1);
        this.f2l("INFESTED_STONE_BRICKS", "MONSTER_EGGS", 2);
        this.f2l("INFESTED_MOSSY_STONE_BRICKS", "MONSTER_EGGS", 3);
        this.f2l("INFESTED_CRACKED_STONE_BRICKS", "MONSTER_EGGS", 4);
        this.f2l("INFESTED_CHISELED_STONE_BRICKS", "MONSTER_EGGS", 5);
        this.f2l("STONE_BRICKS", "SMOOTH_BRICK", 0);
        this.f2l("MOSSY_STONE_BRICKS", "SMOOTH_BRICK", 1);
        this.f2l("CRACKED_STONE_BRICKS", "SMOOTH_BRICK", 2);
        this.f2l("CHISELED_STONE_BRICKS", "SMOOTH_BRICK", 3);
        this.f2l("BROWN_MUSHROOM_BLOCK", "HUGE_MUSHROOM_1");
        this.f2l("RED_MUSHROOM_BLOCK", "HUGE_MUSHROOM_2");
        this.f2l("IRON_BARS", "IRON_FENCE");
        this.f2l("GLASS_PANE", "THIN_GLASS");
        this.f2l("MELON", "MELON_BLOCK");
        this.f2lBlock("PUMPKIN_STEM");
        this.f2lBlock("MELON_STEM");
        this.f2l("VINE");
        this.f2l("OAK_FENCE_GATE", "FENCE_GATE");
        this.f2l("BRICK_STAIRS");
        this.f2l("STONE_BRICK_STAIRS", "SMOOTH_STAIRS");
        this.f2l("MYCELIUM", "MYCEL");
        this.f2l("LILY_PAD", "WATER_LILY");
        this.f2l("NETHER_BRICKS", "NETHER_BRICK");
        this.f2l("NETHER_BRICK_FENCE", "NETHER_FENCE");
        this.f2l("NETHER_BRICK_STAIRS");
        this.f2lBlock("NETHER_WART", "NETHER_WARTS");
        this.f2l("ENCHANTING_TABLE", "ENCHANTMENT_TABLE");
        this.f2lBlock("BREWING_STAND");
        this.f2lBlock("CAULDRON");
        this.f2lBlock("END_PORTAL", "ENDER_PORTAL");
        this.f2lBlock("END_PORTAL_FRAME", "ENDER_PORTAL_FRAME");
        this.f2l("END_STONE", "ENDER_STONE");
        this.f2l("DRAGON_EGG");
        this.f2l("REDSTONE_LAMP", "REDSTONE_LAMP_OFF");
        this.f2l("OAK_SLAB", "WOOD_STEP", 0);
        this.f2l("SPRUCE_SLAB", "WOOD_STEP", 1);
        this.f2l("BIRCH_SLAB", "WOOD_STEP", 2);
        this.f2l("JUNGLE_SLAB", "WOOD_STEP", 3);
        this.f2l("ACACIA_SLAB", "WOOD_STEP", 4);
        this.f2l("DARK_OAK_SLAB", "WOOD_STEP", 5);
        this.f2lBlock("COCOA");
        this.f2l("SANDSTONE_STAIRS");
        this.f2l("EMERALD_ORE");
        this.f2lItem("ENDER_CHEST");
        this.f2lBlock("ENDER_CHEST", "ENDER_CHEST", 2);
        this.f2l("TRIPWIRE_HOOK");
        this.f2lBlock("TRIPWIRE");
        this.f2l("EMERALD_BLOCK");
        this.f2l("SPRUCE_STAIRS", "SPRUCE_WOOD_STAIRS");
        this.f2l("BIRCH_STAIRS", "BIRCH_WOOD_STAIRS");
        this.f2l("JUNGLE_STAIRS", "JUNGLE_WOOD_STAIRS");
        this.f2l("COMMAND_BLOCK", "COMMAND");
        this.f2l("BEACON");
        this.f2l("COBBLESTONE_WALL", "COBBLE_WALL");
        this.f2l("MOSSY_COBBLESTONE_WALL", "COBBLE_WALL", 1);
        this.f2lBlock("FLOWER_POT");
        this.f2lBlock("POTTED_POPPY", "FLOWER_POT", 0, 608);
        this.f2lBlock("POTTED_DANDELION", "FLOWER_POT", 0, 592);
        this.f2lBlock("POTTED_OAK_SAPLING", "FLOWER_POT", 0, 96);
        this.f2lBlock("POTTED_SPRUCE_SAPLING", "FLOWER_POT", 0, 97);
        this.f2lBlock("POTTED_BIRCH_SAPLING", "FLOWER_POT", 0, 98);
        this.f2lBlock("POTTED_JUNGLE_SAPLING", "FLOWER_POT", 0, 99);
        this.f2lBlock("POTTED_RED_MUSHROOM", "FLOWER_POT", 0, 640);
        this.f2lBlock("POTTED_BROWN_MUSHROOM", "FLOWER_POT", 0, 624);
        this.f2lBlock("POTTED_CACTUS", "FLOWER_POT", 0, 1296);
        this.f2lBlock("POTTED_DEAD_BUSH", "FLOWER_POT", 0, 512);
        this.f2lBlock("POTTED_FERN", "FLOWER_POT", 0, 498);
        this.f2lBlock("POTTED_ACACIA_SAPLING", "FLOWER_POT", 0, 100);
        this.f2lBlock("POTTED_DARK_OAK_SAPLING", "FLOWER_POT", 0, 101);
        this.f2lBlock("POTTED_BLUE_ORCHID", "FLOWER_POT", 0, 609);
        this.f2lBlock("POTTED_ALLIUM", "FLOWER_POT", 0, 610);
        this.f2lBlock("POTTED_AZURE_BLUET", "FLOWER_POT", 0, 611);
        this.f2lBlock("POTTED_RED_TULIP", "FLOWER_POT", 0, 612);
        this.f2lBlock("POTTED_ORANGE_TULIP", "FLOWER_POT", 0, 613);
        this.f2lBlock("POTTED_WHITE_TULIP", "FLOWER_POT", 0, 614);
        this.f2lBlock("POTTED_PINK_TULIP", "FLOWER_POT", 0, 615);
        this.f2lBlock("POTTED_OXEYE_DAISY", "FLOWER_POT", 0, 616);
        this.f2lBlock("CARROTS", "CARROT");
        this.f2lBlock("POTATOES", "POTATO");
        this.f2l("OAK_BUTTON", "WOOD_BUTTON");
        this.f2lBlock("SKELETON_SKULL", "SKULL", 1);
        this.f2lBlock("WITHER_SKELETON_SKULL", "SKULL", 1, 1);
        this.f2lBlock("ZOMBIE_HEAD", "SKULL", 1, 2);
        this.f2lBlock("PLAYER_HEAD", "SKULL", 1, 3);
        this.f2lBlock("CREEPER_HEAD", "SKULL", 1, 4);
        if (Version.isVersion(1, 9)) {
            this.f2lBlock("DRAGON_HEAD", "SKULL", 1, 5);
        }
        this.f2lBlock("SKELETON_WALL_SKULL", "SKULL", 2);
        this.f2lBlock("WITHER_SKELETON_WALL_SKULL", "SKULL", 2, 1);
        this.f2lBlock("ZOMBIE_WALL_HEAD", "SKULL", 2, 2);
        this.f2lBlock("PLAYER_WALL_HEAD", "SKULL", 2, 3);
        this.f2lBlock("CREEPER_WALL_HEAD", "SKULL", 2, 4);
        if (Version.isVersion(1, 9)) {
            this.f2lBlock("DRAGON_WALL_HEAD", "SKULL", 2, 5);
        }
        this.f2l("ANVIL");
        this.f2lItem("CHIPPED_ANVIL", "ANVIL", 1);
        this.f2lBlock("CHIPPED_ANVIL", "ANVIL", 4);
        this.f2lItem("DAMAGED_ANVIL", "ANVIL", 2);
        this.f2lBlock("DAMAGED_ANVIL", "ANVIL", 8);
        this.f2lItem("TRAPPED_CHEST");
        this.f2lBlock("TRAPPED_CHEST", "TRAPPED_CHEST", 2);
        this.f2l("LIGHT_WEIGHTED_PRESSURE_PLATE", "GOLD_PLATE");
        this.f2l("HEAVY_WEIGHTED_PRESSURE_PLATE", "IRON_PLATE");
        this.f2lBlock("COMPARATOR", "REDSTONE_COMPARATOR_OFF");
        this.f2l("DAYLIGHT_DETECTOR");
        this.f2l("REDSTONE_BLOCK");
        this.f2l("NETHER_QUARTZ_ORE", "QUARTZ_ORE");
        this.f2l("HOPPER");
        this.f2l("QUARTZ_BLOCK");
        this.f2l("CHISELED_QUARTZ_BLOCK", "QUARTZ_BLOCK", 1);
        this.f2l("QUARTZ_PILLAR", "QUARTZ_BLOCK", 2);
        this.f2l("QUARTZ_STAIRS");
        this.f2l("ACTIVATOR_RAIL");
        this.f2l("DROPPER");
        this.f2lColored("TERRACOTTA", "STAINED_CLAY");
        this.f2lColored("STAINED_GLASS_PANE");
        this.f2l("ACACIA_LEAVES", "LEAVES_2", 0);
        this.f2l("DARK_OAK_LEAVES", "LEAVES_2", 1);
        this.f2l("ACACIA_LOG", "LOG_2", 0);
        this.f2l("DARK_OAK_LOG", "LOG_2", 1);
        this.f2l("ACACIA_WOOD", "LOG_2", 12);
        this.f2l("DARK_OAK_WOOD", "LOG_2", 13);
        this.f2l("ACACIA_STAIRS");
        this.f2l("DARK_OAK_STAIRS");
        this.f2l("SLIME_BLOCK");
        this.f2l("BARRIER");
        this.f2l("IRON_TRAPDOOR");
        this.f2l("PRISMARINE");
        this.f2l("PRISMARINE_BRICKS", "PRISMARINE", 1);
        this.f2l("DARK_PRISMARINE", "PRISMARINE", 2);
        this.f2l("SEA_LANTERN");
        this.f2l("HAY_BLOCK");
        this.f2lColored("CARPET");
        this.f2l("TERRACOTTA", "HARD_CLAY");
        this.f2l("COAL_BLOCK");
        this.f2l("PACKED_ICE");
        this.f2l("SUNFLOWER", "DOUBLE_PLANT", 0);
        this.f2l("LILAC", "DOUBLE_PLANT", 1);
        this.f2l("TALL_GRASS", "DOUBLE_PLANT", 2);
        this.f2l("LARGE_FERN", "DOUBLE_PLANT", 3);
        this.f2l("ROSE_BUSH", "DOUBLE_PLANT", 4);
        this.f2l("PEONY", "DOUBLE_PLANT", 5);
        this.f2lColoredToNonColoredBlock("BANNER", "STANDING_BANNER");
        this.f2lColoredToNonColoredBlock("WALL_BANNER");
        this.f2l("RED_SANDSTONE");
        this.f2l("CHISELED_RED_SANDSTONE", "RED_SANDSTONE", 1);
        this.f2l("CUT_RED_SANDSTONE", "RED_SANDSTONE", 2);
        this.f2l("RED_SANDSTONE_STAIRS");
        this.f2l("SMOOTH_RED_SANDSTONE", "DOUBLE_STONE_SLAB2");
        this.f2l("RED_SANDSTONE_SLAB", "STONE_SLAB2");
        this.f2l("SPRUCE_FENCE_GATE");
        this.f2l("BIRCH_FENCE_GATE");
        this.f2l("JUNGLE_FENCE_GATE");
        this.f2l("DARK_OAK_FENCE_GATE");
        this.f2l("ACACIA_FENCE_GATE");
        this.f2l("SPRUCE_FENCE");
        this.f2l("BIRCH_FENCE");
        this.f2l("JUNGLE_FENCE");
        this.f2l("DARK_OAK_FENCE");
        this.f2l("ACACIA_FENCE");
        this.f2lBlock("SPRUCE_DOOR");
        this.f2lBlock("BIRCH_DOOR");
        this.f2lBlock("JUNGLE_DOOR");
        this.f2lBlock("ACACIA_DOOR");
        this.f2lBlock("DARK_OAK_DOOR");
        this.f2l("END_ROD");
        this.f2l("CHORUS_PLANT");
        this.f2l("CHORUS_FLOWER");
        this.f2l("PURPUR_BLOCK");
        this.f2l("PURPUR_PILLAR");
        this.f2l("PURPUR_STAIRS");
        this.f2l("PURPUR_SLAB");
        this.f2l("END_STONE_BRICKS", "END_BRICKS");
        this.f2lBlock("BEETROOTS", "BEETROOT_BLOCK");
        this.f2l("GRASS_PATH");
        this.f2lBlock("END_GATEWAY");
        this.f2l("REPEATING_COMMAND_BLOCK", "COMMAND_REPEATING");
        this.f2l("CHAIN_COMMAND_BLOCK", "COMMAND_CHAIN");
        this.f2l("FROSTED_ICE");
        this.f2l("MAGMA_BLOCK", "MAGMA");
        this.f2l("NETHER_WART_BLOCK");
        this.f2l("RED_NETHER_BRICKS", "RED_NETHER_BRICK");
        this.f2l("BONE_BLOCK");
        this.f2l("STRUCTURE_VOID");
        this.f2l("OBSERVER");
        this.f2l("WHITE_SHULKER_BOX");
        this.f2l("ORANGE_SHULKER_BOX");
        this.f2l("MAGENTA_SHULKER_BOX");
        this.f2l("LIGHT_BLUE_SHULKER_BOX");
        this.f2l("YELLOW_SHULKER_BOX");
        this.f2l("LIME_SHULKER_BOX");
        this.f2l("PINK_SHULKER_BOX");
        this.f2l("GRAY_SHULKER_BOX");
        this.f2l("LIGHT_GRAY_SHULKER_BOX", "SILVER_SHULKER_BOX");
        this.f2l("CYAN_SHULKER_BOX");
        this.f2l("PURPLE_SHULKER_BOX");
        this.f2l("BLUE_SHULKER_BOX");
        this.f2l("BROWN_SHULKER_BOX");
        this.f2l("GREEN_SHULKER_BOX");
        this.f2l("RED_SHULKER_BOX");
        this.f2l("BLACK_SHULKER_BOX");
        this.f2l("WHITE_GLAZED_TERRACOTTA");
        this.f2l("ORANGE_GLAZED_TERRACOTTA");
        this.f2l("MAGENTA_GLAZED_TERRACOTTA");
        this.f2l("LIGHT_BLUE_GLAZED_TERRACOTTA");
        this.f2l("YELLOW_GLAZED_TERRACOTTA");
        this.f2l("LIME_GLAZED_TERRACOTTA");
        this.f2l("PINK_GLAZED_TERRACOTTA");
        this.f2l("GRAY_GLAZED_TERRACOTTA");
        this.f2l("LIGHT_GRAY_GLAZED_TERRACOTTA", "SILVER_GLAZED_TERRACOTTA");
        this.f2l("CYAN_GLAZED_TERRACOTTA");
        this.f2l("PURPLE_GLAZED_TERRACOTTA");
        this.f2l("BLUE_GLAZED_TERRACOTTA");
        this.f2l("BROWN_GLAZED_TERRACOTTA");
        this.f2l("GREEN_GLAZED_TERRACOTTA");
        this.f2l("RED_GLAZED_TERRACOTTA");
        this.f2l("BLACK_GLAZED_TERRACOTTA");
        this.f2lColored("CONCRETE");
        this.f2lColored("CONCRETE_POWDER");
        this.f2l("STRUCTURE_BLOCK");
        this.f2lItem("IRON_SHOVEL", "IRON_SPADE");
        this.f2lItem("IRON_PICKAXE");
        this.f2lItem("IRON_AXE");
        this.f2lItem("FLINT_AND_STEEL");
        this.f2lItem("APPLE");
        this.f2lItem("BOW");
        this.f2lItem("ARROW");
        this.f2lItem("COAL");
        this.f2lItem("CHARCOAL", "COAL", 1);
        this.f2lItem("DIAMOND");
        this.f2lItem("IRON_INGOT");
        this.f2lItem("GOLD_INGOT");
        this.f2lItem("IRON_SWORD");
        this.f2lItem("WOODEN_SWORD", "WOOD_SWORD");
        this.f2lItem("WOODEN_SHOVEL", "WOOD_SPADE");
        this.f2lItem("WOODEN_PICKAXE", "WOOD_PICKAXE");
        this.f2lItem("WOODEN_AXE", "WOOD_AXE");
        this.f2lItem("STONE_SWORD");
        this.f2lItem("STONE_SHOVEL", "STONE_SPADE");
        this.f2lItem("STONE_PICKAXE");
        this.f2lItem("STONE_AXE");
        this.f2lItem("DIAMOND_SWORD");
        this.f2lItem("DIAMOND_SHOVEL", "DIAMOND_SPADE");
        this.f2lItem("DIAMOND_PICKAXE");
        this.f2lItem("DIAMOND_AXE");
        this.f2lItem("STICK");
        this.f2lItem("BOWL");
        this.f2lItem("MUSHROOM_STEW", "MUSHROOM_SOUP");
        this.f2lItem("GOLDEN_SWORD", "GOLD_SWORD");
        this.f2lItem("GOLDEN_SHOVEL", "GOLD_SPADE");
        this.f2lItem("GOLDEN_PICKAXE", "GOLD_PICKAXE");
        this.f2lItem("GOLDEN_AXE", "GOLD_AXE");
        this.f2lItem("STRING");
        this.f2lItem("FEATHER");
        this.f2lItem("GUNPOWDER", "SULPHUR");
        this.f2lItem("WOODEN_HOE", "WOOD_HOE");
        this.f2lItem("STONE_HOE");
        this.f2lItem("IRON_HOE");
        this.f2lItem("DIAMOND_HOE");
        this.f2lItem("GOLDEN_HOE", "GOLD_HOE");
        this.f2lItem("WHEAT_SEEDS", "SEEDS");
        this.f2lItem("WHEAT");
        this.f2lItem("BREAD");
        this.f2lItem("LEATHER_HELMET");
        this.f2lItem("LEATHER_CHESTPLATE");
        this.f2lItem("LEATHER_LEGGINGS");
        this.f2lItem("LEATHER_BOOTS");
        this.f2lItem("CHAINMAIL_HELMET");
        this.f2lItem("CHAINMAIL_CHESTPLATE");
        this.f2lItem("CHAINMAIL_LEGGINGS");
        this.f2lItem("CHAINMAIL_BOOTS");
        this.f2lItem("IRON_HELMET");
        this.f2lItem("IRON_CHESTPLATE");
        this.f2lItem("IRON_LEGGINGS");
        this.f2lItem("IRON_BOOTS");
        this.f2lItem("DIAMOND_HELMET");
        this.f2lItem("DIAMOND_CHESTPLATE");
        this.f2lItem("DIAMOND_LEGGINGS");
        this.f2lItem("DIAMOND_BOOTS");
        this.f2lItem("GOLDEN_HELMET", "GOLD_HELMET");
        this.f2lItem("GOLDEN_CHESTPLATE", "GOLD_CHESTPLATE");
        this.f2lItem("GOLDEN_LEGGINGS", "GOLD_LEGGINGS");
        this.f2lItem("GOLDEN_BOOTS", "GOLD_BOOTS");
        this.f2lItem("FLINT");
        this.f2lItem("PORKCHOP", "PORK");
        this.f2lItem("COOKED_PORKCHOP", "GRILLED_PORK");
        this.f2lItem("PAINTING");
        this.f2lItem("GOLDEN_APPLE");
        this.f2lItem("ENCHANTED_GOLDEN_APPLE", "GOLDEN_APPLE", 1);
        this.f2lItem("OAK_SIGN", "SIGN");
        this.f2lItem("OAK_DOOR", "WOOD_DOOR");
        this.f2lItem("BUCKET");
        this.f2lItem("WATER_BUCKET");
        this.f2lItem("LAVA_BUCKET");
        this.f2lItem("MINECART");
        this.f2lItem("SADDLE");
        this.f2lItem("IRON_DOOR");
        this.f2lItem("REDSTONE");
        this.f2lItem("SNOWBALL", "SNOW_BALL");
        this.f2lItem("OAK_BOAT", "BOAT");
        this.f2lItem("LEATHER");
        this.f2lItem("MILK_BUCKET");
        this.f2lItem("BRICK", "CLAY_BRICK");
        this.f2lItem("CLAY_BALL");
        this.f2lItem("SUGAR_CANE");
        this.f2lItem("PAPER");
        this.f2lItem("BOOK");
        this.f2lItem("SLIME_BALL");
        this.f2lItem("CHEST_MINECART", "STORAGE_MINECART");
        this.f2lItem("FURNACE_MINECART", "POWERED_MINECART");
        this.f2lItem("EGG");
        this.f2lItem("COMPASS");
        this.f2lItem("FISHING_ROD");
        this.f2lItem("CLOCK", "WATCH");
        this.f2lItem("GLOWSTONE_DUST");
        this.f2lItem("COD", "RAW_FISH");
        this.f2lItem("SALMON", "RAW_FISH", 1);
        this.f2lItem("TROPICAL_FISH", "RAW_FISH", 2);
        this.f2lItem("PUFFERFISH", "RAW_FISH", 3);
        this.f2lItem("COOKED_COD", "COOKED_FISH");
        this.f2lItem("COOKED_SALMON", "COOKED_FISH", 1);
        this.f2lItem("INK_SACK");
        this.f2lItem("ROSE_RED", "INK_SACK", 1);
        this.f2lItem("CACTUS_GREEN", "INK_SACK", 2);
        this.f2lItem("COCOA_BEANS", "INK_SACK", 3);
        this.f2lItem("LAPIS_LAZULI", "INK_SACK", 4);
        this.f2lItem("PURPLE_DYE", "INK_SACK", 5);
        this.f2lItem("CYAN_DYE", "INK_SACK", 6);
        this.f2lItem("LIGHT_GRAY_DYE", "INK_SACK", 7);
        this.f2lItem("GRAY_DYE", "INK_SACK", 8);
        this.f2lItem("PINK_DYE", "INK_SACK", 9);
        this.f2lItem("LIME_DYE", "INK_SACK", 10);
        this.f2lItem("DANDELION_YELLOW", "INK_SACK", 11);
        this.f2lItem("LIGHT_BLUE_DYE", "INK_SACK", 12);
        this.f2lItem("MAGENTA_DYE", "INK_SACK", 13);
        this.f2lItem("ORANGE_DYE", "INK_SACK", 14);
        this.f2lItem("BONE_MEAL", "INK_SACK", 15);
        this.f2lItem("BONE");
        this.f2lItem("SUGAR");
        this.f2lItem("CAKE");
        if (this.mappingFlags.contains((Object)ItemBlockIdsRemapper.MappingFlags.NO_COLORED_BEDS)) {
            this.f2lColoredToNonColoredItem("BED");
        } else {
            this.f2lColoredItem("BED");
        }
        this.f2lItem("REPEATER", "DIODE");
        this.f2lItem("COOKIE");
        this.f2lItem("FILLED_MAP", "MAP");
        this.f2lItem("SHEARS");
        this.f2lItem("MELON_SLICE", "MELON");
        this.f2lItem("PUMPKIN_SEEDS");
        this.f2lItem("MELON_SEEDS");
        this.f2lItem("BEEF", "RAW_BEEF");
        this.f2lItem("COOKED_BEEF");
        this.f2lItem("CHICKEN", "RAW_CHICKEN");
        this.f2lItem("COOKED_CHICKEN");
        this.f2lItem("ROTTEN_FLESH");
        this.f2lItem("ENDER_PEARL");
        this.f2lItem("BLAZE_ROD");
        this.f2lItem("GHAST_TEAR");
        this.f2lItem("GOLD_NUGGET");
        this.f2lItem("NETHER_WART", "NETHER_STALK");
        this.f2lItem("POTION");
        this.f2lItem("GLASS_BOTTLE");
        this.f2lItem("SPIDER_EYE");
        this.f2lItem("FERMENTED_SPIDER_EYE");
        this.f2lItem("BLAZE_POWDER");
        this.f2lItem("MAGMA_CREAM");
        this.f2lItem("BREWING_STAND", "BREWING_STAND_ITEM");
        this.f2lItem("CAULDRON", "CAULDRON_ITEM");
        this.f2lItem("ENDER_EYE", "EYE_OF_ENDER");
        this.f2lItem("GLISTERING_MELON_SLICE", "SPECKLED_MELON");
        this.f2lItem("BAT_SPAWN_EGG", "MONSTER_EGG", 65);
        this.f2lItem("BLAZE_SPAWN_EGG", "MONSTER_EGG", 61);
        this.f2lItem("CAVE_SPIDER_SPAWN_EGG", "MONSTER_EGG", 59);
        this.f2lItem("CHICKEN_SPAWN_EGG", "MONSTER_EGG", 93);
        this.f2lItem("COW_SPAWN_EGG", "MONSTER_EGG", 92);
        this.f2lItem("CREEPER_SPAWN_EGG", "MONSTER_EGG", 50);
        this.f2lItem("DONKEY_SPAWN_EGG", "MONSTER_EGG", 31);
        this.f2lItem("ELDER_GUARDIAN_SPAWN_EGG", "MONSTER_EGG", 4);
        this.f2lItem("ENDERMAN_SPAWN_EGG", "MONSTER_EGG", 58);
        this.f2lItem("ENDERMITE_SPAWN_EGG", "MONSTER_EGG", 67);
        this.f2lItem("EVOKER_SPAWN_EGG", "MONSTER_EGG", 34);
        this.f2lItem("GHAST_SPAWN_EGG", "MONSTER_EGG", 56);
        this.f2lItem("GUARDIAN_SPAWN_EGG", "MONSTER_EGG", 68);
        this.f2lItem("HORSE_SPAWN_EGG", "MONSTER_EGG", 100);
        this.f2lItem("HUSK_SPAWN_EGG", "MONSTER_EGG", 23);
        this.f2lItem("LLAMA_SPAWN_EGG", "MONSTER_EGG", 103);
        this.f2lItem("MAGMA_CUBE_SPAWN_EGG", "MONSTER_EGG", 62);
        this.f2lItem("MOOSHROOM_SPAWN_EGG", "MONSTER_EGG", 96);
        this.f2lItem("MULE_SPAWN_EGG", "MONSTER_EGG", 32);
        this.f2lItem("OCELOT_SPAWN_EGG", "MONSTER_EGG", 98);
        this.f2lItem("PARROT_SPAWN_EGG", "MONSTER_EGG", 105);
        this.f2lItem("PIG_SPAWN_EGG", "MONSTER_EGG", 90);
        this.f2lItem("POLAR_BEAR_SPAWN_EGG", "MONSTER_EGG", 102);
        this.f2lItem("RABBIT_SPAWN_EGG", "MONSTER_EGG", 101);
        this.f2lItem("SHEEP_SPAWN_EGG", "MONSTER_EGG", 91);
        this.f2lItem("SHULKER_SPAWN_EGG", "MONSTER_EGG", 69);
        this.f2lItem("SILVERFISH_SPAWN_EGG", "MONSTER_EGG", 60);
        this.f2lItem("SKELETON_SPAWN_EGG", "MONSTER_EGG", 51);
        this.f2lItem("SKELETON_HORSE_SPAWN_EGG", "MONSTER_EGG", 28);
        this.f2lItem("SLIME_SPAWN_EGG", "MONSTER_EGG", 55);
        this.f2lItem("SPIDER_SPAWN_EGG", "MONSTER_EGG", 52);
        this.f2lItem("SQUID_SPAWN_EGG", "MONSTER_EGG", 94);
        this.f2lItem("STRAY_SPAWN_EGG", "MONSTER_EGG", 6);
        this.f2lItem("VEX_SPAWN_EGG", "MONSTER_EGG", 35);
        this.f2lItem("VILLAGER_SPAWN_EGG", "MONSTER_EGG", 120);
        this.f2lItem("VINDICATOR_SPAWN_EGG", "MONSTER_EGG", 36);
        this.f2lItem("WITCH_SPAWN_EGG", "MONSTER_EGG", 66);
        this.f2lItem("WITHER_SKELETON_SPAWN_EGG", "MONSTER_EGG", 5);
        this.f2lItem("WOLF_SPAWN_EGG", "MONSTER_EGG", 95);
        this.f2lItem("ZOMBIE_SPAWN_EGG", "MONSTER_EGG", 54);
        this.f2lItem("ZOMBIE_HORSE_SPAWN_EGG", "MONSTER_EGG", 29);
        this.f2lItem("ZOMBIE_PIGMAN_SPAWN_EGG", "MONSTER_EGG", 57);
        this.f2lItem("ZOMBIE_VILLAGER_SPAWN_EGG", "MONSTER_EGG", 27);
        this.f2lItem("EXPERIENCE_BOTTLE", "EXP_BOTTLE");
        this.f2lItem("FIRE_CHARGE", "FIREBALL");
        this.f2lItem("WRITABLE_BOOK", "BOOK_AND_QUILL");
        this.f2lItem("WRITTEN_BOOK");
        this.f2lItem("EMERALD");
        this.f2lItem("ITEM_FRAME");
        this.f2lItem("FLOWER_POT", "FLOWER_POT_ITEM");
        this.f2lItem("CARROT", "CARROT_ITEM");
        this.f2lItem("POTATO", "POTATO_ITEM");
        this.f2lItem("BAKED_POTATO");
        this.f2lItem("POISONOUS_POTATO");
        this.f2lItem("MAP", "EMPTY_MAP");
        this.f2lItem("GOLDEN_CARROT");
        this.f2lItem("SKELETON_SKULL", "SKULL_ITEM");
        this.f2lItem("WITHER_SKELETON_SKULL", "SKULL_ITEM", 1);
        this.f2lItem("ZOMBIE_HEAD", "SKULL_ITEM", 2);
        this.f2lItem("PLAYER_HEAD", "SKULL_ITEM", 3);
        this.f2lItem("CREEPER_HEAD", "SKULL_ITEM", 4);
        if (Version.isVersion(1, 9)) {
            this.f2lItem("DRAGON_HEAD", "SKULL_ITEM", 5);
        }
        this.f2lItem("CARROT_ON_A_STICK", "CARROT_STICK");
        this.f2lItem("NETHER_STAR");
        this.f2lItem("PUMPKIN_PIE");
        this.f2lItem("FIREWORK_ROCKET", "FIREWORK");
        this.f2lItem("FIREWORK_STAR", "FIREWORK_CHARGE");
        this.f2lItem("ENCHANTED_BOOK");
        this.f2lItem("COMPARATOR", "REDSTONE_COMPARATOR");
        this.f2lItem("NETHER_BRICK", "NETHER_BRICK_ITEM");
        this.f2lItem("QUARTZ");
        this.f2lItem("TNT_MINECART", "EXPLOSIVE_MINECART");
        this.f2lItem("HOPPER_MINECART");
        this.f2lItem("PRISMARINE_SHARD");
        this.f2lItem("PRISMARINE_CRYSTALS");
        this.f2lItem("RABBIT");
        this.f2lItem("COOKED_RABBIT");
        this.f2lItem("RABBIT_STEW");
        this.f2lItem("RABBIT_FOOT");
        this.f2lItem("RABBIT_HIDE");
        this.f2lItem("ARMOR_STAND");
        this.f2lItem("IRON_HORSE_ARMOR", "IRON_BARDING");
        this.f2lItem("GOLDEN_HORSE_ARMOR", "GOLD_BARDING");
        this.f2lItem("DIAMOND_HORSE_ARMOR", "DIAMOND_BARDING");
        this.f2lItem("LEAD", "LEASH");
        this.f2lItem("NAME_TAG");
        this.f2lItem("COMMAND_BLOCK_MINECART", "COMMAND_MINECART");
        this.f2lItem("MUTTON");
        this.f2lItem("COOKED_MUTTON");
        this.f2lColoredItem("BANNER");
        this.f2lItem("END_CRYSTAL");
        this.f2lItem("SPRUCE_DOOR", "SPRUCE_DOOR_ITEM");
        this.f2lItem("BIRCH_DOOR", "BIRCH_DOOR_ITEM");
        this.f2lItem("JUNGLE_DOOR", "JUNGLE_DOOR_ITEM");
        this.f2lItem("ACACIA_DOOR", "ACACIA_DOOR_ITEM");
        this.f2lItem("DARK_OAK_DOOR", "DARK_OAK_DOOR_ITEM");
        this.f2lItem("CHORUS_FRUIT");
        this.f2lItem("POPPED_CHORUS_FRUIT", "CHORUS_FRUIT_POPPED");
        this.f2lItem("BEETROOT");
        this.f2lItem("BEETROOT_SEEDS");
        this.f2lItem("BEETROOT_SOUP");
        this.f2lItem("DRAGONS_BREATH");
        this.f2lItem("SPLASH_POTION");
        this.f2lItem("SPECTRAL_ARROW");
        this.f2lItem("TIPPED_ARROW");
        this.f2lItem("LINGERING_POTION");
        this.f2lItem("SHIELD");
        this.f2lItem("ELYTRA");
        this.f2lItem("SPRUCE_BOAT", "BOAT_SPRUCE");
        this.f2lItem("BIRCH_BOAT", "BOAT_BIRCH");
        this.f2lItem("JUNGLE_BOAT", "BOAT_JUNGLE");
        this.f2lItem("ACACIA_BOAT", "BOAT_ACACIA");
        this.f2lItem("DARK_OAK_BOAT", "BOAT_DARK_OAK");
        this.f2lItem("TOTEM_OF_UNDYING", "TOTEM");
        this.f2lItem("SHULKER_SHELL");
        this.f2lItem("IRON_NUGGET");
        this.f2lItem("KNOWLEDGE_BOOK");
        this.f2lItem("MUSIC_DISC_13", "GOLD_RECORD");
        this.f2lItem("MUSIC_DISC_CAT", "GREEN_RECORD");
        this.f2lItem("MUSIC_DISC_BLOCKS", "RECORD_3");
        this.f2lItem("MUSIC_DISC_CHIRP", "RECORD_4");
        this.f2lItem("MUSIC_DISC_FAR", "RECORD_5");
        this.f2lItem("MUSIC_DISC_MALL", "RECORD_6");
        this.f2lItem("MUSIC_DISC_MELLOHI", "RECORD_7");
        this.f2lItem("MUSIC_DISC_STAL", "RECORD_8");
        this.f2lItem("MUSIC_DISC_STRAD", "RECORD_9");
        this.f2lItem("MUSIC_DISC_WARD", "RECORD_10");
        this.f2lItem("MUSIC_DISC_11", "RECORD_11");
        this.f2lItem("MUSIC_DISC_WAIT", "RECORD_12");
    }

    protected void f2lColored(@NotNull String material) {
        this.f2lColored(material, material);
    }

    protected void f2lColoredBlock(@NotNull String material) {
        this.f2lColoredBlock(material, material);
    }

    protected void f2lColoredItem(@NotNull String material) {
        this.f2lColoredItem(material, material);
    }

    protected void f2lColored(@NotNull String flatteningMaterialSuffix, @NotNull String legacyBukkitMaterial) {
        this.f2lColoredBlock(flatteningMaterialSuffix, legacyBukkitMaterial);
        this.f2lColoredItem(flatteningMaterialSuffix, legacyBukkitMaterial);
    }

    protected void f2lColoredItem(@NotNull String flatteningMaterialSuffix, @NotNull String legacyBukkitMaterial) {
        for (int i = 0; i <= 15; ++i) {
            this.f2lItem((String)COLORS.get(i) + "_" + flatteningMaterialSuffix, legacyBukkitMaterial, i);
        }
    }

    protected void f2lColoredBlock(@NotNull String flatteningMaterialSuffix, @NotNull String legacyBukkitMaterial) {
        for (int i = 0; i <= 15; ++i) {
            this.f2lBlock((String)COLORS.get(i) + "_" + flatteningMaterialSuffix, legacyBukkitMaterial, i);
        }
    }

    protected void f2lColoredToNonColored(@NotNull String material) {
        this.f2lColoredToNonColored(material, material);
    }

    protected void f2lColoredToNonColoredBlock(@NotNull String material) {
        this.f2lColoredToNonColoredBlock(material, material);
    }

    protected void f2lColoredToNonColoredItem(@NotNull String material) {
        this.f2lColoredToNonColoredItem(material, material);
    }

    protected void f2lColoredToNonColoredBlock(@NotNull String flatteningMaterialSuffix, @NotNull String legacyBukkitMaterial) {
        this.f2lColoredToNonColoredBlock(flatteningMaterialSuffix, legacyBukkitMaterial, 0);
    }

    protected void f2lColoredToNonColored(@NotNull String flatteningMaterialSuffix, @NotNull String legacyBukkitMaterial) {
        this.f2lColoredToNonColoredBlock(flatteningMaterialSuffix, legacyBukkitMaterial);
        this.f2lColoredToNonColoredItem(flatteningMaterialSuffix, legacyBukkitMaterial);
    }

    protected void f2lColoredToNonColoredBlock(@NotNull String flatteningMaterialSuffix, @NotNull String legacyBukkitMaterial, int data) {
        COLORS.forEach(s -> this.f2lBlock(s + "_" + flatteningMaterialSuffix, legacyBukkitMaterial, data));
    }

    protected void f2lColoredToNonColoredItem(@NotNull String flatteningMaterialSuffix, @NotNull String legacyBukkitMaterial) {
        COLORS.forEach(s -> this.f2lItem(s + "_" + flatteningMaterialSuffix, legacyBukkitMaterial));
    }

    protected void f2l(@NotNull String material) {
        this.f2l(material, material);
    }

    protected void f2lItem(@NotNull String material) {
        this.f2lItem(material, material);
    }

    protected void f2lBlock(@NotNull String material) {
        this.f2lBlock(material, material);
    }

    protected void f2l(@NotNull String flatteningMaterial, @NotNull String legacyBukkitMaterial) {
        this.f2l(flatteningMaterial, legacyBukkitMaterial, 0);
    }

    protected void f2lItem(@NotNull String flatteningMaterial, @NotNull String legacyBukkitMaterial) {
        this.f2lItem(flatteningMaterial, legacyBukkitMaterial, 0);
    }

    protected void f2lBlock(@NotNull String flatteningMaterial, @NotNull String legacyBukkitMaterial) {
        this.f2lBlock(flatteningMaterial, legacyBukkitMaterial, 0);
    }

    protected void f2l(@NotNull String flatteningMaterial, @NotNull String legacyBukkitMaterial, int data) {
        this.f2lBlock(flatteningMaterial, legacyBukkitMaterial, data);
        this.f2lItem(flatteningMaterial, legacyBukkitMaterial, data);
    }

    protected void f2lItem(@NotNull String flatteningMaterial, @NotNull String legacyBukkitMaterial, int data) {
        ResourceLocation flatteningMaterialNamespaced = ResourceLocation.of(flatteningMaterial);
        if (!(this.itemTypeMapper instanceof BukkitItemTypeRegistry1_8)) {
            return;
        }
        try {
            Map<BukkitItemType1_8, ResourceLocation> locations;
            Material mat = Material.valueOf((String)legacyBukkitMaterial.toUpperCase(Locale.ROOT));
            BukkitItemType1_8 holder = new BukkitItemType1_8(mat, (short)data);
            Map<ResourceLocation, BukkitItemType1_8> mapping = ((BukkitItemTypeRegistry1_8)this.itemTypeMapper).getPorts();
            if (!mapping.containsKey(flatteningMaterialNamespaced)) {
                mapping.put(flatteningMaterialNamespaced, holder);
            }
            if (!(locations = ((BukkitItemTypeRegistry1_8)this.itemTypeMapper).getResourceLocations()).containsKey(holder)) {
                locations.put(holder, flatteningMaterialNamespaced);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void f2lBlock(@NotNull String flatteningMaterial, @NotNull String legacyBukkitMaterial, int data) {
        this.f2lBlock(flatteningMaterial, legacyBukkitMaterial, data, 0);
    }

    protected void f2lBlock(@NotNull String flatteningMaterial, @NotNull String legacyBukkitMaterial, int data, int tileEntityData) {
        ResourceLocation flatteningMaterialNamespaced = ResourceLocation.of(flatteningMaterial);
        if (!(this.blockTypeMapper instanceof BukkitBlockRegistry1_8)) {
            return;
        }
        try {
            Map<BukkitBlock1_8, ResourceLocation> locations;
            Material mat = Material.valueOf((String)legacyBukkitMaterial.toUpperCase(Locale.ROOT));
            if (!mat.isBlock()) {
                return;
            }
            BukkitBlock1_8 holder = new BukkitBlock1_8(mat, (byte)data, tileEntityData);
            Map<ResourceLocation, BukkitBlock1_8> mapping = ((BukkitBlockRegistry1_8)this.blockTypeMapper).getPorts();
            if (!mapping.containsKey(flatteningMaterialNamespaced)) {
                mapping.put(flatteningMaterialNamespaced, holder);
            }
            if (!(locations = ((BukkitBlockRegistry1_8)this.blockTypeMapper).getResourceLocations()).containsKey(holder)) {
                locations.put(holder, flatteningMaterialNamespaced);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

