/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit;

import io.netty.channel.ChannelFuture;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Registry;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import sba.sl.Server;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.compat.v1_21_1.SoundCompat;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.player.GenericCommandSender;
import sba.sl.impl.bukkit.spectator.bossbar.BukkitBossBar1_8;
import sba.sl.impl.bukkit.spectator.bossbar.GlobalBossBarBackend1_8;
import sba.sl.impl.bukkit.utils.Version;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.SharedConstantsAccessor;
import sba.sl.impl.nms.accessors.network.protocol.status.ServerStatus$VersionAccessor;
import sba.sl.impl.nms.accessors.network.protocol.status.ServerStatusAccessor;
import sba.sl.impl.nms.accessors.server.MinecraftServerAccessor;
import sba.sl.impl.nms.accessors.server.VVV.DataConverterManagerAccessor;
import sba.sl.impl.nms.accessors.server.network.ServerConnectionListenerAccessor;
import sba.sl.pa.Player;
import sba.sl.pa.Sender;
import sba.sl.u.ProxyType;
import sba.sl.u.annotations.Service;
import sba.sl.u.reflect.Reflect;
import sba.sl.w.World;

@Service
public class BukkitServer
extends Server {
    @NotNull
    private static final @NotNull Map<@NotNull String, String> UNSAFE_SOUND_CACHE = new HashMap<String, String>();

    public BukkitServer() {
        try {
            UNSAFE_SOUND_CACHE.clear();
            if (BukkitFeature.SOUND_INTERFACE.isSupported()) {
                Registry.SOUNDS.forEach(v -> {
                    if ("minecraft".equals(v.getKey().getNamespace())) {
                        UNSAFE_SOUND_CACHE.put(v.getKey().getKey().replace(".", "_"), v.getKey().getKey());
                    }
                });
            } else {
                SoundCompat.fillSoundCache(UNSAFE_SOUND_CACHE);
            }
            if (!Version.isVersion(1, 13)) {
                this.map1_8_to_1_9();
                this.map1_12_to_1_13();
            }
            this.fallbackSound("entity.parrot.imitate.enderman", "entity.enderman.ambient");
            this.fallbackSound("entity.parrot.imitate.panda", "entity.panda.ambient");
            this.fallbackSound("entity.parrot.imitate.polar_bear", "entity.polar_bear.ambient");
            this.fallbackSound("entity.parrot.imitate.wolf", "entity.wolf.ambient");
            this.fallbackSound("entity.parrot.imitate.zombie_pigman", "entity.zombie_pigman.ambient");
            this.mapSound("entity.zombie_pigman.ambient", "entity.zombified_piglin.ambient");
            this.mapSound("entity.zombie_pigman.angry", "entity.zombified_piglin.angry");
            this.mapSound("entity.zombie_pigman.death", "entity.zombified_piglin.death");
            this.mapSound("entity.zombie_pigman.hurt", "entity.zombified_piglin.hurt");
            this.mapSound("music.nether", "music.nether.nether_wastes");
            this.mapSound("item.sweet_berries.pick_from_bush", "block.sweet_berry_bush.pick_berries");
            this.mapSound("music.overworld.jungle_and_forest", "music.overworld.jungle");
            if (Version.isVersion(1, 13)) {
                this.map1_12_to_1_13();
                this.map1_8_to_1_9();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void map1_8_to_1_9() {
        this.mapSound("mob.horse.zombie.idle", "entity.zombie_horse.ambient");
        this.mapSound("note.snare", "block.note.snare");
        this.mapSound("random.wood_click", "block.wood_button.click_on");
        this.mapSound("dig.gravel", "block.gravel.place");
        this.mapSound("random.bowhit", "block.tripwire.detach");
        this.mapSound("dig.glass", "block.glass.break");
        this.mapSound("mob.zombie.say", "entity.zombie.ambient");
        this.mapSound("mob.pig.death", "entity.pig.death");
        this.mapSound("mob.horse.donkey.hit", "entity.donkey.hurt");
        this.mapSound("game.neutral.swim", "entity.player.swim");
        this.mapSound("game.player.swim", "entity.player.swim");
        this.mapSound("mob.endermen.idle", "entity.endermen.ambient");
        this.mapSound("portal.portal", "block.portal.ambient");
        this.mapSound("random.fizz", "entity.generic.extinguish_fire");
        this.mapSound("note.harp", "block.note.harp");
        this.mapSound("step.snow", "block.snow.step");
        this.mapSound("random.successful_hit", "entity.arrow.hit_player");
        this.mapSound("mob.zombiepig.zpighurt", "entity.zombie_pig.hurt");
        this.mapSound("mob.wolf.howl", "entity.wolf.howl");
        this.mapSound("fireworks.launch", "entity.firework.launch");
        this.mapSound("mob.cow.hurt", "entity.cow.death");
        this.mapSound("fireworks.largeBlast", "entity.firework.large_blast");
        this.mapSound("mob.blaze.hit", "entity.blaze.hurt");
        this.mapSound("mob.villager.death", "entity.villager.death");
        this.mapSound("mob.blaze.death", "entity.blaze.death");
        this.mapSound("mob.horse.zombie.death", "entity.zombie_horse.death");
        this.mapSound("mob.silverfish.kill", "entity.endermite.death");
        this.mapSound("mob.wolf.panting", "entity.wolf.pant");
        this.mapSound("note.bass", "block.note.bass");
        this.mapSound("dig.stone", "block.glass.place");
        this.mapSound("mob.endermen.stare", "entity.endermen.stare");
        this.mapSound("game.player.swim.splash", "entity.generic.splash");
        this.mapSound("mob.slime.small", "block.slime.hit");
        this.mapSound("mob.ghast.death", "entity.ghast.death");
        this.mapSound("mob.guardian.attack", "entity.guardian.attack");
        this.mapSound("random.click", "block.wood_pressureplate.click_on");
        this.mapSound("mob.zombiepig.zpig", "entity.zombie_pig.ambient");
        this.mapSound("game.player.die", "entity.player.death");
        this.mapSound("fireworks.twinkle_far", "entity.firework.twinkle_far");
        this.mapSound("mob.guardian.land.idle", "entity.guardian.ambient_land");
        this.mapSound("dig.grass", "block.grass.place");
        this.mapSound("mob.skeleton.step", "entity.skeleton.step");
        this.mapSound("mob.wither.death", "entity.wither.death");
        this.mapSound("mob.wolf.hurt", "entity.wolf.hurt");
        this.mapSound("mob.horse.leather", "entity.horse.saddle");
        this.mapSound("mob.bat.loop", "entity.bat.loop");
        this.mapSound("mob.ghast.scream", "entity.ghast.hurt");
        this.mapSound("game.player.hurt", "entity.player.death");
        this.mapSound("game.neutral.die", "entity.player.death");
        this.mapSound("mob.creeper.death", "entity.creeper.death");
        this.mapSound("mob.horse.gallop", "entity.horse.gallop");
        this.mapSound("mob.wither.spawn", "entity.wither.spawn");
        this.mapSound("mob.endermen.hit", "entity.endermen.hurt");
        this.mapSound("mob.creeper.say", "entity.creeper.hurt");
        this.mapSound("mob.horse.wood", "entity.horse.step_wood");
        this.mapSound("mob.zombie.unfect", "entity.zombie_villager.converted");
        this.mapSound("random.anvil_use", "block.anvil.use");
        this.mapSound("random.chestclosed", "block.chest.close");
        this.mapSound("mob.sheep.shear", "entity.sheep.shear");
        this.mapSound("random.pop", "entity.item.pickup");
        this.mapSound("mob.bat.death", "entity.bat.death");
        this.mapSound("dig.wood", "block.ladder.break");
        this.mapSound("mob.horse.donkey.death", "entity.donkey.death");
        this.mapSound("fireworks.blast", "entity.firework.blast");
        this.mapSound("mob.zombiepig.zpigangry", "entity.zombie_pig.angry");
        this.mapSound("game.hostile.swim", "entity.player.swim");
        this.mapSound("mob.guardian.flop", "entity.guardian.flop");
        this.mapSound("mob.villager.yes", "entity.villager.yes");
        this.mapSound("mob.ghast.charge", "entity.ghast.warn");
        this.mapSound("creeper.primed", "entity.creeper.primed");
        this.mapSound("dig.sand", "block.sand.break");
        this.mapSound("mob.chicken.say", "entity.chicken.ambient");
        this.mapSound("random.door_close", "block.wooden_door.close");
        this.mapSound("mob.guardian.elder.death", "entity.elder_guardian.death");
        this.mapSound("fireworks.twinkle", "entity.firework.twinkle");
        this.mapSound("mob.horse.skeleton.death", "entity.skeleton_horse.death");
        this.mapSound("ambient.weather.rain", "weather.rain.above");
        this.mapSound("portal.trigger", "block.portal.trigger");
        this.mapSound("random.chestopen", "block.chest.open");
        this.mapSound("mob.horse.land", "entity.horse.land");
        this.mapSound("mob.silverfish.step", "entity.silverfish.step");
        this.mapSound("mob.bat.takeoff", "entity.bat.takeoff");
        this.mapSound("mob.villager.no", "entity.villager.no");
        this.mapSound("game.hostile.hurt.fall.big", "entity.hostile.big_fall");
        this.mapSound("mob.irongolem.walk", "entity.irongolem.step");
        this.mapSound("note.hat", "block.note.hat");
        this.mapSound("mob.zombie.metal", "entity.zombie.attack_iron_door");
        this.mapSound("mob.villager.haggle", "entity.villager.trading");
        this.mapSound("mob.ghast.fireball", "entity.blaze.shoot");
        this.mapSound("mob.irongolem.death", "entity.irongolem.death");
        this.mapSound("random.break", "item.shield.break");
        this.mapSound("mob.zombie.remedy", "entity.zombie_villager.cure");
        this.mapSound("random.bow", "entity.splash_potion.throw");
        this.mapSound("mob.villager.idle", "entity.villager.ambient");
        this.mapSound("step.cloth", "block.cloth.fall");
        this.mapSound("mob.silverfish.hit", "entity.endermite.hurt");
        this.mapSound("liquid.lava", "block.lava.ambient");
        this.mapSound("game.neutral.hurt.fall.big", "entity.hostile.big_fall");
        this.mapSound("fire.fire", "block.fire.ambient");
        this.mapSound("mob.zombie.wood", "entity.zombie.attack_door_wood");
        this.mapSound("mob.chicken.step", "entity.chicken.step");
        this.mapSound("mob.guardian.land.hit", "entity.guardian.hurt_land");
        this.mapSound("mob.chicken.plop", "entity.donkey.chest");
        this.mapSound("mob.enderdragon.wings", "entity.enderdragon.flap");
        this.mapSound("step.grass", "block.grass.hit");
        this.mapSound("mob.horse.breathe", "entity.horse.breathe");
        this.mapSound("game.player.hurt.fall.big", "entity.hostile.big_fall");
        this.mapSound("mob.horse.donkey.idle", "entity.donkey.ambient");
        this.mapSound("mob.spider.step", "entity.spider.step");
        this.mapSound("game.neutral.hurt", "entity.player.death");
        this.mapSound("mob.cow.say", "entity.cow.ambient");
        this.mapSound("mob.horse.jump", "entity.horse.jump");
        this.mapSound("mob.horse.soft", "entity.horse.step");
        this.mapSound("game.neutral.swim.splash", "entity.generic.splash");
        this.mapSound("mob.guardian.hit", "entity.guardian.hurt");
        this.mapSound("mob.enderdragon.end", "entity.enderdragon.death");
        this.mapSound("mob.zombie.step", "entity.zombie.step");
        this.mapSound("mob.enderdragon.growl", "entity.enderdragon.growl");
        this.mapSound("mob.wolf.shake", "entity.wolf.shake");
        this.mapSound("mob.endermen.death", "entity.endermen.death");
        this.mapSound("random.anvil_land", "block.anvil.land");
        this.mapSound("game.hostile.hurt", "entity.player.death");
        this.mapSound("minecart.inside", "entity.minecart.inside");
        this.mapSound("mob.slime.big", "entity.slime.death");
        this.mapSound("liquid.water", "block.water.ambient");
        this.mapSound("mob.pig.say", "entity.pig.ambient");
        this.mapSound("mob.wither.shoot", "entity.wither.shoot");
        this.mapSound("item.fireCharge.use", "entity.blaze.shoot");
        this.mapSound("step.sand", "block.sand.fall");
        this.mapSound("mob.irongolem.hit", "entity.irongolem.hurt");
        this.mapSound("mob.horse.death", "entity.horse.death");
        this.mapSound("mob.bat.hurt", "entity.bat.hurt");
        this.mapSound("mob.ghast.affectionate_scream", "entity.ghast.scream");
        this.mapSound("mob.guardian.elder.idle", "entity.elder_guardian.ambient");
        this.mapSound("mob.zombiepig.zpigdeath", "entity.zombie_pig.death");
        this.mapSound("ambient.weather.thunder", "entity.lightning.thunder");
        this.mapSound("minecart.base", "entity.minecart.riding");
        this.mapSound("step.ladder", "block.ladder.hit");
        this.mapSound("mob.horse.donkey.angry", "entity.donkey.angry");
        this.mapSound("ambient.cave.cave", "ambient.cave");
        this.mapSound("fireworks.blast_far", "entity.firework.blast_far");
        this.mapSound("game.neutral.hurt.fall.small", "entity.generic.small_fall");
        this.mapSound("game.hostile.swim.splash", "entity.generic.splash");
        this.mapSound("random.drink", "entity.generic.drink");
        this.mapSound("game.hostile.die", "entity.player.death");
        this.mapSound("mob.cat.hiss", "entity.cat.hiss");
        this.mapSound("note.bd", "block.note.basedrum");
        this.mapSound("mob.spider.say", "entity.spider.hurt");
        this.mapSound("step.stone", "block.anvil.hit");
        this.mapSound("random.levelup", "entity.player.levelup");
        this.mapSound("liquid.lavapop", "block.lava.pop");
        this.mapSound("mob.sheep.say", "entity.sheep.ambient");
        this.mapSound("mob.skeleton.say", "entity.skeleton.ambient");
        this.mapSound("mob.blaze.breathe", "entity.blaze.ambient");
        this.mapSound("mob.bat.idle", "entity.bat.ambient");
        this.mapSound("mob.magmacube.big", "entity.magmacube.squish");
        this.mapSound("mob.horse.idle", "entity.horse.ambient");
        this.mapSound("game.hostile.hurt.fall.small", "entity.generic.small_fall");
        this.mapSound("mob.horse.zombie.hit", "entity.zombie_horse.hurt");
        this.mapSound("mob.irongolem.throw", "entity.irongolem.attack");
        this.mapSound("dig.cloth", "block.cloth.place");
        this.mapSound("step.gravel", "block.gravel.hit");
        this.mapSound("mob.silverfish.say", "entity.silverfish.ambient");
        this.mapSound("mob.cat.purr", "entity.cat.purr");
        this.mapSound("mob.zombie.infect", "entity.zombie.infect");
        this.mapSound("random.eat", "entity.generic.eat");
        this.mapSound("mob.wolf.bark", "entity.wolf.ambient");
        this.mapSound("game.tnt.primed", "entity.creeper.primed");
        this.mapSound("mob.sheep.step", "entity.sheep.step");
        this.mapSound("mob.zombie.death", "entity.zombie.death");
        this.mapSound("random.door_open", "block.wooden_door.open");
        this.mapSound("mob.endermen.portal", "entity.endermen.teleport");
        this.mapSound("mob.horse.angry", "entity.horse.angry");
        this.mapSound("mob.wolf.growl", "entity.wolf.growl");
        this.mapSound("dig.snow", "block.snow.place");
        this.mapSound("tile.piston.out", "block.piston.extend");
        this.mapSound("random.burp", "entity.player.burp");
        this.mapSound("mob.cow.step", "entity.cow.step");
        this.mapSound("mob.wither.hurt", "entity.wither.hurt");
        this.mapSound("mob.guardian.land.death", "entity.elder_guardian.death_land");
        this.mapSound("mob.chicken.hurt", "entity.chicken.death");
        this.mapSound("mob.wolf.step", "entity.wolf.step");
        this.mapSound("mob.wolf.death", "entity.wolf.death");
        this.mapSound("mob.wolf.whine", "entity.wolf.whine");
        this.mapSound("note.pling", "block.note.pling");
        this.mapSound("game.player.hurt.fall.small", "entity.generic.small_fall");
        this.mapSound("mob.cat.purreow", "entity.cat.purreow");
        this.mapSound("fireworks.largeBlast_far", "entity.firework.large_blast_far");
        this.mapSound("mob.skeleton.hurt", "entity.skeleton.hurt");
        this.mapSound("mob.spider.death", "entity.spider.death");
        this.mapSound("random.anvil_break", "block.anvil.destroy");
        this.mapSound("mob.wither.idle", "entity.wither.ambient");
        this.mapSound("mob.guardian.elder.hit", "entity.elder_guardian.hurt");
        this.mapSound("mob.endermen.scream", "entity.endermen.scream");
        this.mapSound("mob.cat.hitt", "entity.cat.hurt");
        this.mapSound("mob.magmacube.small", "entity.small_magmacube.squish");
        this.mapSound("fire.ignite", "item.flintandsteel.use");
        this.mapSound("mob.enderdragon.hit", "entity.enderdragon.hurt");
        this.mapSound("mob.zombie.hurt", "entity.zombie.hurt");
        this.mapSound("random.explode", "block.end_gateway.spawn");
        this.mapSound("mob.slime.attack", "entity.slime.attack");
        this.mapSound("mob.magmacube.jump", "entity.magmacube.jump");
        this.mapSound("random.splash", "entity.bobber.splash");
        this.mapSound("mob.horse.skeleton.hit", "entity.skeleton_horse.hurt");
        this.mapSound("mob.ghast.moan", "entity.ghast.ambient");
        this.mapSound("mob.guardian.curse", "entity.elder_guardian.curse");
        this.mapSound("game.potion.smash", "block.glass.break");
        this.mapSound("note.bassattack", "block.note.bass");
        this.mapSound("gui.button.press", "block.wood_pressureplate.click_on");
        this.mapSound("random.orb", "entity.experience_orb.pickup");
        this.mapSound("mob.zombie.woodbreak", "entity.zombie.break_door_wood");
        this.mapSound("mob.horse.armor", "entity.horse.armor");
        this.mapSound("tile.piston.in", "block.piston.contract");
        this.mapSound("mob.cat.meow", "entity.cat.ambient");
        this.mapSound("mob.pig.step", "entity.pig.step");
        this.mapSound("step.wood", "block.wood.step");
        this.mapSound("portal.travel", "block.portal.travel");
        this.mapSound("mob.guardian.death", "entity.guardian.death");
        this.mapSound("mob.skeleton.death", "entity.skeleton.death");
        this.mapSound("mob.horse.hit", "entity.horse.hurt");
        this.mapSound("mob.villager.hit", "entity.villager.hurt");
        this.mapSound("mob.horse.skeleton.idle", "entity.skeleton_horse.ambient");
        this.mapSound("records.chirp", "record.chirp");
        this.mapSound("mob.rabbit.hurt", "entity.rabbit.hurt");
        this.mapSound("records.stal", "record.stal");
        this.mapSound("music.game.nether", "music.nether");
        this.mapSound("records.mellohi", "record.mellohi");
        this.mapSound("records.cat", "record.cat");
        this.mapSound("records.far", "record.far");
        this.mapSound("music.game.end.dragon", "music.dragon");
        this.mapSound("mob.rabbit.death", "entity.rabbit.death");
        this.mapSound("mob.rabbit.idle", "entity.rabbit.ambient");
        this.mapSound("music.game.end", "music.end");
        this.mapSound("mob.guardian.idle", "entity.elder_guardian.ambient");
        this.mapSound("records.ward", "record.ward");
        this.mapSound("records.13", "record.13");
        this.mapSound("mob.rabbit.hop", "entity.rabbit.jump");
        this.mapSound("records.strad", "record.strad");
        this.mapSound("records.11", "record.11");
        this.mapSound("records.mall", "record.mall");
        this.mapSound("records.blocks", "record.blocks");
        this.mapSound("records.wait", "record.wait");
        this.mapSound("music.game.end.credits", "music.credits");
        this.mapSound("music.game.creative", "music.creative");
    }

    private void map1_12_to_1_13() {
        this.mapSound("block.cloth.break", "block.wool.break");
        this.mapSound("block.cloth.fall", "block.wool.fall");
        this.mapSound("block.cloth.hit", "block.wool.hit");
        this.mapSound("block.cloth.place", "block.wool.place");
        this.mapSound("block.cloth.step", "block.wool.step");
        this.mapSound("block.enderchest.close", "block.ender_chest.close");
        this.mapSound("block.enderchest.open", "block.ender_chest.open");
        this.mapSound("block.metal_pressureplate.click_off", "block.metal_pressure_plate.click_off");
        this.mapSound("block.metal_pressureplate.click_on", "block.metal_pressure_plate.click_on");
        this.mapSound("block.note.basedrum", "block.note_block.basedrum");
        this.mapSound("block.note.bass", "block.note_block.bass");
        this.mapSound("block.note.bell", "block.note_block.bell");
        this.mapSound("block.note.chime", "block.note_block.chime");
        this.mapSound("block.note.flute", "block.note_block.flute");
        this.mapSound("block.note.guitar", "block.note_block.guitar");
        this.mapSound("block.note.harp", "block.note_block.harp");
        this.mapSound("block.note.hat", "block.note_block.hat");
        this.mapSound("block.note.pling", "block.note_block.pling");
        this.mapSound("block.note.snare", "block.note_block.snare");
        this.mapSound("block.note.xylophone", "block.note_block.xylophone");
        this.mapSound("block.slime.break", "block.slime_block.break");
        this.mapSound("block.slime.fall", "block.slime_block.fall");
        this.mapSound("block.slime.hit", "block.slime_block.hit");
        this.mapSound("block.slime.place", "block.slime_block.place");
        this.mapSound("block.slime.step", "block.slime_block.step");
        this.mapSound("block.stone_pressureplate.click_off", "block.stone_pressure_plate.click_off");
        this.mapSound("block.stone_pressureplate.click_on", "block.stone_pressure_plate.click_on");
        this.mapSound("block.waterlily.place", "block.lily_pad.place");
        this.mapSound("block.wood_pressureplate.click_off", "block.wooden_pressure_plate.click_off");
        this.mapSound("block.wood_button.click_on", "block.wooden_button.click_on");
        this.mapSound("block.wood_button.click_off", "block.wooden_button.click_off");
        this.mapSound("block.wood_pressureplate.click_on", "block.wooden_pressure_plate.click_on");
        this.mapSound("entity.armorstand.break", "entity.armor_stand.break");
        this.mapSound("entity.armorstand.fall", "entity.armor_stand.fall");
        this.mapSound("entity.armorstand.hit", "entity.armor_stand.hit");
        this.mapSound("entity.armorstand.place", "entity.armor_stand.place");
        this.mapSound("entity.bobber.retrieve", "entity.fishing_bobber.retrieve");
        this.mapSound("entity.bobber.splash", "entity.fishing_bobber.splash");
        this.mapSound("entity.bobber.throw", "entity.fishing_bobber.throw");
        this.mapSound("entity.enderdragon.ambient", "entity.ender_dragon.ambient");
        this.mapSound("entity.enderdragon.death", "entity.ender_dragon.death");
        this.mapSound("entity.enderdragon.flap", "entity.ender_dragon.flap");
        this.mapSound("entity.enderdragon.growl", "entity.ender_dragon.growl");
        this.mapSound("entity.enderdragon.hurt", "entity.ender_dragon.hurt");
        this.mapSound("entity.enderdragon.shoot", "entity.ender_dragon.shoot");
        this.mapSound("entity.enderdragon_fireball.explode", "entity.dragon_fireball.explode");
        this.mapSound("entity.endereye.death", "entity.ender_eye.death");
        this.mapSound("entity.endereye.launch", "entity.ender_eye.launch");
        this.mapSound("entity.endermen.ambient", "entity.enderman.ambient");
        this.mapSound("entity.endermen.death", "entity.enderman.death");
        this.mapSound("entity.endermen.hurt", "entity.enderman.hurt");
        this.mapSound("entity.endermen.scream", "entity.enderman.scream");
        this.mapSound("entity.endermen.stare", "entity.enderman.stare");
        this.mapSound("entity.endermen.teleport", "entity.enderman.teleport");
        this.mapSound("entity.enderpearl.throw", "entity.ender_pearl.throw");
        this.mapSound("entity.evocation_fangs.attack", "entity.evoker_fangs.attack");
        this.mapSound("entity.evocation_illager.ambient", "entity.evoker.ambient");
        this.mapSound("entity.evocation_illager.cast_spell", "entity.evoker.cast_spell");
        this.mapSound("entity.evocation_illager.death", "entity.evoker.death");
        this.mapSound("entity.evocation_illager.hurt", "entity.evoker.hurt");
        this.mapSound("entity.evocation_illager.prepare_attack", "entity.evoker.prepare_attack");
        this.mapSound("entity.evocation_illager.prepare_summon", "entity.evoker.prepare_summon");
        this.mapSound("entity.evocation_illager.prepare_wololo", "entity.evoker.prepare_wololo");
        this.mapSound("entity.firework.blast", "entity.firework_rocket.blast");
        this.mapSound("entity.firework.blast_far", "entity.firework_rocket.blast_far");
        this.mapSound("entity.firework.large_blast", "entity.firework_rocket.large_blast");
        this.mapSound("entity.firework.large_blast_far", "entity.firework_rocket.large_blast_far");
        this.mapSound("entity.firework.launch", "entity.firework_rocket.launch");
        this.mapSound("entity.firework.shoot", "entity.firework_rocket.shoot");
        this.mapSound("entity.firework.twinkle", "entity.firework_rocket.twinkle");
        this.mapSound("entity.firework.twinkle_far", "entity.firework_rocket.twinkle_far");
        this.mapSound("entity.illusion_illager.ambient", "entity.illusioner.ambient");
        this.mapSound("entity.illusion_illager.cast_spell", "entity.illusioner.cast_spell");
        this.mapSound("entity.illusion_illager.death", "entity.illusioner.death");
        this.mapSound("entity.illusion_illager.hurt", "entity.illusioner.hurt");
        this.mapSound("entity.illusion_illager.mirror_move", "entity.illusioner.mirror_move");
        this.mapSound("entity.illusion_illager.prepare_blindness", "entity.illusioner.prepare_blindness");
        this.mapSound("entity.illusion_illager.prepare_mirror", "entity.illusioner.prepare_mirror");
        this.mapSound("entity.irongolem.attack", "entity.iron_golem.attack");
        this.mapSound("entity.irongolem.death", "entity.iron_golem.death");
        this.mapSound("entity.irongolem.hurt", "entity.iron_golem.hurt");
        this.mapSound("entity.irongolem.step", "entity.iron_golem.step");
        this.mapSound("entity.itemframe.add_item", "entity.item_frame.add_item");
        this.mapSound("entity.itemframe.break", "entity.item_frame.break");
        this.mapSound("entity.itemframe.place", "entity.item_frame.place");
        this.mapSound("entity.itemframe.remove_item", "entity.item_frame.remove_item");
        this.mapSound("entity.itemframe.rotate_item", "entity.item_frame.rotate_item");
        this.mapSound("entity.leashknot.break", "entity.leash_knot.break");
        this.mapSound("entity.leashknot.place", "entity.leash_knot.place");
        this.mapSound("entity.lightning.impact", "entity.lightning_bolt.impact");
        this.mapSound("entity.lightning.thunder", "entity.lightning_bolt.thunder");
        this.mapSound("entity.lingeringpotion.throw", "entity.lingering_potion.throw");
        this.mapSound("entity.magmacube.death", "entity.magma_cube.death");
        this.mapSound("entity.magmacube.hurt", "entity.magma_cube.hurt");
        this.mapSound("entity.magmacube.jump", "entity.magma_cube.jump");
        this.mapSound("entity.magmacube.squish", "entity.magma_cube.squish");
        this.mapSound("entity.parrot.imitate.enderdragon", "entity.parrot.imitate.ender_dragon");
        this.mapSound("entity.parrot.imitate.evocation_illager", "entity.parrot.imitate.evoker");
        this.mapSound("entity.parrot.imitate.illusion_illager", "entity.parrot.imitate.illusioner");
        this.mapSound("entity.parrot.imitate.magmacube", "entity.parrot.imitate.magma_cube");
        this.mapSound("entity.parrot.imitate.vindication_illager", "entity.parrot.imitate.vindicator");
        this.mapSound("entity.player.splash.highspeed", "entity.player.splash.high_speed");
        this.mapSound("entity.polar_bear.baby_ambient", "entity.polar_bear.ambient_baby");
        this.mapSound("entity.small_magmacube.death", "entity.magma_cube.death_small");
        this.mapSound("entity.small_magmacube.hurt", "entity.magma_cube.hurt_small");
        this.mapSound("entity.small_magmacube.squish", "entity.magma_cube.squish_small");
        this.mapSound("entity.small_slime.death", "entity.slime.death_small");
        this.mapSound("entity.small_slime.hurt", "entity.slime.hurt_small");
        this.mapSound("entity.small_slime.jump", "entity.slime.jump_small");
        this.mapSound("entity.small_slime.squish", "entity.slime.squish_small");
        this.mapSound("entity.snowman.ambient", "entity.snow_golem.ambient");
        this.mapSound("entity.snowman.death", "entity.snow_golem.death");
        this.mapSound("entity.snowman.hurt", "entity.snow_golem.hurt");
        this.mapSound("entity.snowman.shoot", "entity.snow_golem.shoot");
        this.mapSound("entity.vindication_illager.ambient", "entity.vindicator.ambient");
        this.mapSound("entity.vindication_illager.death", "entity.vindicator.death");
        this.mapSound("entity.vindication_illager.hurt", "entity.vindicator.hurt");
        this.mapSound("entity.zombie.attack_door_wood", "entity.zombie.attack_wooden_door");
        this.mapSound("entity.zombie.break_door_wood", "entity.zombie.break_wooden_door");
        this.mapSound("entity.zombie_pig.ambient", "entity.zombie_pigman.ambient");
        this.mapSound("entity.zombie_pig.angry", "entity.zombie_pigman.angry");
        this.mapSound("entity.zombie_pig.death", "entity.zombie_pigman.death");
        this.mapSound("entity.zombie_pig.hurt", "entity.zombie_pigman.hurt");
        this.mapSound("record.11", "music_disc.11");
        this.mapSound("record.13", "music_disc.13");
        this.mapSound("record.blocks", "music_disc.blocks");
        this.mapSound("record.cat", "music_disc.cat");
        this.mapSound("record.chirp", "music_disc.chirp");
        this.mapSound("record.far", "music_disc.far");
        this.mapSound("record.mall", "music_disc.mall");
        this.mapSound("record.mellohi", "music_disc.mellohi");
        this.mapSound("record.stal", "music_disc.stal");
        this.mapSound("record.strad", "music_disc.strad");
        this.mapSound("record.wait", "music_disc.wait");
        this.mapSound("record.ward", "music_disc.ward");
    }

    private void mapSound(@NotNull String keyOne, @NotNull String keyTwo) {
        String bukkitKeyOne = keyOne.replace('.', '_').toUpperCase(Locale.ROOT);
        String bukkitKeyTwo = keyTwo.replace('.', '_').toUpperCase(Locale.ROOT);
        if (UNSAFE_SOUND_CACHE.containsKey(bukkitKeyOne) && !UNSAFE_SOUND_CACHE.containsKey(bukkitKeyTwo)) {
            UNSAFE_SOUND_CACHE.put(bukkitKeyTwo, UNSAFE_SOUND_CACHE.get(bukkitKeyOne));
        } else if (UNSAFE_SOUND_CACHE.containsKey(bukkitKeyTwo) && !UNSAFE_SOUND_CACHE.containsKey(bukkitKeyTwo)) {
            UNSAFE_SOUND_CACHE.put(bukkitKeyTwo, UNSAFE_SOUND_CACHE.get(bukkitKeyTwo));
        }
    }

    private void fallbackSound(@NotNull String keyOne, @NotNull String fallbackKey) {
        String bukkitKeyOne = keyOne.replace('.', '_').toUpperCase(Locale.ROOT);
        String bukkitFallbackKey = fallbackKey.replace('.', '_').toUpperCase(Locale.ROOT);
        if (UNSAFE_SOUND_CACHE.containsKey(bukkitFallbackKey) && !UNSAFE_SOUND_CACHE.containsKey(bukkitKeyOne)) {
            UNSAFE_SOUND_CACHE.put(bukkitKeyOne, UNSAFE_SOUND_CACHE.get(bukkitFallbackKey));
        }
    }

    @Override
    @NotNull
    public String getVersion0() {
        if (Version.PATCH_VERSION == 0) {
            return Version.MAJOR_VERSION + "." + Version.MINOR_VERSION;
        }
        return Version.MAJOR_VERSION + "." + Version.MINOR_VERSION + "." + Version.PATCH_VERSION;
    }

    @Override
    @NotNull
    public String getServerSoftwareVersion0() {
        return Bukkit.getVersion();
    }

    @Override
    @NotNull
    public String getServerSoftwareName0() {
        return Bukkit.getName();
    }

    @Override
    public boolean isVersion0(int major, int minor) {
        return Version.isVersion(major, minor);
    }

    @Override
    public boolean isVersion0(int major, int minor, int patch) {
        return Version.isVersion(major, minor, patch);
    }

    @Override
    public boolean isServerThread0() {
        return Bukkit.getServer().isPrimaryThread();
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Player> getConnectedPlayers0() {
        return Bukkit.getOnlinePlayers().stream().map(BukkitPlayer::new).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Player> getConnectedPlayersFromWorld0(@NotNull World holder) {
        return holder.as(org.bukkit.World.class).getPlayers().stream().map(BukkitPlayer::new).collect(Collectors.toList());
    }

    @Override
    public List<@NotNull ChannelFuture> getConnections0() {
        return (List)Reflect.getFieldResulted(ClassStorage.getMinecraftServerObject(), MinecraftServerAccessor.FIELD_CONNECTION.get()).getFieldResulted(ServerConnectionListenerAccessor.FIELD_CHANNELS.get()).raw();
    }

    @Override
    @NotNull
    public Sender getConsoleSender0() {
        return new GenericCommandSender((CommandSender)Bukkit.getConsoleSender());
    }

    @Override
    public void shutdown0() {
        Bukkit.shutdown();
    }

    @Override
    @NotNull
    public ProxyType getProxyType0() {
        if (BukkitFeature.HAS_PAPER_CONFIG.isSupported()) {
            if (Bukkit.spigot().getPaperConfig().getBoolean("settings.velocity-support.enabled", false)) {
                return ProxyType.VELOCITY;
            }
            if (Bukkit.spigot().getPaperConfig().getBoolean("proxies.velocity.enabled", false)) {
                return ProxyType.VELOCITY;
            }
        }
        return Bukkit.spigot().getConfig().getBoolean("settings.bungeecord", false) ? ProxyType.BUNGEE : ProxyType.NONE;
    }

    @Override
    @NotNull
    public Integer getProtocolVersion0() {
        if (BukkitFeature.UNSAFE_VALUES_PROTOCOL_VERSION.isSupported()) {
            return Bukkit.getUnsafe().getProtocolVersion();
        }
        if (SharedConstantsAccessor.METHOD_GET_PROTOCOL_VERSION.get() != null) {
            return Reflect.fastInvokeResulted(SharedConstantsAccessor.METHOD_GET_PROTOCOL_VERSION.get()).as(Integer.class);
        }
        return Reflect.getFieldResulted(ClassStorage.getMinecraftServerObject(), MinecraftServerAccessor.FIELD_STATUS.get()).fastInvokeResulted(ServerStatusAccessor.METHOD_GET_VERSION.get(), new Object[0]).fastInvokeResulted(ServerStatus$VersionAccessor.METHOD_PROTOCOL.get(), new Object[0]).as(Integer.class);
    }

    @Override
    @NotNull
    public Integer getDataVersion0() {
        if (BukkitFeature.UNSAFE_VALUES_DATA_VERSION.isSupported()) {
            return Bukkit.getUnsafe().getDataVersion();
        }
        if (DataConverterManagerAccessor.TYPE.get() != null) {
            Object fixerUpper = Reflect.getField(ClassStorage.getMinecraftServerObject(), MinecraftServerAccessor.FIELD_DATA_CONVERTER_MANAGER.get());
            Integer currentVersion = (Integer)Reflect.getField(fixerUpper, DataConverterManagerAccessor.FIELD_FIELD_188262_D.get());
            if (currentVersion != null) {
                return currentVersion;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public boolean acceptsTransfers0() {
        if (BukkitFeature.TRANSFER.isSupported()) {
            return Bukkit.isAcceptingTransfers();
        }
        return false;
    }

    @NotNull
    public static String UNSAFE_normalizeSoundKey0(@NotNull String s) {
        return UNSAFE_SOUND_CACHE.getOrDefault(s.replace('.', '_').toUpperCase(Locale.ROOT), s).toLowerCase(Locale.ROOT);
    }

    @Override
    protected void preferEnderDragonBossBar0(boolean prefer) {
        if (Version.isVersion(1, 9)) {
            return;
        }
        GlobalBossBarBackend1_8.setBackend(prefer ? BukkitBossBar1_8.Backend.ENDER_DRAGON : BukkitBossBar1_8.Backend.WITHER);
    }

    @Override
    protected void enableViaHooksForBossBar0(boolean enable) {
        if (Version.isVersion(1, 9)) {
            return;
        }
        GlobalBossBarBackend1_8.setViaHooks(enable);
    }
}

