/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.attribute;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.bukkit.attribute.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.a.AttributeType;
import sba.sl.impl.attribute.AttributeTypeRegistry;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.attribute.BukkitAttributeType1_9;
import sba.sl.impl.nms.accessors.world.entity.ai.attributes.AttributeAccessor;
import sba.sl.impl.nms.accessors.world.entity.ai.attributes.AttributesAccessor;
import sba.sl.impl.nms.accessors.world.entity.animal.horse.HorseAccessor;
import sba.sl.impl.nms.accessors.world.entity.monster.ZombieAccessor;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.reflect.Reflect;
import sba.sl.u.registry.RegistryItemStream;

public class BukkitAttributeTypeRegistry1_9
extends AttributeTypeRegistry {
    @NotNull
    private final @NotNull Map<@NotNull Attribute, Object> bukkitAttributeToVanillaAttribute = new HashMap<Attribute, Object>();
    @Nullable
    private Attribute genericArmorToughness;

    public BukkitAttributeTypeRegistry1_9() {
        Attribute backport;
        this.specialType(Attribute.class, a -> new BukkitAttributeType1_9((Attribute)a, this.bukkitAttributeToVanillaAttribute.get(a)));
        if (BukkitFeature.ATTRIBUTE_ARMOR_TOUGHNESS_VANILLA.isSupported() && !BukkitFeature.ATTRIBUTE_ARMOR_TOUGHNESS.isSupported() && (backport = Reflect.newEnumValue(Attribute.class, "GENERIC_ARMOR_TOUGHNESS", Attribute.values().length)) != null) {
            this.genericArmorToughness = backport;
        }
        this.put("GENERIC_MAX_HEALTH", AttributesAccessor.CONST_MAX_HEALTH.get());
        this.put("GENERIC_FOLLOW_RANGE", AttributesAccessor.CONST_FOLLOW_RANGE.get());
        this.put("GENERIC_KNOCKBACK_RESISTANCE", AttributesAccessor.CONST_KNOCKBACK_RESISTANCE.get());
        this.put("GENERIC_MOVEMENT_SPEED", AttributesAccessor.CONST_MOVEMENT_SPEED.get());
        this.put("GENERIC_FLYING_SPEED", AttributesAccessor.CONST_FLYING_SPEED.get());
        this.put("GENERIC_ATTACK_DAMAGE", AttributesAccessor.CONST_ATTACK_DAMAGE.get());
        this.put("GENERIC_ATTACK_SPEED", AttributesAccessor.CONST_ATTACK_SPEED.get());
        this.put("GENERIC_ARMOR", AttributesAccessor.CONST_ARMOR.get());
        this.put("GENERIC_ARMOR_TOUGHNESS", AttributesAccessor.CONST_ARMOR_TOUGHNESS.get(), this.genericArmorToughness);
        this.put("GENERIC_LUCK", AttributesAccessor.CONST_LUCK.get());
        this.put("HORSE_JUMP_STRENGTH", HorseAccessor.CONST_ATTRIBUTE_JUMP_STRENGTH.get());
        this.put("ZOMBIE_SPAWN_REINFORCEMENTS", ZombieAccessor.CONST_SPAWN_REINFORCEMENTS_CHANCE.get());
    }

    private void put(@NotNull String attributeTypeName, @Nullable Object attribute) {
        this.put(attributeTypeName, attribute, null);
    }

    private void put(@NotNull String attributeTypeName, @Nullable Object attribute, @Nullable Attribute artificialInstance) {
        try {
            if (attribute != null && AttributeAccessor.TYPE.get() != null && AttributeAccessor.TYPE.get().isInstance(attribute)) {
                Attribute attributeType = artificialInstance != null ? artificialInstance : Attribute.valueOf((String)attributeTypeName);
                this.bukkitAttributeToVanillaAttribute.put(attributeType, attribute);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull AttributeType> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<Attribute, AttributeType>(() -> {
            if (this.genericArmorToughness == null) {
                return Arrays.stream(Attribute.values());
            }
            return Stream.concat(Arrays.stream(Attribute.values()), Stream.of(this.genericArmorToughness));
        }, a -> new BukkitAttributeType1_9((Attribute)a, this.bukkitAttributeToVanillaAttribute.get(a)), BukkitAttributeType1_9::getLocation, (attributeType, literal) -> BukkitAttributeType1_9.getLocation(attributeType).path().contains((CharSequence)literal), (attributeType, namespace) -> "minecraft".equals(namespace), List.of());
    }

    @Override
    @Nullable
    protected AttributeType resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        try {
            String path = location.path().toUpperCase(Locale.ROOT).replace(".", "_");
            Attribute value = Attribute.valueOf((String)path);
            return new BukkitAttributeType1_9(value, this.bukkitAttributeToVanillaAttribute.get(value));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.genericArmorToughness != null && "generic.armor_toughness".equals(location.path())) {
                return new BukkitAttributeType1_9(this.genericArmorToughness, this.bukkitAttributeToVanillaAttribute.get(this.genericArmorToughness));
            }
            return null;
        }
    }
}

