/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.block;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.Block;
import sba.sl.impl.block.BlockRegistry;
import sba.sl.impl.bukkit.block.BukkitBlock1_8;
import sba.sl.impl.bukkit.compat.v1_12_2.BukkitLegacyBlockTagResolution;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.reflect.Reflect;
import sba.sl.u.registry.RegistryItemStream;

public class BukkitBlockRegistry1_8
extends BlockRegistry {
    @NotNull
    private static final @NotNull Map<@NotNull Material, List<String>> tagBackPorts = new HashMap<Material, List<String>>();
    @NotNull
    protected final @NotNull Map<@NotNull ResourceLocation, @NotNull BukkitBlock1_8> ports = new HashMap<ResourceLocation, BukkitBlock1_8>();
    @NotNull
    protected final @NotNull Map<@NotNull BukkitBlock1_8, @NotNull ResourceLocation> resourceLocations = new HashMap<BukkitBlock1_8, ResourceLocation>();

    public BukkitBlockRegistry1_8() {
        this.specialType(Material.class, mat -> mat.isBlock() ? new BukkitBlock1_8((Material)mat) : null);
        this.specialType(MaterialData.class, data -> data.getItemType().isBlock() ? new BukkitBlock1_8((MaterialData)data) : null);
        Arrays.stream(Material.values()).filter(Material::isBlock).forEach(material -> {
            List<String> backPorts = BukkitLegacyBlockTagResolution.constructTags(material);
            if (!backPorts.isEmpty()) {
                tagBackPorts.put((Material)material, backPorts);
            }
        });
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull Block> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<Map.Entry, Block>(() -> this.ports.entrySet().stream(), Map.Entry::getValue, Map.Entry::getKey, (entry, literal) -> ((ResourceLocation)entry.getKey()).path().contains((CharSequence)literal), (entry, namespace) -> ((ResourceLocation)entry.getKey()).namespace().equals(namespace), List.of());
    }

    @Override
    @Nullable
    protected Block resolveMappingPlatform(@NotNull ResourceLocation location, @Nullable String blockState) {
        Block type = this.resolveMappingPlatform(location);
        if (type != null && blockState != null) {
            if (blockState.startsWith("[") && blockState.endsWith("]")) {
                String values = blockState.substring(1, blockState.length() - 1);
                if (values.isBlank()) {
                    return type;
                }
                Map<String, String> map = Arrays.stream(values.split(",")).map(next -> next.split("=")).collect(Collectors.toMap(next -> next[0], next -> next[1]));
                return type.withStateData(map);
            }
            return null;
        }
        return type;
    }

    @Nullable
    private Block resolveMappingPlatform(@NotNull ResourceLocation location) {
        BukkitBlock1_8 material = this.ports.get(location);
        if (material != null) {
            return material;
        }
        String namespace = location.namespace();
        String path = location.path();
        if ("minecraft".equals(namespace)) {
            if (path.startsWith("legacy/")) {
                String name = path.substring(7);
                int dataSectionIndex = name.indexOf(47);
                if (dataSectionIndex != name.lastIndexOf(47)) {
                    return null;
                }
                int dataValue = 0;
                if (dataSectionIndex != -1) {
                    try {
                        dataValue = Integer.parseInt(name.substring(dataSectionIndex + 1));
                        name = name.substring(0, dataSectionIndex);
                    }
                    catch (NumberFormatException ignored) {
                        return null;
                    }
                }
                try {
                    Material value = Material.valueOf((String)name.toUpperCase(Locale.ROOT).replace('-', '_'));
                    if (!value.isBlock()) {
                        return null;
                    }
                    return new BukkitBlock1_8(value, (byte)dataValue);
                }
                catch (IllegalArgumentException value) {}
            } else if (path.startsWith("legacy-id/")) {
                String compoundId = path.substring(10);
                int dataSectionIndex = compoundId.indexOf(47);
                if (dataSectionIndex != compoundId.lastIndexOf(47)) {
                    return null;
                }
                String stringId = compoundId;
                int dataValue = 0;
                if (dataSectionIndex != -1) {
                    stringId = stringId.substring(0, dataSectionIndex);
                    try {
                        dataValue = Integer.parseInt(compoundId.substring(dataSectionIndex + 1));
                    }
                    catch (NumberFormatException ignored) {
                        return null;
                    }
                }
                int id = 0;
                try {
                    id = Integer.parseInt(stringId);
                }
                catch (NumberFormatException ignored) {
                    return null;
                }
                Object mat = Reflect.getMethod(Material.class, "getId", Integer.TYPE).invokeStatic(id);
                if (mat instanceof Material && ((Material)mat).isBlock()) {
                    return new BukkitBlock1_8((Material)mat, (byte)dataValue);
                }
            }
        } else {
            int dataSectionIndex = path.lastIndexOf(47);
            if (dataSectionIndex != -1) {
                try {
                    int dataValue = Integer.parseInt(path.substring(dataSectionIndex + 1));
                    String name = path.substring(0, dataSectionIndex);
                    String compoundName = namespace + "_" + name;
                    try {
                        Material value = Material.valueOf((String)compoundName.toUpperCase(Locale.ROOT).replace('-', '_'));
                        if (!value.isBlock()) {
                            return null;
                        }
                        return new BukkitBlock1_8(value, (byte)dataValue);
                    }
                    catch (IllegalArgumentException value) {
                        compoundName = namespace + ":" + name;
                        try {
                            Material value2 = Material.valueOf((String)compoundName.toUpperCase(Locale.ROOT).replace('-', '_'));
                            if (!value2.isBlock()) {
                                return null;
                            }
                            return new BukkitBlock1_8(value2, (byte)dataValue);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                catch (NumberFormatException dataValue) {
                    // empty catch block
                }
                String compoundName = namespace + "_" + path;
                try {
                    Material value = Material.valueOf((String)compoundName.toUpperCase(Locale.ROOT).replace('-', '_'));
                    if (!value.isBlock()) {
                        return null;
                    }
                    return new BukkitBlock1_8(value);
                }
                catch (IllegalArgumentException value) {
                    compoundName = namespace + ":" + path;
                    try {
                        Material value3 = Material.valueOf((String)compoundName.toUpperCase(Locale.ROOT).replace('-', '_'));
                        if (!value3.isBlock()) {
                            return null;
                        }
                        return new BukkitBlock1_8(value3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public static boolean hasTagInBackPorts(@NotNull Material material, @NotNull String tag) {
        return tagBackPorts.containsKey(material) && tagBackPorts.get(material).contains(tag);
    }

    @NotNull
    @Generated
    public @NotNull Map<@NotNull ResourceLocation, @NotNull BukkitBlock1_8> getPorts() {
        return this.ports;
    }

    @NotNull
    @Generated
    public @NotNull Map<@NotNull BukkitBlock1_8, @NotNull ResourceLocation> getResourceLocations() {
        return this.resourceLocations;
    }
}

