/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.compat.v1_20_6;

import lombok.Generated;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.jetbrains.annotations.NotNull;
import sba.sl.a.AttributeModifier;
import sba.sl.a.AttributeType;
import sba.sl.a.ItemAttribute;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.u.Preconditions;

public final class AttributeModifierConversion {
    @NotNull
    public static sba.sl.a.AttributeModifier constructSlibModifier(@NotNull AttributeModifier attributeModifier) {
        return new sba.sl.a.AttributeModifier(attributeModifier.getUniqueId(), attributeModifier.getName(), attributeModifier.getAmount(), AttributeModifier.Operation.byOrdinal(attributeModifier.getOperation().ordinal()));
    }

    @NotNull
    public static AttributeModifier constructBukkitModifier(@NotNull sba.sl.a.AttributeModifier modifier) {
        Preconditions.checkNotNull(modifier.getUuid() != null);
        Preconditions.checkNotNull(modifier.getName() != null);
        return new AttributeModifier(modifier.getUuid(), modifier.getName(), modifier.getAmount(), AttributeModifier.Operation.values()[modifier.getOperation().ordinal()]);
    }

    @NotNull
    public static AttributeModifier constructBukkitItemModifier(@NotNull ItemAttribute modifier) {
        Preconditions.checkNotNull(modifier.getUuid() != null);
        Preconditions.checkNotNull(modifier.getName() != null);
        if (BukkitFeature.EQUIPMENT_SLOT_GROUP.isSupported()) {
            return new AttributeModifier(modifier.getUuid(), modifier.getName(), modifier.getAmount(), AttributeModifier.Operation.values()[modifier.getOperation().ordinal()], modifier.getSlot().as(EquipmentSlotGroup.class));
        }
        try {
            return new AttributeModifier(modifier.getUuid(), modifier.getName(), modifier.getAmount(), AttributeModifier.Operation.values()[modifier.getOperation().ordinal()], !modifier.getSlot().is((Object)"any") ? modifier.getSlot().as(EquipmentSlot.class) : null);
        }
        catch (Throwable throwable) {
            return new AttributeModifier(modifier.getUuid(), modifier.getName(), modifier.getAmount(), AttributeModifier.Operation.values()[modifier.getOperation().ordinal()]);
        }
    }

    @NotNull
    public static ItemAttribute constructSlibItemModifier(@NotNull AttributeType attributeType, @NotNull AttributeModifier modifier) {
        if (BukkitFeature.EQUIPMENT_SLOT_GROUP.isSupported()) {
            return new ItemAttribute(attributeType, modifier.getUniqueId(), modifier.getName(), modifier.getAmount(), AttributeModifier.Operation.values()[modifier.getOperation().ordinal()], sba.sl.sl.EquipmentSlotGroup.of(modifier.getSlotGroup()));
        }
        try {
            return new ItemAttribute(attributeType, modifier.getUniqueId(), modifier.getName(), modifier.getAmount(), AttributeModifier.Operation.values()[modifier.getOperation().ordinal()], sba.sl.sl.EquipmentSlot.ofNullable(modifier.getSlot()));
        }
        catch (Throwable throwable) {
            return new ItemAttribute(attributeType, modifier.getUniqueId(), modifier.getName(), modifier.getAmount(), AttributeModifier.Operation.values()[modifier.getOperation().ordinal()], (sba.sl.sl.EquipmentSlot)null);
        }
    }

    @Generated
    private AttributeModifierConversion() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

