/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.container;

import java.util.Arrays;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.cn.PlayerContainer;
import sba.sl.i.ItemStack;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.container.BukkitContainer;
import sba.sl.impl.bukkit.item.BukkitItem;

public class BukkitPlayerContainer
extends BukkitContainer
implements PlayerContainer {
    public BukkitPlayerContainer(@NotNull PlayerInventory wrappedObject) {
        super((Inventory)wrappedObject);
    }

    @Override
    public @Nullable ItemStack @NotNull [] getArmorContents() {
        return (ItemStack[])Arrays.stream(((PlayerInventory)this.wrappedObject).getArmorContents()).map(item -> item == null ? null : new BukkitItem((org.bukkit.inventory.ItemStack)item)).toArray(ItemStack[]::new);
    }

    @Override
    @Nullable
    public ItemStack getHelmet() {
        org.bukkit.inventory.ItemStack item = ((PlayerInventory)this.wrappedObject).getHelmet();
        return item == null ? null : new BukkitItem(item);
    }

    @Override
    @Nullable
    public ItemStack getChestplate() {
        org.bukkit.inventory.ItemStack item = ((PlayerInventory)this.wrappedObject).getChestplate();
        return item == null ? null : new BukkitItem(item);
    }

    @Override
    @Nullable
    public ItemStack getLeggings() {
        org.bukkit.inventory.ItemStack item = ((PlayerInventory)this.wrappedObject).getLeggings();
        return item == null ? null : new BukkitItem(item);
    }

    @Override
    @Nullable
    public ItemStack getBoots() {
        org.bukkit.inventory.ItemStack item = ((PlayerInventory)this.wrappedObject).getBoots();
        return item == null ? null : new BukkitItem(item);
    }

    @Override
    public void setArmorContents(@Nullable @Nullable ItemStack @Nullable [] items) {
        if (items == null) {
            ((PlayerInventory)this.wrappedObject).setArmorContents(null);
            return;
        }
        ((PlayerInventory)this.wrappedObject).setArmorContents((org.bukkit.inventory.ItemStack[])Arrays.stream(items).map(item -> {
            if (item == null) {
                return null;
            }
            return item.as(org.bukkit.inventory.ItemStack.class);
        }).toArray(org.bukkit.inventory.ItemStack[]::new));
    }

    @Override
    public void setHelmet(@Nullable ItemStack helmet) {
        PlayerInventory inventory = (PlayerInventory)this.wrappedObject;
        if (helmet == null) {
            inventory.setHelmet(null);
            return;
        }
        inventory.setHelmet(helmet.as(org.bukkit.inventory.ItemStack.class));
    }

    @Override
    public void setChestplate(@Nullable ItemStack chestplate) {
        PlayerInventory inventory = (PlayerInventory)this.wrappedObject;
        if (chestplate == null) {
            inventory.setChestplate(null);
            return;
        }
        inventory.setChestplate(chestplate.as(org.bukkit.inventory.ItemStack.class));
    }

    @Override
    public void setLeggings(@Nullable ItemStack leggings) {
        PlayerInventory inventory = (PlayerInventory)this.wrappedObject;
        if (leggings == null) {
            inventory.setLeggings(null);
            return;
        }
        inventory.setLeggings(leggings.as(org.bukkit.inventory.ItemStack.class));
    }

    @Override
    public void setBoots(@Nullable ItemStack boots) {
        PlayerInventory inventory = (PlayerInventory)this.wrappedObject;
        if (boots == null) {
            inventory.setBoots(null);
            return;
        }
        inventory.setBoots(boots.as(org.bukkit.inventory.ItemStack.class));
    }

    @Override
    @NotNull
    public ItemStack getItemInMainHand() {
        if (BukkitFeature.OFF_HAND.isSupported()) {
            return new BukkitItem(((PlayerInventory)this.wrappedObject).getItemInMainHand());
        }
        return new BukkitItem(((PlayerInventory)this.wrappedObject).getItemInHand());
    }

    @Override
    public void setItemInMainHand(@Nullable ItemStack item) {
        PlayerInventory inventory = (PlayerInventory)this.wrappedObject;
        if (BukkitFeature.OFF_HAND.isSupported()) {
            if (item == null) {
                inventory.setItemInMainHand(null);
                return;
            }
            inventory.setItemInMainHand(item.as(org.bukkit.inventory.ItemStack.class));
        } else {
            if (item == null) {
                inventory.setItemInHand(null);
                return;
            }
            inventory.setItemInHand(item.as(org.bukkit.inventory.ItemStack.class));
        }
    }

    @Override
    @NotNull
    public ItemStack getItemInOffHand() {
        if (BukkitFeature.OFF_HAND.isSupported()) {
            return new BukkitItem(((PlayerInventory)this.wrappedObject).getItemInOffHand());
        }
        return ItemStackFactory.getAir();
    }

    @Override
    public void setItemInOffHand(@Nullable ItemStack item) {
        HumanEntity holder;
        HashMap failure;
        PlayerInventory inventory = (PlayerInventory)this.wrappedObject;
        if (BukkitFeature.OFF_HAND.isSupported()) {
            if (item == null) {
                inventory.setItemInOffHand(null);
                return;
            }
            inventory.setItemInOffHand(item.as(org.bukkit.inventory.ItemStack.class));
        } else if (item != null && !item.isAir() && !(failure = inventory.addItem(new org.bukkit.inventory.ItemStack[]{item.as(org.bukkit.inventory.ItemStack.class)})).isEmpty() && (holder = inventory.getHolder()) != null) {
            Location loc = holder.getLocation();
            failure.forEach((integer, itemStack) -> loc.getWorld().dropItem(loc, itemStack));
        }
    }

    @Override
    public int getHeldItemSlot() {
        return ((PlayerInventory)this.wrappedObject).getHeldItemSlot();
    }

    @Override
    public void setHeldItemSlot(int slot) {
        ((PlayerInventory)this.wrappedObject).setHeldItemSlot(slot);
    }
}

