/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.entity.damage;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.damage.DamageType;
import sba.sl.impl.bukkit.entity.damage.BukkitDamageType;
import sba.sl.impl.entity.damage.DamageTypeRegistry;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.Service;
import sba.sl.u.registry.RegistryItemStream;

@Service
public class BukkitDamageTypeRegistry
extends DamageTypeRegistry {
    public BukkitDamageTypeRegistry() {
        this.specialType(EntityDamageEvent.DamageCause.class, BukkitDamageType::new);
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull DamageType> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<EntityDamageEvent.DamageCause, DamageType>(() -> Arrays.stream(EntityDamageEvent.DamageCause.values()), BukkitDamageType::new, damageCause -> ResourceLocation.of(damageCause.name()), (damageCause, literal) -> damageCause.name().toLowerCase(Locale.ROOT).contains((CharSequence)literal), (damageCause, namespace) -> "minecraft".equals(namespace), List.of());
    }

    @Override
    @Nullable
    protected DamageType resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        try {
            EntityDamageEvent.DamageCause value = EntityDamageEvent.DamageCause.valueOf((String)location.path().toUpperCase(Locale.ROOT));
            return new BukkitDamageType(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

