/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.entity.pose;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.entity.Pose;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.pose.EntityPose;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.entity.pose.BukkitEntityPose;
import sba.sl.impl.entity.pose.EntityPoseRegistry;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.Service;
import sba.sl.u.registry.RegistryItemStream;

@Service
public class BukkitEntityPoseRegistry
extends EntityPoseRegistry {
    public BukkitEntityPoseRegistry() {
        if (BukkitFeature.ENTITY_POSE.isSupported()) {
            this.specialType(Pose.class, BukkitEntityPose::new);
        }
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull EntityPose> getRegistryItemStream0() {
        if (BukkitFeature.ENTITY_POSE.isSupported()) {
            return new SimpleRegistryItemStream<Pose, EntityPose>(() -> Arrays.stream(Pose.values()), BukkitEntityPose::new, pose -> {
                if ("SNEAKING".equals(pose.name())) {
                    return ResourceLocation.of("crouching");
                }
                return ResourceLocation.of(pose.name());
            }, (pose, literal) -> {
                String path = pose.name().toLowerCase(Locale.ROOT);
                if ("crouching".equals(path)) {
                    path = "sneaking";
                }
                return path.contains((CharSequence)literal);
            }, (pose, namespace) -> "minecraft".equals(namespace), List.of());
        }
        return SimpleRegistryItemStream.createDummy();
    }

    @Override
    @Nullable
    protected EntityPose resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (BukkitFeature.ENTITY_POSE.isSupported()) {
            if (!"minecraft".equals(location.namespace())) {
                return null;
            }
            try {
                String enumName = location.path();
                if ("crouching".equals(location.path())) {
                    enumName = "sneaking";
                }
                Pose value = Pose.valueOf((String)enumName.toUpperCase(Locale.ROOT));
                return new BukkitEntityPose(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

