/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.entity.type;

import java.util.List;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.type.EntityType;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.entity.type.BukkitEntityType1_11;
import sba.sl.impl.bukkit.entity.type.BukkitEntityTypeRegistry;
import sba.sl.impl.bukkit.tags.KeyedUtils;
import sba.sl.impl.bukkit.utils.BukkitRegistry;
import sba.sl.impl.entity.type.EntityTypeTagBackPorts;
import sba.sl.u.ResourceLocation;
import sba.sl.u.reflect.Reflect;
import sba.sl.u.registry.RegistryItemStream;

public class BukkitEntityTypeRegistry1_14
extends BukkitEntityTypeRegistry {
    public BukkitEntityTypeRegistry1_14() {
        this.specialType(org.bukkit.entity.EntityType.class, BukkitEntityType1_11::new);
        Registry.ENTITY_TYPE.forEach(entityType -> {
            List<String> backPorts;
            NamespacedKey namespaced = null;
            try {
                namespaced = entityType.getKey();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (namespaced != null && "minecraft".equals(namespaced.getNamespace()) && (backPorts = EntityTypeTagBackPorts.getPortedTags(new BukkitEntityType1_11((org.bukkit.entity.EntityType)entityType), s -> {
                if (BukkitFeature.REGISTRY_ENTITY_TYPES.isSupported()) {
                    return KeyedUtils.isTagged("entity_types", new NamespacedKey("minecraft", s.toLowerCase(Locale.ROOT)), org.bukkit.entity.EntityType.class, entityType);
                }
                if (BukkitFeature.REGISTRY_ENTITIES.isSupported()) {
                    return KeyedUtils.isTagged((String)Reflect.getField(Tag.class, "REGISTRY_ENTITIES"), new NamespacedKey("minecraft", s.toLowerCase(Locale.ROOT)), org.bukkit.entity.EntityType.class, entityType);
                }
                return false;
            }, BukkitFeature.REGISTRY_ENTITY_TYPES.isSupported() || BukkitFeature.REGISTRY_ENTITIES.isSupported())) != null && !backPorts.isEmpty()) {
                tagBackPorts.put(entityType, backPorts);
            }
        });
    }

    @Override
    @Nullable
    protected EntityType resolveMappingPlatform(@NotNull ResourceLocation location) {
        BukkitEntityType1_11 item = BukkitRegistry.tryObtainItem(Registry.ENTITY_TYPE, BukkitEntityType1_11::new, location);
        if (item != null) {
            return item;
        }
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        try {
            return new BukkitEntityType1_11(org.bukkit.entity.EntityType.valueOf((String)location.path().toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull EntityType> getRegistryItemStream0() {
        return BukkitRegistry.registryStream(Registry.ENTITY_TYPE, BukkitEntityType1_11::new);
    }
}

