/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.block;

import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.entity.Item;
import org.bukkit.event.block.BlockDropItemEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.snapshot.BlockSnapshot;
import sba.sl.e.ItemEntity;
import sba.sl.impl.block.snapshot.BlockSnapshots;
import sba.sl.impl.bukkit.entity.BukkitItemEntity;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.impl.utils.collections.CollectionLinkedToCollection;
import sba.sl.pa.Player;

public class BukkitBlockDropItemEvent
implements sba.sl.ev.block.BlockDropItemEvent,
BukkitCancellable {
    @NotNull
    private final BlockDropItemEvent event;
    @Nullable
    private Player player;
    @Nullable
    private BlockSnapshot blockState;
    private @Nullable Collection<@NotNull ItemEntity> items;

    @Override
    @NotNull
    public Player player() {
        if (this.player == null) {
            this.player = new BukkitPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    @NotNull
    public BlockSnapshot state() {
        if (this.blockState == null) {
            this.blockState = (BlockSnapshot)Objects.requireNonNull(BlockSnapshots.wrapBlockSnapshot(this.event.getBlockState()));
        }
        return this.blockState;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull ItemEntity> items() {
        if (this.items == null) {
            this.items = new CollectionLinkedToCollection<ItemEntity, Item>(this.event.getItems(), entityItem -> entityItem.as(Item.class), BukkitItemEntity::new);
        }
        return this.items;
    }

    @Generated
    public BukkitBlockDropItemEvent(@NotNull BlockDropItemEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitBlockDropItemEvent)) {
            return false;
        }
        BukkitBlockDropItemEvent other = (BukkitBlockDropItemEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockDropItemEvent this$event = this.event();
        BlockDropItemEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitBlockDropItemEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockDropItemEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitBlockDropItemEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public BlockDropItemEvent event() {
        return this.event;
    }
}

