/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.block;

import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.BlockPlacement;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.ev.block.CauldronLevelChangeEvent;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.event.BukkitCancellable;

public class BukkitCauldronLevelChangeEvent
implements CauldronLevelChangeEvent,
BukkitCancellable {
    private final @NotNull org.bukkit.event.block.CauldronLevelChangeEvent event;
    @Nullable
    private BlockPlacement block;
    @Nullable
    private Entity entity;
    private boolean entityConverted;
    @Nullable
    private CauldronLevelChangeEvent.Reason reason;

    @Override
    @NotNull
    public BlockPlacement block() {
        if (this.block == null) {
            this.block = new BukkitBlockPlacement(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    @Nullable
    public Entity entity() {
        if (!this.entityConverted) {
            if (this.event.getEntity() != null) {
                this.entity = Objects.requireNonNull(Entities.wrapEntity(this.event.getEntity()));
            }
            this.entityConverted = true;
        }
        return this.entity;
    }

    @Override
    public int oldLevel() {
        return this.event.getOldLevel();
    }

    @Override
    @NotNull
    public CauldronLevelChangeEvent.Reason reason() {
        if (this.reason == null) {
            this.reason = CauldronLevelChangeEvent.Reason.get(this.event.getReason().name());
        }
        return this.reason;
    }

    @Override
    public int newLevel() {
        return this.event.getNewLevel();
    }

    @Override
    public void newLevel(int newLevel) {
        this.event.setNewLevel(newLevel);
    }

    @Generated
    public BukkitCauldronLevelChangeEvent(@NotNull org.bukkit.event.block.CauldronLevelChangeEvent event) {
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitCauldronLevelChangeEvent)) {
            return false;
        }
        BukkitCauldronLevelChangeEvent other = (BukkitCauldronLevelChangeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        org.bukkit.event.block.CauldronLevelChangeEvent this$event = this.event();
        org.bukkit.event.block.CauldronLevelChangeEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitCauldronLevelChangeEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        org.bukkit.event.block.CauldronLevelChangeEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitCauldronLevelChangeEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @Generated
    public @NotNull org.bukkit.event.block.CauldronLevelChangeEvent event() {
        return this.event;
    }
}

