/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.entity;

import java.util.Objects;
import lombok.Generated;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.BlockPlacement;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.pa.Player;
import sba.sl.u.BlockFace;

public class BukkitEntityPlaceEvent
implements sba.sl.ev.entity.EntityPlaceEvent,
BukkitCancellable {
    @NotNull
    private final EntityPlaceEvent event;
    @Nullable
    private Entity entity;
    @Nullable
    private Player player;
    private boolean playerCached;
    @Nullable
    private BlockPlacement block;
    @Nullable
    private BlockFace blockFace;

    @Override
    @NotNull
    public Entity entity() {
        if (this.entity == null) {
            this.entity = Objects.requireNonNull(Entities.wrapEntity(this.event.getEntity()));
        }
        return this.entity;
    }

    @Override
    @Nullable
    public Player player() {
        if (!this.playerCached) {
            if (this.event.getPlayer() != null) {
                this.player = new BukkitPlayer(this.event.getPlayer());
            }
            this.playerCached = true;
        }
        return this.player;
    }

    @Override
    @NotNull
    public BlockPlacement block() {
        if (this.block == null) {
            this.block = new BukkitBlockPlacement(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    @NotNull
    public BlockFace blockFace() {
        if (this.blockFace == null) {
            this.blockFace = BlockFace.valueOf(this.event.getBlockFace().name());
        }
        return this.blockFace;
    }

    @Generated
    public BukkitEntityPlaceEvent(@NotNull EntityPlaceEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitEntityPlaceEvent)) {
            return false;
        }
        BukkitEntityPlaceEvent other = (BukkitEntityPlaceEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityPlaceEvent this$event = this.event();
        EntityPlaceEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitEntityPlaceEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityPlaceEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitEntityPlaceEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public EntityPlaceEvent event() {
        return this.event;
    }
}

