/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.entity;

import java.util.Objects;
import lombok.Generated;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.impl.world.Locations;
import sba.sl.u.math.Vector3D;
import sba.sl.w.Location;

public class BukkitEntityPortalExitEvent
implements sba.sl.ev.entity.EntityPortalExitEvent {
    @NotNull
    private final EntityPortalExitEvent event;
    @Nullable
    private Entity entity;
    @Nullable
    private Vector3D before;

    @Override
    @NotNull
    public Entity entity() {
        if (this.entity == null) {
            this.entity = Objects.requireNonNull(Entities.wrapEntity(this.event.getEntity()));
        }
        return this.entity;
    }

    @Override
    @NotNull
    public Location from() {
        return Locations.wrapLocation(this.event.getFrom());
    }

    @Override
    public void from(@NotNull Location location) {
        this.event.setFrom(location.as(org.bukkit.Location.class));
    }

    @Override
    @Nullable
    public Location to() {
        org.bukkit.Location loc = this.event.getTo();
        return loc != null ? Locations.wrapLocation(loc) : null;
    }

    @Override
    public void to(@Nullable Location location) {
        this.event.setTo(location != null ? location.as(org.bukkit.Location.class) : null);
    }

    @Override
    @NotNull
    public Vector3D before() {
        if (this.before == null) {
            this.before = new Vector3D(this.event.getBefore().getX(), this.event.getBefore().getY(), this.event.getBefore().getZ());
        }
        return this.before;
    }

    @Override
    @NotNull
    public Vector3D after() {
        return new Vector3D(this.event.getAfter().getX(), this.event.getAfter().getY(), this.event.getAfter().getZ());
    }

    @Override
    public void after(@NotNull Vector3D after) {
        this.event.setAfter(new Vector(after.getX(), after.getY(), after.getZ()));
    }

    @Generated
    public BukkitEntityPortalExitEvent(@NotNull EntityPortalExitEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitEntityPortalExitEvent)) {
            return false;
        }
        BukkitEntityPortalExitEvent other = (BukkitEntityPortalExitEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityPortalExitEvent this$event = this.event();
        EntityPortalExitEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitEntityPortalExitEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityPortalExitEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitEntityPortalExitEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public EntityPortalExitEvent event() {
        return this.event;
    }
}

