/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.player;

import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDeathEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.ev.player.PlayerDeathEvent;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.bukkit.BukkitCore;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.event.entity.BukkitEntityDeathEvent;
import sba.sl.spectator.AudienceComponentLike;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;

public class BukkitPlayerDeathEvent
extends BukkitEntityDeathEvent
implements PlayerDeathEvent {
    @Nullable
    private final Player bukkitKiller;
    @Nullable
    private sba.sl.pa.Player killer;

    public BukkitPlayerDeathEvent(@NotNull org.bukkit.event.entity.PlayerDeathEvent event) {
        super((EntityDeathEvent)event);
        this.bukkitKiller = event.getEntity().getKiller();
    }

    @Override
    @Nullable
    public Component deathMessage() {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            sba.k.a.t.Component dm = this.event().deathMessage();
            return dm != null ? AdventureBackend.wrapComponent(dm) : null;
        }
        String m = this.event().getDeathMessage();
        return m != null ? Component.fromLegacy(m) : null;
    }

    @Override
    public void deathMessage(@Nullable Component deathMessage) {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            this.event().deathMessage(deathMessage != null ? deathMessage.as(sba.k.a.t.Component.class) : null);
        } else {
            this.event().setDeathMessage(deathMessage != null ? deathMessage.toLegacy() : null);
        }
    }

    @Override
    public void deathMessage(@Nullable ComponentLike deathMessage) {
        if (deathMessage instanceof AudienceComponentLike) {
            this.deathMessage(((AudienceComponentLike)deathMessage).asComponent(this.player()));
        } else {
            this.deathMessage(deathMessage != null ? deathMessage.asComponent() : null);
        }
    }

    @Override
    public boolean keepInventory() {
        return this.event().getKeepInventory();
    }

    @Override
    public void keepInventory(boolean keepInventory) {
        this.event().setKeepInventory(keepInventory);
    }

    @Override
    public boolean shouldDropExperience() {
        return this.event().shouldDropExperience();
    }

    @Override
    public void shouldDropExperience(boolean shouldDropExperience) {
        this.event().setShouldDropExperience(shouldDropExperience);
    }

    @Override
    public boolean keepLevel() {
        return this.event().getKeepLevel();
    }

    @Override
    public void keepLevel(boolean keepLevel) {
        this.event().setKeepLevel(keepLevel);
    }

    @Override
    public int newLevel() {
        return this.event().getNewLevel();
    }

    @Override
    public void newLevel(int newLevel) {
        this.event().setNewLevel(newLevel);
    }

    @Override
    public int newTotalExp() {
        return this.event().getNewTotalExp();
    }

    @Override
    public void newTotalExp(int newTotalExp) {
        this.event().setNewTotalExp(newTotalExp);
    }

    @Override
    public int getNewExp() {
        return this.event().getNewExp();
    }

    @Override
    public void newExp(int newExp) {
        this.event().setNewExp(newExp);
    }

    @Override
    public int droppedExp() {
        return this.event().getDroppedExp();
    }

    @Override
    public void droppedExp(int droppedExp) {
        this.event().setDroppedExp(droppedExp);
    }

    @Override
    @Nullable
    public sba.sl.pa.Player killer() {
        if (this.bukkitKiller != null && this.killer == null) {
            this.killer = new BukkitPlayer(this.bukkitKiller);
        }
        return this.killer;
    }

    @Override
    @NotNull
    public sba.sl.pa.Player player() {
        return (sba.sl.pa.Player)this.entity();
    }

    @NotNull
    public org.bukkit.event.entity.PlayerDeathEvent event() {
        return (org.bukkit.event.entity.PlayerDeathEvent)super.event();
    }
}

