/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.player;

import java.util.Objects;
import lombok.Generated;
import org.bukkit.event.player.PlayerFishEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.ev.player.PlayerFishEvent;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.pa.Player;

public class BukkitPlayerFishEvent
implements sba.sl.ev.player.PlayerFishEvent,
BukkitCancellable {
    @NotNull
    private final PlayerFishEvent event;
    @Nullable
    private Player player;
    @Nullable
    private Entity entity;
    private boolean entityCached;
    @Nullable
    private PlayerFishEvent.State state;
    @Nullable
    private Entity hookEntity;

    @Override
    @NotNull
    public Player player() {
        if (this.player == null) {
            this.player = new BukkitPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    @Nullable
    public Entity caughtEntity() {
        if (!this.entityCached) {
            if (this.event.getCaught() != null) {
                this.entity = Objects.requireNonNull(Entities.wrapEntity(this.event.getCaught()));
            }
            this.entityCached = true;
        }
        return this.entity;
    }

    @Override
    public int exp() {
        return this.event.getExpToDrop();
    }

    @Override
    public void exp(int exp) {
        this.event.setExpToDrop(exp);
    }

    @Override
    @NotNull
    public PlayerFishEvent.State state() {
        if (this.state == null) {
            this.state = PlayerFishEvent.State.convert(this.event.getState().name());
        }
        return this.state;
    }

    @Override
    @NotNull
    public Entity hookEntity() {
        if (this.hookEntity == null) {
            this.hookEntity = Objects.requireNonNull(Entities.wrapEntity(this.event.getHook()));
        }
        return this.hookEntity;
    }

    @Generated
    public BukkitPlayerFishEvent(@NotNull PlayerFishEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitPlayerFishEvent)) {
            return false;
        }
        BukkitPlayerFishEvent other = (BukkitPlayerFishEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerFishEvent this$event = this.event();
        PlayerFishEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitPlayerFishEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerFishEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitPlayerFishEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public PlayerFishEvent event() {
        return this.event;
    }
}

