/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.firework;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.FireworkEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.f.FireworkEffectType;
import sba.sl.impl.bukkit.firework.BukkitFireworkEffectType;
import sba.sl.impl.firework.FireworkEffectTypeRegistry;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.Service;
import sba.sl.u.registry.RegistryItemStream;

@Service
public class BukkitFireworkEffectTypeRegistry
extends FireworkEffectTypeRegistry {
    public BukkitFireworkEffectTypeRegistry() {
        this.specialType(FireworkEffect.Type.class, BukkitFireworkEffectType::new);
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull FireworkEffectType> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<FireworkEffect.Type, FireworkEffectType>(() -> Arrays.stream(FireworkEffect.Type.values()), BukkitFireworkEffectType::new, fireworkEffect -> ResourceLocation.of(BukkitFireworkEffectType.getLocationPath(fireworkEffect)), (fireworkEffect, literal) -> BukkitFireworkEffectType.getLocationPath(fireworkEffect).contains((CharSequence)literal), (fireworkEffect, namespace) -> "minecraft".equals(namespace), List.of());
    }

    @Override
    @Nullable
    protected FireworkEffectType resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        try {
            String path = location.path();
            if ("small_ball".equalsIgnoreCase(path)) {
                path = "BALL";
            } else if ("large_ball".equalsIgnoreCase(path)) {
                path = "BALL_LARGE";
            }
            FireworkEffect.Type value = FireworkEffect.Type.valueOf((String)path.toUpperCase(Locale.ROOT));
            return new BukkitFireworkEffectType(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

