/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.gameevent;

import org.bukkit.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.gameevent.GameEvent;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.gameevent.BukkitGameEvent;
import sba.sl.impl.bukkit.utils.BukkitRegistry;
import sba.sl.impl.gameevent.GameEventRegistry;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.Service;
import sba.sl.u.registry.RegistryItemStream;

@Service
public class BukkitGameEventRegistry
extends GameEventRegistry {
    public BukkitGameEventRegistry() {
        if (BukkitFeature.GAME_EVENT.isSupported()) {
            this.specialType(org.bukkit.GameEvent.class, BukkitGameEvent::new);
        }
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull GameEvent> getRegistryItemStream0() {
        if (BukkitFeature.GAME_EVENT.isSupported()) {
            return BukkitRegistry.registryStream(Registry.GAME_EVENT, BukkitGameEvent::new);
        }
        return SimpleRegistryItemStream.createDummy();
    }

    @Override
    @Nullable
    protected GameEvent resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (BukkitFeature.GAME_EVENT.isSupported()) {
            return BukkitRegistry.tryObtainItem(Registry.GAME_EVENT, BukkitGameEvent::new, location);
        }
        return null;
    }
}

