/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item;

import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.Block;
import sba.sl.i.ItemType;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.block.BukkitBlock1_8;
import sba.sl.impl.bukkit.item.BukkitItemTypeRegistry1_8;
import sba.sl.impl.item.ItemTypeRegistry;
import sba.sl.u.BasicWrapper;
import sba.sl.u.Pair;
import sba.sl.u.ResourceLocation;

public class BukkitItemType1_8
extends BasicWrapper<Pair<Material, Short>>
implements ItemType {
    public BukkitItemType1_8(@NotNull Material material) {
        this(Pair.of(material, (short)0));
    }

    public BukkitItemType1_8(@NotNull Material material, short forcedDurability) {
        this(Pair.of(material, material != Material.AIR ? forcedDurability : (short)0));
    }

    public BukkitItemType1_8(@NotNull @NotNull Pair<@NotNull Material, @NotNull Short> wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public String platformName() {
        return ((Material)((Pair)this.wrappedObject).first()).name();
    }

    public short forcedDurability() {
        return (Short)((Pair)this.wrappedObject).second();
    }

    @Override
    public int maxStackSize() {
        return ((Material)((Pair)this.wrappedObject).first()).getMaxStackSize();
    }

    @Override
    @Nullable
    public Block block() {
        if (!((Material)((Pair)this.wrappedObject).first()).isBlock()) {
            String name = null;
            int tileEntityVariant = 0;
            switch (((Material)((Pair)this.wrappedObject).first()).name()) {
                case "BREWING_STAND_ITEM": {
                    name = "BREWING_STAND";
                    break;
                }
                case "CAULDRON_ITEM": {
                    name = "CAULDRON";
                    break;
                }
                case "FLOWER_POT_ITEM": {
                    name = "FLOWER_POT";
                    break;
                }
                case "SKULL_ITEM": {
                    name = "SKULL";
                    if (!BukkitFeature.COLORED_BEDS.isSupported()) break;
                    tileEntityVariant = ((Short)((Pair)this.wrappedObject).second()).shortValue();
                    break;
                }
                case "WOOD_DOOR": {
                    name = "WOODEN_DOOR";
                    break;
                }
                case "IRON_DOOR": {
                    name = "IRON_DOOR_BLOCK";
                    break;
                }
                case "SPRUCE_DOOR_ITEM": {
                    name = "SPRUCE_DOOR";
                    break;
                }
                case "BIRCH_DOOR_ITEM": {
                    name = "BIRCH_DOOR";
                    break;
                }
                case "JUNGLE_DOOR_ITEM": {
                    name = "JUNGLE_DOOR";
                    break;
                }
                case "ACACIA_DOOR_ITEM": {
                    name = "ACACIA_DOOR";
                    break;
                }
                case "DARK_OAK_DOOR_ITEM": {
                    name = "DARK_OAK_DOOR";
                    break;
                }
                case "BED": {
                    name = "BED_BLOCK";
                    if (!BukkitFeature.COLORED_BEDS.isSupported()) break;
                    tileEntityVariant = ((Short)((Pair)this.wrappedObject).second()).shortValue();
                    break;
                }
                case "SUGAR_CANE": {
                    name = "SUGAR_CANE_BLOCK";
                    break;
                }
                case "CAKE": {
                    name = "CAKE_BLOCK";
                    break;
                }
                case "DIODE": {
                    name = "DIODE_BLOCK_OFF";
                    break;
                }
                case "REDSTONE_COMPARATOR": {
                    name = "REDSTONE_COMPARATOR_OFF";
                }
            }
            try {
                return new BukkitBlock1_8(Material.valueOf((String)name), 0, tileEntityVariant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        byte data = ((Short)((Pair)this.wrappedObject).second()).byteValue();
        switch (((Material)((Pair)this.wrappedObject).first()).name()) {
            case "ANVIL": {
                data = (byte)((data & 3) << 2);
                break;
            }
            case "TORCH": 
            case "REDSTONE_TORCH_ON": {
                data = 5;
                break;
            }
            case "CHEST": 
            case "FURNACE": 
            case "LADDER": 
            case "ENDER_CHEST": 
            case "TRAPPED_CHEST": {
                data = 2;
            }
        }
        return new BukkitBlock1_8((Material)((Pair)this.wrappedObject).first(), data);
    }

    @Override
    public boolean hasTag(@NotNull Object tag) {
        ResourceLocation key = tag instanceof ResourceLocation ? (ResourceLocation)tag : ResourceLocation.of(tag.toString());
        if (!"minecraft".equals(key.namespace())) {
            return false;
        }
        return BukkitItemTypeRegistry1_8.hasTagInBackPorts((Material)((Pair)this.wrappedObject).first(), key.path());
    }

    @Override
    public boolean is(@Nullable Object object) {
        String str;
        if (object instanceof Material && (Short)((Pair)this.wrappedObject).second() == 0) {
            return ((Pair)this.wrappedObject).first() == object;
        }
        if (object instanceof ItemType) {
            return this.equals(object);
        }
        if (object instanceof String && (str = (String)object).startsWith("#")) {
            return this.hasTag(str.substring(1));
        }
        return this.equals(ItemType.ofNullable(object));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type == Material.class) {
            return (T)((Pair)this.wrappedObject).first();
        }
        if (type == ItemStack.class) {
            return (T)new ItemStack((Material)((Pair)this.wrappedObject).first(), 1, ((Short)((Pair)this.wrappedObject).second()).shortValue());
        }
        return super.as(type);
    }

    @Override
    @NotNull
    public ResourceLocation location() {
        ResourceLocation location;
        ItemTypeRegistry registry = ItemTypeRegistry.getInstance();
        if (registry instanceof BukkitItemTypeRegistry1_8 && (location = ((BukkitItemTypeRegistry1_8)registry).getResourceLocations().get(this)) != null) {
            return location;
        }
        return ResourceLocation.of("minecraft:legacy/" + ((Material)((Pair)this.wrappedObject).first()).name() + "/" + String.valueOf(((Pair)this.wrappedObject).second()));
    }
}

