/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item.meta;

import java.util.Arrays;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.meta.Potion;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;

public class BukkitPotion1_8
extends BasicWrapper<org.bukkit.potion.Potion>
implements Potion {
    public BukkitPotion1_8(@NotNull PotionType type) {
        this(new org.bukkit.potion.Potion(type));
    }

    public BukkitPotion1_8(@NotNull org.bukkit.potion.Potion wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public String platformName() {
        if (((org.bukkit.potion.Potion)this.wrappedObject).hasExtendedDuration()) {
            return "LONG_" + ((org.bukkit.potion.Potion)this.wrappedObject).getType().name();
        }
        if (((org.bukkit.potion.Potion)this.wrappedObject).getLevel() == 2) {
            return "STRONG_" + ((org.bukkit.potion.Potion)this.wrappedObject).getType().name();
        }
        return ((org.bukkit.potion.Potion)this.wrappedObject).getType().name();
    }

    @Override
    public boolean is(@Nullable Object object) {
        if (object instanceof org.bukkit.potion.Potion || object instanceof Potion) {
            return this.equals(object);
        }
        return this.equals(Potion.ofNullable(object));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type == PotionType.class) {
            return (T)((org.bukkit.potion.Potion)this.wrappedObject).getType();
        }
        return super.as(type);
    }

    @Override
    @NotNull
    public ResourceLocation location() {
        return BukkitPotion1_8.constructKey((org.bukkit.potion.Potion)this.wrappedObject);
    }

    @NotNull
    public static ResourceLocation constructKey(@NotNull org.bukkit.potion.Potion data) {
        Object name;
        String bukkitName;
        switch (bukkitName = data.getType().name()) {
            case "JUMP": {
                name = "LEAPING";
                break;
            }
            case "SPEED": {
                name = "SWIFTNESS";
                break;
            }
            case "INSTANT_HEAL": {
                name = "HEALING";
                break;
            }
            case "INSTANT_DAMAGE": {
                name = "HARMING";
                break;
            }
            case "REGEN": {
                name = "REGENERATION";
                break;
            }
            default: {
                name = bukkitName;
            }
        }
        if (data.getLevel() == 2) {
            name = "STRONG_" + (String)name;
        } else if (data.hasExtendedDuration()) {
            name = "LONG_" + (String)name;
        }
        return ResourceLocation.of((String)name);
    }
}

