/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item.meta;

import java.util.Arrays;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.meta.Potion;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;

public class BukkitPotion1_9
extends BasicWrapper<PotionData>
implements Potion {
    public BukkitPotion1_9(@NotNull PotionType type) {
        this(new PotionData(type));
    }

    public BukkitPotion1_9(@NotNull PotionData wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public String platformName() {
        if (((PotionData)this.wrappedObject).isExtended()) {
            return "LONG_" + ((PotionData)this.wrappedObject).getType().name();
        }
        if (((PotionData)this.wrappedObject).isUpgraded()) {
            return "STRONG_" + ((PotionData)this.wrappedObject).getType().name();
        }
        return ((PotionData)this.wrappedObject).getType().name();
    }

    @Override
    public boolean is(@Nullable Object object) {
        if (object instanceof PotionData || object instanceof Potion) {
            return this.equals(object);
        }
        return this.equals(Potion.ofNullable(object));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type == PotionType.class) {
            return (T)((PotionData)this.wrappedObject).getType();
        }
        return super.as(type);
    }

    @Override
    @NotNull
    public ResourceLocation location() {
        return BukkitPotion1_9.constructKey((PotionData)this.wrappedObject);
    }

    @NotNull
    public static ResourceLocation constructKey(@NotNull PotionData data) {
        Object name;
        String bukkitName;
        switch (bukkitName = data.getType().name()) {
            case "UNCRAFTABLE": {
                name = "EMPTY";
                break;
            }
            case "JUMP": {
                name = "LEAPING";
                break;
            }
            case "SPEED": {
                name = "SWIFTNESS";
                break;
            }
            case "INSTANT_HEAL": {
                name = "HEALING";
                break;
            }
            case "INSTANT_DAMAGE": {
                name = "HARMING";
                break;
            }
            case "REGEN": {
                name = "REGENERATION";
                break;
            }
            default: {
                name = bukkitName;
            }
        }
        if (data.isExtended()) {
            name = "STRONG_" + (String)name;
        } else if (data.isUpgraded()) {
            name = "LONG_" + (String)name;
        }
        return ResourceLocation.of((String)name);
    }
}

