/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item.meta;

import java.util.Arrays;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.meta.PotionEffect;
import sba.sl.i.meta.PotionEffectType;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.item.meta.BukkitPotionEffect;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;

public class BukkitPotionEffectType
extends BasicWrapper<org.bukkit.potion.PotionEffectType>
implements PotionEffectType {
    public BukkitPotionEffectType(@NotNull org.bukkit.potion.PotionEffectType type) {
        super(type);
    }

    @Override
    @NotNull
    public String platformName() {
        return ((org.bukkit.potion.PotionEffectType)this.wrappedObject).getName();
    }

    @Override
    @NotNull
    public PotionEffect asEffect(int duration, int amplifier, boolean ambient, boolean particles, boolean icon) {
        if (BukkitFeature.POTION_EFFECT_CONSTRUCTOR_WITH_ICON.isSupported()) {
            return new BukkitPotionEffect(new org.bukkit.potion.PotionEffect((org.bukkit.potion.PotionEffectType)this.wrappedObject, duration, amplifier, ambient, particles, icon));
        }
        return new BukkitPotionEffect(new org.bukkit.potion.PotionEffect((org.bukkit.potion.PotionEffectType)this.wrappedObject, duration, amplifier, ambient, particles));
    }

    @Override
    public boolean is(@Nullable Object object) {
        if (object instanceof org.bukkit.potion.PotionEffectType || object instanceof PotionEffectType) {
            return this.equals(object);
        }
        return this.equals(PotionEffectType.ofNullable(object));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    @NotNull
    public ResourceLocation location() {
        if (BukkitFeature.POTION_EFFECT_KEYED.isSupported()) {
            NamespacedKey namespacedKey = ((org.bukkit.potion.PotionEffectType)this.wrappedObject).getKey();
            return ResourceLocation.of(namespacedKey.getNamespace(), namespacedKey.getKey());
        }
        return ResourceLocation.of(BukkitPotionEffectType.getLocationPath((org.bukkit.potion.PotionEffectType)this.wrappedObject));
    }

    @NotNull
    public static String getLocationPath(@NotNull org.bukkit.potion.PotionEffectType effectType) {
        String path;
        switch (path = effectType.getName()) {
            case "SLOW": {
                path = "slowness";
                break;
            }
            case "FAST_DIGGING": {
                path = "haste";
                break;
            }
            case "SLOW_DIGGING": {
                path = "mining_fatigue";
                break;
            }
            case "INCREASE_DAMAGE": {
                path = "strength";
                break;
            }
            case "HEAL": {
                path = "instant_health";
                break;
            }
            case "HARM": {
                path = "instant_damage";
                break;
            }
            case "JUMP": {
                path = "jump_boost";
                break;
            }
            case "CONFUSION": {
                path = "nausea";
                break;
            }
            case "DAMAGE_RESISTANCE": {
                path = "resistance";
            }
        }
        return path.toLowerCase(Locale.ROOT);
    }
}

