/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.packet;

import io.netty.buffer.ByteBuf;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import sba.sl.b.Block;
import sba.sl.i.ItemStack;
import sba.sl.i.ItemType;
import sba.sl.impl.bukkit.item.BukkitItemType1_8;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.core.component.DataComponentPatchAccessor;
import sba.sl.impl.nms.accessors.network.FriendlyByteBufAccessor;
import sba.sl.impl.nms.accessors.network.RegistryFriendlyByteBufAccessor;
import sba.sl.impl.nms.accessors.network.codec.StreamEncoderAccessor;
import sba.sl.impl.nms.accessors.server.MinecraftServerAccessor;
import sba.sl.impl.nms.accessors.world.item.ItemStackAccessor;
import sba.sl.impl.nms.accessors.world.level.block.BlockAccessor;
import sba.sl.impl.vanilla.packet.VanillaPacketWriter;
import sba.sl.sl.EquipmentSlot;
import sba.sl.u.reflect.Reflect;

public class CraftBukkitPacketWriter
extends VanillaPacketWriter {
    public CraftBukkitPacketWriter(@NotNull ByteBuf buffer) {
        super(buffer);
    }

    @Override
    public int getEquipmentSlotId(@NotNull EquipmentSlot equipmentSlotHolder) {
        return equipmentSlotHolder.as(org.bukkit.inventory.EquipmentSlot.class).ordinal();
    }

    @Override
    @NotNull
    protected Object materialHolderToItem(@NotNull ItemType material) {
        return Reflect.getMethod(ClassStorage.CB.CraftMagicNumbers, "getItem", Material.class).invokeStatic(material.as(Material.class));
    }

    @Override
    @NotNull
    protected Object blockDataToBlockState(@NotNull Block blockData) {
        if (Reflect.has("org.bukkit.block.data.BlockData")) {
            return Reflect.fastInvoke((Object)blockData.as(BlockData.class), "getState");
        }
        MaterialData materialData = blockData.as(MaterialData.class);
        return Reflect.getMethod(ClassStorage.CB.CraftMagicNumbers, "getBlock", Material.class).invokeStaticResulted(materialData.getItemType()).fastInvoke(BlockAccessor.METHOD_FROM_LEGACY_DATA.get(), materialData.getData());
    }

    @Override
    public void writeItemComponents(@NotNull ItemStack item) {
        Object nmsStack = Reflect.fastInvoke(ClassStorage.stackAsNMS(item.as(org.bukkit.inventory.ItemStack.class)), ItemStackAccessor.METHOD_COPY.get());
        if (this.protocol() >= 766) {
            Object registryByteBuf = Reflect.construct(RegistryFriendlyByteBufAccessor.CONSTRUCTOR_0.get(), this.getBuffer(), Reflect.fastInvoke(ClassStorage.getMinecraftServerObject(), MinecraftServerAccessor.METHOD_REGISTRY_ACCESS.get()));
            Object dataComponents = Reflect.fastInvoke(nmsStack, ItemStackAccessor.METHOD_GET_COMPONENTS_PATCH.get());
            Reflect.fastInvoke(DataComponentPatchAccessor.CONST_STREAM_CODEC.get(), StreamEncoderAccessor.METHOD_ENCODE.get(), registryByteBuf, dataComponents);
        } else {
            Object friendlyByteBuf = Reflect.construct(FriendlyByteBufAccessor.CONSTRUCTOR_0.get(), this.getBuffer());
            Object nbtTag = Reflect.fastInvoke(nmsStack, ItemStackAccessor.METHOD_GET_TAG.get());
            Reflect.fastInvoke(friendlyByteBuf, FriendlyByteBufAccessor.METHOD_WRITE_NBT.get(), nbtTag);
        }
    }

    @Override
    protected short getForcedDurability(@NotNull ItemType material) {
        if (material instanceof BukkitItemType1_8) {
            return ((BukkitItemType1_8)material).forcedDurability();
        }
        return 0;
    }
}

