/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.spectator;

import io.papermc.paper.text.PaperComponents;
import java.awt.Color;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import sba.k.a.audience.Audience;
import sba.k.a.key.Key;
import sba.k.a.nbt.api.BinaryTagHolder;
import sba.k.a.t.event.ClickEvent;
import sba.k.a.t.event.HoverEvent;
import sba.k.a.t.format.ShadowColor;
import sba.k.a.t.format.TextColor;
import sba.k.a.t.serializer.gson.GsonComponentSerializer;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.adventure.spectator.AdventureFeature;
import sba.sl.impl.adventure.spectator.audience.adapter.AdventureAdapter;
import sba.sl.impl.adventure.spectator.audience.adapter.AdventureConsoleAdapter;
import sba.sl.impl.adventure.spectator.audience.adapter.AdventurePlayerAdapter;
import sba.sl.impl.bukkit.BukkitServer;
import sba.sl.impl.bungee.spectator.AbstractBungeeBackend;
import sba.sl.impl.bungee.spectator.BungeeChatFeature;
import sba.sl.impl.spectator.SpectatorBackend;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.SNBTSerializer;
import sba.sl.spectator.Component;
import sba.sl.spectator.audience.ConsoleAudience;
import sba.sl.spectator.audience.PlayerAudience;
import sba.sl.spectator.audience.adapter.Adapter;
import sba.sl.u.ResourceLocation;

final class SpigotBackendAdventureExtension {
    @NotNull
    static SpectatorBackend initAdventureBackend(final @NotNull SNBTSerializer snbtSerializerLocal) {
        AdventureBackend adventureBackend = new AdventureBackend(){
            {
                snbtSerializer = snbtSerializerLocal;
                soundKeyNormalizer = BukkitServer::UNSAFE_normalizeSoundKey0;
            }
        };
        GsonComponentSerializer gson = PaperComponents.gsonSerializer();
        AdventureBackend.getAdditionalComponentConverter().registerW2P(BaseComponent[].class, component -> ComponentSerializer.parse((String)((String)gson.serialize(component.as(sba.k.a.t.Component.class))))).registerW2P(BaseComponent.class, component -> {
            BaseComponent[] arr = component.as(BaseComponent[].class);
            if (arr.length == 0) {
                return new TextComponent("");
            }
            if (arr.length == 1) {
                return arr[0];
            }
            return new TextComponent(arr);
        });
        AdventureBackend.getAdditionalColorConverter().registerW2P(ChatColor.class, adventureColor -> ChatColor.of((String)adventureColor.toString()));
        AdventureBackend.getAdditionalClickEventConverter().registerW2P(ClickEvent.class, adventureClickEvent -> {
            ClickEvent.Action bungeeAction;
            try {
                bungeeAction = ClickEvent.Action.valueOf((String)adventureClickEvent.action().name());
            }
            catch (Throwable throwable) {
                bungeeAction = ClickEvent.Action.OPEN_URL;
            }
            return new ClickEvent(bungeeAction, adventureClickEvent.value());
        });
        AdventureBackend.getAdditionalHoverEventConverter().registerW2P(HoverEvent.class, adventureHoverEvent -> new HoverEvent(HoverEvent.Action.valueOf((String)adventureHoverEvent.action().name()), new Content[]{adventureHoverEvent.content().as(Content.class)}));
        AdventureBackend.getAdditionalItemContentConverter().registerW2P(Item.class, adventureItemContent -> {
            CompoundTag nbt = adventureItemContent.tag();
            return new Item(adventureItemContent.id().asString(), adventureItemContent.count(), nbt != null ? ItemTag.ofNbt((String)snbtSerializerLocal.serialize(nbt)) : null);
        });
        AdventureBackend.getAdditionalEntityContentConverter().registerW2P(Entity.class, adventureEntityContent -> {
            Component name = adventureEntityContent.name();
            return new Entity(adventureEntityContent.type().asString(), adventureEntityContent.id().toString(), name != null ? name.as(BaseComponent.class) : null);
        });
        if (AdventureFeature.SHADOW_COLOR.isSupported() && BungeeChatFeature.SHADOW_COLORS.isSupported()) {
            AdventureBackend.getAdditionalShadowColorConverter().registerW2P(Color.class, color -> new Color(color.red(), color.green(), color.blue(), color.alpha()));
            AbstractBungeeBackend.getAdditionalShadowColorConverter().registerW2P(ShadowColor.class, shadowColor -> ShadowColor.shadowColor((int)shadowColor.red(), (int)shadowColor.green(), (int)shadowColor.blue(), (int)shadowColor.alpha()));
        }
        AbstractBungeeBackend.getAdditionalComponentConverter().registerW2P(sba.k.a.t.Component.class, component -> gson.deserialize(ComponentSerializer.toString((BaseComponent)component.as(BaseComponent.class))));
        AbstractBungeeBackend.getAdditionalColorConverter().registerW2P(TextColor.class, bungeeColor -> TextColor.color(bungeeColor.red(), bungeeColor.green(), bungeeColor.blue()));
        AbstractBungeeBackend.getAdditionalClickEventConverter().registerW2P(sba.k.a.t.event.ClickEvent.class, bungeeClickEvent -> sba.k.a.t.event.ClickEvent.clickEvent(ClickEvent.Action.valueOf(bungeeClickEvent.action().name()), bungeeClickEvent.value()));
        AbstractBungeeBackend.getAdditionalHoverEventConverter().registerW2P(sba.k.a.t.event.HoverEvent.class, bungeeHoverEvent -> {
            switch (bungeeHoverEvent.action()) {
                case SHOW_ENTITY: {
                    return sba.k.a.t.event.HoverEvent.showEntity(bungeeHoverEvent.content().as(HoverEvent.ShowEntity.class));
                }
                case SHOW_ITEM: {
                    return sba.k.a.t.event.HoverEvent.showItem(bungeeHoverEvent.content().as(HoverEvent.ShowItem.class));
                }
            }
            return sba.k.a.t.event.HoverEvent.showText(bungeeHoverEvent.content().as(sba.k.a.t.Component.class));
        });
        AbstractBungeeBackend.getAdditionalItemContentConverter().registerW2P(HoverEvent.ShowItem.class, bungeeItemContent -> {
            ResourceLocation id = bungeeItemContent.id();
            CompoundTag tag = bungeeItemContent.tag();
            BinaryTagHolder value = null;
            if (tag != null) {
                value = AdventureFeature.BINARY_TAG_HOLDER_NEW_FACTORY_METHOD.isSupported() ? BinaryTagHolder.binaryTagHolder(snbtSerializerLocal.serialize(tag)) : BinaryTagHolder.of(snbtSerializerLocal.serialize(tag));
            }
            return HoverEvent.ShowItem.of(Key.key(id.namespace(), id.path()), bungeeItemContent.count(), value);
        });
        AbstractBungeeBackend.getAdditionalEntityContentConverter().registerW2P(HoverEvent.ShowEntity.class, bungeeEntityContent -> {
            ResourceLocation type = bungeeEntityContent.type();
            Component name = bungeeEntityContent.name();
            return HoverEvent.ShowEntity.of(Key.key(type.namespace(), type.path()), bungeeEntityContent.id(), name != null ? name.as(sba.k.a.t.Component.class) : null);
        });
        return adventureBackend;
    }

    @NotNull
    static <A extends Adapter> A adapter(@NotNull sba.sl.s.CommandSender wrapper, @NotNull CommandSender sender) {
        if (sender instanceof Player && wrapper instanceof PlayerAudience) {
            return (A)new AdventurePlayerAdapter((Audience)sender, (PlayerAudience)((Object)wrapper));
        }
        if (sender instanceof ConsoleCommandSender && wrapper instanceof ConsoleAudience) {
            return (A)new AdventureConsoleAdapter((Audience)sender, (ConsoleAudience)((Object)wrapper));
        }
        return (A)new AdventureAdapter((Audience)sender, wrapper);
    }

    @Generated
    private SpigotBackendAdventureExtension() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

