/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.spectator.title;

import java.time.Duration;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.spectator.Component;
import sba.sl.spectator.title.TimesProvider;
import sba.sl.spectator.title.Title;

public class BukkitTitle
implements Title {
    @NotNull
    private final Component title;
    @NotNull
    private final Component subtitle;
    @NotNull
    private final Duration fadeIn;
    @NotNull
    private final Duration stay;
    @NotNull
    private final Duration fadeOut;

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type.isInstance(this)) {
            return (T)this;
        }
        throw new UnsupportedOperationException("Bukkit doesn't have any class for titles, just methods");
    }

    @Override
    @NotNull
    public Object raw() {
        throw new UnsupportedOperationException("Bukkit doesn't have any class for titles, just methods");
    }

    @Override
    @NotNull
    public Title withTitle(@NotNull Component title) {
        return new BukkitTitle(title, this.subtitle, this.fadeIn, this.stay, this.fadeOut);
    }

    @Override
    @NotNull
    public Title withSubtitle(@NotNull Component subtitle) {
        return new BukkitTitle(this.title, subtitle, this.fadeIn, this.stay, this.fadeOut);
    }

    @Override
    @NotNull
    public Title withTimes(@NotNull TimesProvider times) {
        return new BukkitTitle(this.title, this.subtitle, times.fadeIn(), times.stay(), times.fadeOut());
    }

    @Override
    @NotNull
    public Title withTimes(@Nullable Duration fadeIn, @Nullable Duration stay, @Nullable Duration fadeOut) {
        return new BukkitTitle(this.title, this.subtitle, fadeIn == null ? Duration.ofMillis(500L) : fadeIn, stay == null ? Duration.ofMillis(3500L) : stay, fadeOut == null ? Duration.ofMillis(1000L) : fadeOut);
    }

    @Override
    @NotNull
    public Title withTimes(long fadeIn, long stay, long fadeOut) {
        return new BukkitTitle(this.title, this.subtitle, Duration.ofMillis(fadeIn * 50L), Duration.ofMillis(stay * 50L), Duration.ofMillis(fadeOut * 50L));
    }

    @Override
    @NotNull
    public Title withFadeIn(@Nullable Duration fadeIn) {
        return new BukkitTitle(this.title, this.subtitle, fadeIn == null ? Duration.ofMillis(500L) : fadeIn, this.stay, this.fadeOut);
    }

    @Override
    @NotNull
    public Title withStay(@Nullable Duration stay) {
        return new BukkitTitle(this.title, this.subtitle, this.fadeIn, stay == null ? Duration.ofMillis(3500L) : stay, this.fadeOut);
    }

    @Override
    @NotNull
    public Title withFadeOut(@Nullable Duration fadeOut) {
        return new BukkitTitle(this.title, this.subtitle, this.fadeIn, this.stay, fadeOut == null ? Duration.ofMillis(1000L) : fadeOut);
    }

    @Override
    @NotNull
    public Title withFadeIn(long ticks) {
        return new BukkitTitle(this.title, this.subtitle, Duration.ofMillis(ticks * 50L), this.stay, this.fadeOut);
    }

    @Override
    @NotNull
    public Title withStay(long ticks) {
        return new BukkitTitle(this.title, this.subtitle, this.fadeIn, Duration.ofMillis(ticks * 50L), this.fadeOut);
    }

    @Override
    @NotNull
    public Title withFadeOut(long ticks) {
        return new BukkitTitle(this.title, this.subtitle, this.fadeIn, this.stay, Duration.ofMillis(ticks * 50L));
    }

    @Override
    public @NotNull Title.Builder toBuilder() {
        return new BukkitTitleBuilder(this.title, this.subtitle, this.fadeIn, this.stay, this.fadeOut);
    }

    @Generated
    public BukkitTitle(@NotNull Component title, @NotNull Component subtitle, @NotNull Duration fadeIn, @NotNull Duration stay, @NotNull Duration fadeOut) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (subtitle == null) {
            throw new NullPointerException("subtitle is marked non-null but is null");
        }
        if (fadeIn == null) {
            throw new NullPointerException("fadeIn is marked non-null but is null");
        }
        if (stay == null) {
            throw new NullPointerException("stay is marked non-null but is null");
        }
        if (fadeOut == null) {
            throw new NullPointerException("fadeOut is marked non-null but is null");
        }
        this.title = title;
        this.subtitle = subtitle;
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }

    @Override
    @NotNull
    @Generated
    public Component title() {
        return this.title;
    }

    @Override
    @NotNull
    @Generated
    public Component subtitle() {
        return this.subtitle;
    }

    @Override
    @NotNull
    @Generated
    public Duration fadeIn() {
        return this.fadeIn;
    }

    @Override
    @NotNull
    @Generated
    public Duration stay() {
        return this.stay;
    }

    @Override
    @NotNull
    @Generated
    public Duration fadeOut() {
        return this.fadeOut;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitTitle)) {
            return false;
        }
        BukkitTitle other = (BukkitTitle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Component this$title = this.title();
        Component other$title = other.title();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Component this$subtitle = this.subtitle();
        Component other$subtitle = other.subtitle();
        if (this$subtitle == null ? other$subtitle != null : !this$subtitle.equals(other$subtitle)) {
            return false;
        }
        Duration this$fadeIn = this.fadeIn();
        Duration other$fadeIn = other.fadeIn();
        if (this$fadeIn == null ? other$fadeIn != null : !((Object)this$fadeIn).equals(other$fadeIn)) {
            return false;
        }
        Duration this$stay = this.stay();
        Duration other$stay = other.stay();
        if (this$stay == null ? other$stay != null : !((Object)this$stay).equals(other$stay)) {
            return false;
        }
        Duration this$fadeOut = this.fadeOut();
        Duration other$fadeOut = other.fadeOut();
        return !(this$fadeOut == null ? other$fadeOut != null : !((Object)this$fadeOut).equals(other$fadeOut));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitTitle;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Component $title = this.title();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Component $subtitle = this.subtitle();
        result = result * 59 + ($subtitle == null ? 43 : $subtitle.hashCode());
        Duration $fadeIn = this.fadeIn();
        result = result * 59 + ($fadeIn == null ? 43 : ((Object)$fadeIn).hashCode());
        Duration $stay = this.stay();
        result = result * 59 + ($stay == null ? 43 : ((Object)$stay).hashCode());
        Duration $fadeOut = this.fadeOut();
        result = result * 59 + ($fadeOut == null ? 43 : ((Object)$fadeOut).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitTitle(title=" + String.valueOf(this.title()) + ", subtitle=" + String.valueOf(this.subtitle()) + ", fadeIn=" + String.valueOf(this.fadeIn()) + ", stay=" + String.valueOf(this.stay()) + ", fadeOut=" + String.valueOf(this.fadeOut()) + ")";
    }

    public static class BukkitTitleBuilder
    implements Title.Builder {
        @Nullable
        private Component title;
        @Nullable
        private Component subtitle;
        @Nullable
        private Duration fadeIn;
        @Nullable
        private Duration stay;
        @Nullable
        private Duration fadeOut;

        @Override
        @NotNull
        public Title build() {
            return new BukkitTitle(this.title == null ? Component.empty() : this.title, this.subtitle == null ? Component.empty() : this.subtitle, this.fadeIn == null ? Duration.ofMillis(500L) : this.fadeIn, this.stay == null ? Duration.ofMillis(3500L) : this.stay, this.fadeOut == null ? Duration.ofMillis(1000L) : this.fadeOut);
        }

        @Generated
        public BukkitTitleBuilder() {
        }

        @Generated
        public BukkitTitleBuilder(@Nullable Component title, @Nullable Component subtitle, @Nullable Duration fadeIn, @Nullable Duration stay, @Nullable Duration fadeOut) {
            this.title = title;
            this.subtitle = subtitle;
            this.fadeIn = fadeIn;
            this.stay = stay;
            this.fadeOut = fadeOut;
        }

        @Override
        @Generated
        public BukkitTitleBuilder title(@Nullable Component title) {
            this.title = title;
            return this;
        }

        @Override
        @Generated
        public BukkitTitleBuilder subtitle(@Nullable Component subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        @Override
        @Generated
        public BukkitTitleBuilder fadeIn(@Nullable Duration fadeIn) {
            this.fadeIn = fadeIn;
            return this;
        }

        @Override
        @Generated
        public BukkitTitleBuilder stay(@Nullable Duration stay) {
            this.stay = stay;
            return this;
        }

        @Override
        @Generated
        public BukkitTitleBuilder fadeOut(@Nullable Duration fadeOut) {
            this.fadeOut = fadeOut;
            return this;
        }
    }
}

