/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.utils.nms;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import sba.sl.impl.bukkit.utils.DataFixerUtils;
import sba.sl.impl.nms.accessors.core.IRegistryAccessor;
import sba.sl.impl.nms.accessors.core.MappedRegistryAccessor;
import sba.sl.impl.nms.accessors.core.RegistryAccessAccessor;
import sba.sl.impl.nms.accessors.core.registries.BuiltInRegistriesAccessor;
import sba.sl.impl.nms.accessors.network.chat.Component$SerializerAccessor;
import sba.sl.impl.nms.accessors.network.chat.ComponentSerializationAccessor;
import sba.sl.impl.nms.accessors.network.protocol.PacketAccessor;
import sba.sl.impl.nms.accessors.server.level.ServerPlayerAccessor;
import sba.sl.impl.nms.accessors.server.network.ServerCommonPacketListenerImplAccessor;
import sba.sl.impl.nms.accessors.server.network.ServerGamePacketListenerImplAccessor;
import sba.sl.impl.nms.accessors.world.entity.EntityTypeAccessor;
import sba.sl.impl.nms.accessors.world.item.ItemStackAccessor;
import sba.sl.spectator.Component;
import sba.sl.u.Preconditions;
import sba.sl.u.reflect.InvocationResult;
import sba.sl.u.reflect.Reflect;

public final class ClassStorage {
    @NotNull
    public static final String CB_PACKAGE = Bukkit.getServer().getClass().getPackage().getName();

    public static Object getMinecraftServerObject() {
        return Reflect.fastInvoke((Object)Bukkit.getServer(), "getServer");
    }

    public static Object getHandle(Object obj) {
        return Reflect.getMethod(obj, "getHandle", new Class[0]).invoke(new Object[0]);
    }

    public static Object getHandleOfItemStack(Object obj) {
        return Reflect.getField(obj, "handle");
    }

    public static Object getPlayerConnection(Player player) {
        return Reflect.getMethod((Object)player, "getHandle", new Class[0]).invokeResulted(new Object[0]).getField(ServerPlayerAccessor.FIELD_CONNECTION.get());
    }

    public static boolean sendNMSConstructedPacket(Player player, Object packet) {
        if (!PacketAccessor.TYPE.get().isInstance(packet)) {
            return false;
        }
        Object connection = ClassStorage.getPlayerConnection(player);
        if (connection != null) {
            Reflect.fastInvoke(connection, ServerCommonPacketListenerImplAccessor.METHOD_SEND.get() != null ? ServerCommonPacketListenerImplAccessor.METHOD_SEND.get() : ServerGamePacketListenerImplAccessor.METHOD_SEND.get(), packet);
            return true;
        }
        return false;
    }

    @NotNull
    public static Object asMinecraftComponent(@NotNull Component component) {
        return ClassStorage.asMinecraftComponent(component.toJavaJson());
    }

    @NotNull
    public static Object asMinecraftComponent(@NotNull String javaJson) {
        if (Component$SerializerAccessor.METHOD_FROM_JSON.get() != null) {
            return Reflect.fastInvoke(Component$SerializerAccessor.METHOD_FROM_JSON.get(), javaJson);
        }
        if (Component$SerializerAccessor.METHOD_FROM_JSON_LENIENT.get() != null) {
            return Reflect.fastInvoke(Component$SerializerAccessor.METHOD_FROM_JSON_LENIENT.get(), javaJson, RegistryAccessAccessor.CONST_EMPTY.get());
        }
        if (ComponentSerializationAccessor.TYPE.get() != null) {
            return DataFixerUtils.parseComponent(javaJson);
        }
        throw new IllegalArgumentException("Cannot convert component to MinecraftComponent");
    }

    public static Object stackAsNMS(ItemStack item) {
        Preconditions.checkNotNull(item, "Item is null!");
        return Reflect.getMethod(CB.CraftItemStack, "asNMSCopy", ItemStack.class).invokeStatic(item);
    }

    public static ItemStack asCBStack(ItemStack item) {
        Preconditions.checkNotNull(item, "Item is null!");
        return (ItemStack)Reflect.getMethod(CB.CraftItemStack, "asCraftCopy", ItemStack.class).invokeStatic(item);
    }

    public static ItemStack nmsAsStack(Object nmsStack) {
        return (ItemStack)Reflect.getMethod(CB.CraftItemStack, "asCraftMirror", ItemStackAccessor.TYPE.get()).invokeStatic(nmsStack);
    }

    public static int getEntityTypeId(String key, Class<?> clazz) {
        Object registry1_19_3 = BuiltInRegistriesAccessor.CONST_ENTITY_TYPE.get();
        if (registry1_19_3 != null) {
            Object optional = Reflect.fastInvoke(EntityTypeAccessor.METHOD_BY_STRING.get(), key);
            return Reflect.fastInvokeResulted(registry1_19_3, IRegistryAccessor.METHOD_GET_ID.get(), ((Optional)optional).orElse(null)).asOptional(Integer.class).orElse(0);
        }
        Object registry = IRegistryAccessor.CONST_ENTITY_TYPE.get();
        if (registry != null) {
            Object optional = Reflect.fastInvoke(EntityTypeAccessor.METHOD_BY_STRING.get(), key);
            if (optional instanceof Optional) {
                return Reflect.fastInvokeResulted(registry, IRegistryAccessor.METHOD_GET_ID.get(), ((Optional)optional).orElse(null)).asOptional(Integer.class).orElse(0);
            }
            Object nullable = Reflect.fastInvoke(EntityTypeAccessor.METHOD_FUNC_200713_A.get(), key);
            return Reflect.fastInvokeResulted(registry, IRegistryAccessor.METHOD_GET_ID.get(), nullable).asOptional(Integer.class).orElse(0);
        }
        if (EntityTypeAccessor.CONST_FIELD_191308_B.get() != null) {
            return Reflect.fastInvokeResulted(EntityTypeAccessor.CONST_FIELD_191308_B.get(), MappedRegistryAccessor.METHOD_FUNC_148757_B.get(), clazz).asOptional(Integer.class).orElse(0);
        }
        return (Integer)InvocationResult.wrap(EntityTypeAccessor.CONST_FIELD_75624_E.get()).as(Map.class).get(clazz);
    }

    @Generated
    private ClassStorage() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class CB {
        public static final Class<?> CraftAttribute = Reflect.getClassSafe(CB_PACKAGE + ".attribute.CraftAttribute");
        public static final Class<?> CraftAttributeMap = Reflect.getClassSafe(CB_PACKAGE + ".attribute.CraftAttributeMap");
        public static final Class<?> CraftItemStack = Reflect.getClassSafe(CB_PACKAGE + ".inventory.CraftItemStack");
        public static final Class<?> CraftMagicNumbers = Reflect.getClassSafe(CB_PACKAGE + ".util.CraftMagicNumbers");
        public static final Class<?> CraftSound = Reflect.getClassSafe(CB_PACKAGE + ".CraftSound");

        @Generated
        private CB() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

