/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bungee.spectator;

import com.google.gson.Gson;
import java.awt.Color;
import java.util.Locale;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.KeybindComponent;
import net.md_5.bungee.api.chat.ScoreComponent;
import net.md_5.bungee.api.chat.SelectorComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.chat.ChatVersion;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.chat.VersionedComponentSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bungee.spectator.BungeeChatFeature;
import sba.sl.impl.bungee.spectator.BungeeColor;
import sba.sl.impl.bungee.spectator.BungeeComponent;
import sba.sl.impl.bungee.spectator.BungeeKeybindComponent;
import sba.sl.impl.bungee.spectator.BungeeScoreComponent;
import sba.sl.impl.bungee.spectator.BungeeSelectorComponent;
import sba.sl.impl.bungee.spectator.BungeeShadowColor;
import sba.sl.impl.bungee.spectator.BungeeTextComponent;
import sba.sl.impl.bungee.spectator.BungeeTranslatableContent;
import sba.sl.impl.bungee.spectator.PortedBungeeBlockNBTComponent;
import sba.sl.impl.bungee.spectator.PortedBungeeEntityNBTComponent;
import sba.sl.impl.bungee.spectator.PortedBungeeScoreComponent;
import sba.sl.impl.bungee.spectator.PortedBungeeSelectorComponent;
import sba.sl.impl.bungee.spectator.PortedBungeeStorageNBTComponent;
import sba.sl.impl.bungee.spectator.backports.BasePortedComponent;
import sba.sl.impl.bungee.spectator.backports.BlockNBTPortedComponent;
import sba.sl.impl.bungee.spectator.backports.EntityNBTPortedComponent;
import sba.sl.impl.bungee.spectator.backports.Injector;
import sba.sl.impl.bungee.spectator.backports.PortedComponentSerializer1_21_R02;
import sba.sl.impl.bungee.spectator.backports.ScorePortedComponent;
import sba.sl.impl.bungee.spectator.backports.SelectorPortedComponent;
import sba.sl.impl.bungee.spectator.backports.StorageNBTPortedComponent;
import sba.sl.impl.bungee.spectator.compat.PortedComponentSerializerOld;
import sba.sl.impl.bungee.spectator.event.BungeeClickEvent;
import sba.sl.impl.bungee.spectator.event.BungeeHoverEvent;
import sba.sl.impl.bungee.spectator.event.hover.BungeeEntityContent;
import sba.sl.impl.bungee.spectator.event.hover.BungeeItemContent;
import sba.sl.impl.bungee.spectator.event.hover.BungeeLegacyEntityContent;
import sba.sl.impl.bungee.spectator.event.hover.BungeeLegacyItemContent;
import sba.sl.impl.spectator.SpectatorBackend;
import sba.sl.nbt.SNBTSerializer;
import sba.sl.spectator.Component;
import sba.sl.spectator.ShadowColor;
import sba.sl.u.BidirectionalConverter;
import sba.sl.u.reflect.Reflect;

public abstract class AbstractBungeeBackend
implements SpectatorBackend {
    @NotNull
    private static final BidirectionalConverter<BungeeComponent> additionalComponentConverter = BidirectionalConverter.build();
    @NotNull
    private static final BidirectionalConverter<BungeeClickEvent> additionalClickEventConverter = BidirectionalConverter.build();
    @NotNull
    private static final BidirectionalConverter<BungeeHoverEvent> additionalHoverEventConverter = BidirectionalConverter.build();
    @NotNull
    private static final BidirectionalConverter<BungeeEntityContent> additionalEntityContentConverter = BidirectionalConverter.build();
    @NotNull
    private static final BidirectionalConverter<BungeeItemContent> additionalItemContentConverter = BidirectionalConverter.build();
    @NotNull
    private static final BidirectionalConverter<BungeeColor> additionalColorConverter = BidirectionalConverter.build();
    @NotNull
    private static final BidirectionalConverter<BungeeShadowColor> additionalShadowColorConverter = BidirectionalConverter.build();
    @NotNull
    private static final Component empty = AbstractBungeeBackend.wrapComponent((BaseComponent)new TextComponent(""));
    @NotNull
    private static final Component newLine = AbstractBungeeBackend.wrapComponent((BaseComponent)new TextComponent("\n"));
    @NotNull
    private static final Component space = AbstractBungeeBackend.wrapComponent((BaseComponent)new TextComponent(" "));
    @NotNull
    protected static SNBTSerializer snbtSerializer = SNBTSerializer.builder().shouldSaveLongArraysDirectly(false).build();
    static final boolean COMPONENTS_PORTED_SUCCESSFULLY;

    @Override
    @NotNull
    public Component empty() {
        return empty;
    }

    @Override
    @NotNull
    public Component newLine() {
        return newLine;
    }

    @Override
    @NotNull
    public Component space() {
        return space;
    }

    @Override
    @Nullable
    public Component fromPlatform(@NotNull Object platformObject) {
        if (platformObject instanceof Component) {
            return (Component)platformObject;
        }
        if (platformObject instanceof BaseComponent) {
            return AbstractBungeeBackend.wrapComponent((BaseComponent)platformObject);
        }
        throw new IllegalArgumentException("Not possible to convert unknown object type to Component: " + String.valueOf(platformObject));
    }

    @Override
    public  @NotNull BlockNBTComponent.Builder blockNBT() {
        if (COMPONENTS_PORTED_SUCCESSFULLY) {
            return new PortedBungeeBlockNBTComponent.BungeeBlockNBTBuilder(new BlockNBTPortedComponent());
        }
        throw new UnsupportedOperationException("Not implemented for md_5 ChatComponent API!");
    }

    @Override
    public  @NotNull EntityNBTComponent.Builder entityNBT() {
        if (COMPONENTS_PORTED_SUCCESSFULLY) {
            return new PortedBungeeEntityNBTComponent.BungeeEntityNBTBuilder(new EntityNBTPortedComponent());
        }
        throw new UnsupportedOperationException("Not implemented for md_5 ChatComponent API!");
    }

    @Override
    public  @NotNull KeybindComponent.Builder keybind() {
        if (BungeeChatFeature.KEYBIND_COMPONENT.isSupported()) {
            return new BungeeKeybindComponent.BungeeKeybindBuilder(new KeybindComponent(""));
        }
        throw new UnsupportedOperationException("Not supported on this version of md_5 ChatComponent API!");
    }

    @Override
    public  @NotNull ScoreComponent.Builder score() {
        if (BungeeChatFeature.SCORE_COMPONENT.isSupported()) {
            return new BungeeScoreComponent.BungeeScoreBuilder(new ScoreComponent("", ""));
        }
        if (COMPONENTS_PORTED_SUCCESSFULLY) {
            return new PortedBungeeScoreComponent.BungeeScoreBuilder(new ScorePortedComponent("", ""));
        }
        throw new UnsupportedOperationException("Not implemented for this version of md_5 ChatComponent API!");
    }

    @Override
    public  @NotNull SelectorComponent.Builder selector() {
        if (BungeeChatFeature.SELECTOR_COMPONENT.isSupported()) {
            if (!BungeeChatFeature.SELECTOR_COMPONENT_SEPARATORS.isSupported() && COMPONENTS_PORTED_SUCCESSFULLY) {
                return new BungeeSelectorComponent.MultipleImplementationsBuilder(new SelectorComponent(""));
            }
            return new BungeeSelectorComponent.BungeeSelectorBuilder(new SelectorComponent(""));
        }
        if (COMPONENTS_PORTED_SUCCESSFULLY) {
            return new PortedBungeeSelectorComponent.BungeeSelectorBuilder(new SelectorPortedComponent(""));
        }
        throw new UnsupportedOperationException("Not implemented for this version of md_5 ChatComponent API yet!");
    }

    @Override
    public  @NotNull StorageNBTComponent.Builder storageNBT() {
        if (COMPONENTS_PORTED_SUCCESSFULLY) {
            return new PortedBungeeStorageNBTComponent.BungeeStorageNBTBuilder(new StorageNBTPortedComponent());
        }
        throw new UnsupportedOperationException("Not implemented for md_5 ChatComponent API!");
    }

    @Override
    public  @NotNull TextComponent.Builder text() {
        return new BungeeTextComponent.BungeeTextBuilder(new TextComponent(""));
    }

    @Override
    public  @NotNull TranslatableComponent.Builder translatable() {
        return new BungeeTranslatableContent.BungeeTranslatableBuilder(new TranslatableComponent("", new Object[0]));
    }

    @Override
    @NotNull
    public sba.sl.spectator.Color rgb(int red, int green, int blue) {
        int combined = red << 16 | green << 8 | blue;
        if (BungeeChatFeature.RGB_COLORS.isSupported()) {
            return new BungeeColor(ChatColor.of((String)String.format("#%06X", 0xFFFFFF & combined)));
        }
        switch (combined) {
            case 170: {
                return new BungeeColor(ChatColor.DARK_BLUE);
            }
            case 43520: {
                return new BungeeColor(ChatColor.DARK_GREEN);
            }
            case 43690: {
                return new BungeeColor(ChatColor.DARK_AQUA);
            }
            case 0xAA0000: {
                return new BungeeColor(ChatColor.DARK_RED);
            }
            case 0xAA00AA: {
                return new BungeeColor(ChatColor.DARK_PURPLE);
            }
            case 0xFFAA00: {
                return new BungeeColor(ChatColor.GOLD);
            }
            case 0xAAAAAA: {
                return new BungeeColor(ChatColor.GRAY);
            }
            case 0x555555: {
                return new BungeeColor(ChatColor.DARK_GRAY);
            }
            case 0x5555FF: {
                return new BungeeColor(ChatColor.BLUE);
            }
            case 0x55FF55: {
                return new BungeeColor(ChatColor.GREEN);
            }
            case 0x55FFFF: {
                return new BungeeColor(ChatColor.AQUA);
            }
            case 0xFF5555: {
                return new BungeeColor(ChatColor.RED);
            }
            case 0xFF55FF: {
                return new BungeeColor(ChatColor.LIGHT_PURPLE);
            }
            case 0xFFFF55: {
                return new BungeeColor(ChatColor.YELLOW);
            }
            case 0xFFFFFF: {
                return new BungeeColor(ChatColor.WHITE);
            }
        }
        return this.nearestNamedTo(red, green, blue);
    }

    @Override
    @Nullable
    public sba.sl.spectator.Color named(@NotNull String name) {
        if ("grey".equalsIgnoreCase(name)) {
            name = "gray";
        } else if ("dark_grey".equalsIgnoreCase(name)) {
            name = "dark_gray";
        }
        try {
            return new BungeeColor(ChatColor.valueOf((String)name.toUpperCase(Locale.ROOT)));
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    @NotNull
    public sba.sl.spectator.Color hexOrName(@NotNull String hexOrName) {
        block10: {
            if (BungeeChatFeature.RGB_COLORS.isSupported()) {
                try {
                    return new BungeeColor(ChatColor.of((String)hexOrName.toLowerCase(Locale.ROOT)));
                }
                catch (Throwable throwable) {
                    if (hexOrName.length() == 6) {
                        try {
                            return new BungeeColor(ChatColor.of((String)("#" + hexOrName.toLowerCase(Locale.ROOT))));
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    if (hexOrName.length() != 3) break block10;
                    try {
                        return new BungeeColor(ChatColor.of((String)("#" + hexOrName.charAt(0) + hexOrName.charAt(0) + hexOrName.charAt(1) + hexOrName.charAt(1) + hexOrName.charAt(2) + hexOrName.charAt(2))));
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            return new BungeeColor(ChatColor.valueOf((String)hexOrName.toUpperCase(Locale.ROOT)));
        }
        catch (Throwable throwable) {
            return new BungeeColor(ChatColor.WHITE);
        }
    }

    @Override
    @NotNull
    public sba.sl.spectator.Color nearestNamedTo(@Nullable sba.sl.spectator.Color color) {
        if (color == null) {
            return sba.sl.spectator.Color.WHITE;
        }
        return this.nearestNamedTo(color.red(), color.green(), color.blue());
    }

    @NotNull
    private sba.sl.spectator.Color nearestNamedTo(int red, int green, int blue) {
        float matchedDistance = Float.MAX_VALUE;
        sba.sl.spectator.Color match = sba.sl.spectator.Color.WHITE;
        for (sba.sl.spectator.Color potential : sba.sl.spectator.Color.NAMED_VALUES.values()) {
            float distance = AbstractBungeeBackend.distance(this.rgbToHsvArray(red, green, blue), this.rgbToHsvArray(potential.red(), potential.green(), potential.blue()));
            if (distance < matchedDistance) {
                match = potential;
                matchedDistance = distance;
            }
            if (distance != 0.0f) continue;
            break;
        }
        return match;
    }

    private float[] rgbToHsvArray(int red, int green, int blue) {
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float delta = max - min;
        float s = max != 0.0f ? delta / max : 0.0f;
        if (s == 0.0f) {
            return new float[]{0.0f, 0.0f, max};
        }
        float h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
        if ((h *= 60.0f) < 0.0f) {
            h += 360.0f;
        }
        return new float[]{h / 360.0f, s, max};
    }

    private static float distance(float[] self, float[] other) {
        float hueDistance = 3.0f * Math.min(Math.abs(self[0] - other[0]), 1.0f - Math.abs(self[0] - other[0]));
        float saturationDiff = self[1] - other[1];
        float valueDiff = self[2] - other[2];
        return hueDistance * hueDistance + saturationDiff * saturationDiff + valueDiff * valueDiff;
    }

    @Override
    public  @NotNull ClickEvent.Builder clickEvent() {
        return new BungeeClickEvent.BungeeClickBuilder();
    }

    @Override
    public  @NotNull HoverEvent.Builder hoverEvent() {
        return new BungeeHoverEvent.BungeeHoverEventBuilder();
    }

    @Override
    public  @NotNull EntityContent.Builder entityContent() {
        if (BungeeChatFeature.MODERN_HOVER_CONTENTS.isSupported()) {
            return new BungeeEntityContent.BungeeEntityContentBuilder();
        }
        return new BungeeLegacyEntityContent.BungeeLegacyEntityContentBuilder();
    }

    @Override
    public  @NotNull ItemContent.Builder itemContent() {
        if (BungeeChatFeature.MODERN_HOVER_CONTENTS.isSupported()) {
            return new BungeeItemContent.BungeeItemContentBuilder();
        }
        return new BungeeLegacyItemContent.BungeeLegacyItemContentBuilder();
    }

    @Override
    @NotNull
    public ShadowColor shadowHex(@NotNull String hexOrName) {
        if (!hexOrName.startsWith("#") && hexOrName.length() == 8 || hexOrName.startsWith("#") && hexOrName.length() == 9) {
            Object hex = !hexOrName.startsWith("#") ? "#" + hexOrName : hexOrName;
            try {
                int r = Integer.parseInt(((String)hex).substring(1, 3), 16);
                int g = Integer.parseInt(((String)hex).substring(3, 5), 16);
                int b = Integer.parseInt(((String)hex).substring(5, 7), 16);
                int a = Integer.parseInt(((String)hex).substring(7, 9), 16);
                return new BungeeShadowColor(new Color(r, g, b, a));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.hexOrName(hexOrName).asShadow();
    }

    @Override
    @NotNull
    public ShadowColor shadowArgb(int alpha, int red, int green, int blue) {
        return new BungeeShadowColor(new Color(red, green, blue, alpha));
    }

    @Override
    @NotNull
    public Component fromLegacy(@NotNull String legacy) {
        if (legacy.isEmpty()) {
            return empty;
        }
        BaseComponent[] components = TextComponent.fromLegacyText((String)legacy);
        if (components.length == 0) {
            return empty;
        }
        if (components.length == 1) {
            return AbstractBungeeBackend.wrapComponent(components[0]);
        }
        return AbstractBungeeBackend.wrapComponent((BaseComponent)new TextComponent(components));
    }

    @Override
    @NotNull
    public Component fromLegacy(@NotNull String legacy, char colorChar) {
        if (legacy.isEmpty()) {
            return empty;
        }
        if (colorChar == '\u00a7') {
            return this.fromLegacy(legacy);
        }
        BaseComponent[] components = TextComponent.fromLegacyText((String)(legacy = ChatColor.translateAlternateColorCodes((char)colorChar, (String)legacy)));
        if (components.length == 0) {
            return empty;
        }
        if (components.length == 1) {
            return AbstractBungeeBackend.wrapComponent(components[0]);
        }
        return AbstractBungeeBackend.wrapComponent((BaseComponent)new TextComponent(components));
    }

    @Override
    @NotNull
    public Component fromJson(@NotNull String json) {
        if (json.isEmpty()) {
            return empty;
        }
        BaseComponent[] components = ComponentSerializer.parse((String)json);
        if (components.length == 0) {
            return empty;
        }
        if (components.length == 1) {
            return AbstractBungeeBackend.wrapComponent(components[0]);
        }
        return AbstractBungeeBackend.wrapComponent((BaseComponent)new TextComponent(components));
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static Component wrapComponent(@Nullable BaseComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof BlockNBTPortedComponent) {
            return new PortedBungeeBlockNBTComponent((BlockNBTPortedComponent)component);
        }
        if (component instanceof EntityNBTPortedComponent) {
            return new PortedBungeeEntityNBTComponent((EntityNBTPortedComponent)component);
        }
        if (component instanceof StorageNBTPortedComponent) {
            return new PortedBungeeStorageNBTComponent((StorageNBTPortedComponent)component);
        }
        if (component instanceof SelectorPortedComponent) {
            return new PortedBungeeSelectorComponent((SelectorPortedComponent)component);
        }
        if (component instanceof ScorePortedComponent) {
            return new PortedBungeeScoreComponent((ScorePortedComponent)component);
        }
        if (BungeeChatFeature.SCORE_COMPONENT.isSupported() && component instanceof ScoreComponent) {
            return new BungeeScoreComponent((ScoreComponent)component);
        }
        if (BungeeChatFeature.SELECTOR_COMPONENT.isSupported() && component instanceof SelectorComponent) {
            return new BungeeSelectorComponent((SelectorComponent)component);
        }
        if (BungeeChatFeature.KEYBIND_COMPONENT.isSupported() && component instanceof KeybindComponent) {
            return new BungeeKeybindComponent((KeybindComponent)component);
        }
        if (component instanceof TranslatableComponent) {
            return new BungeeTranslatableContent((TranslatableComponent)component);
        }
        if (component instanceof TextComponent) {
            return new BungeeTextComponent((TextComponent)component);
        }
        return new BungeeComponent(component);
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<BungeeComponent> getAdditionalComponentConverter() {
        return additionalComponentConverter;
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<BungeeClickEvent> getAdditionalClickEventConverter() {
        return additionalClickEventConverter;
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<BungeeHoverEvent> getAdditionalHoverEventConverter() {
        return additionalHoverEventConverter;
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<BungeeEntityContent> getAdditionalEntityContentConverter() {
        return additionalEntityContentConverter;
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<BungeeItemContent> getAdditionalItemContentConverter() {
        return additionalItemContentConverter;
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<BungeeColor> getAdditionalColorConverter() {
        return additionalColorConverter;
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<BungeeShadowColor> getAdditionalShadowColorConverter() {
        return additionalShadowColorConverter;
    }

    @NotNull
    @Generated
    public static Component getEmpty() {
        return empty;
    }

    @NotNull
    @Generated
    public static SNBTSerializer getSnbtSerializer() {
        return snbtSerializer;
    }

    static {
        if (BungeeChatFeature.VERSIONED_COMPONENT_SERIALIZER.isSupported()) {
            ChatVersion version;
            VersionedComponentSerializer serializer;
            Object gson;
            boolean ported = false;
            ChatVersion[] chatVersionArray = ChatVersion.values();
            int n = chatVersionArray.length;
            for (int i = 0; i < n && (ported = (gson = Reflect.getField((Object)(serializer = VersionedComponentSerializer.forVersion((ChatVersion)(version = chatVersionArray[i]))), "gson")) instanceof Gson ? Injector.injectGson((Gson)gson, gsonBuilder -> gsonBuilder.registerTypeHierarchyAdapter(BasePortedComponent.class, (Object)new PortedComponentSerializer1_21_R02(serializer))) : false); ++i) {
            }
            COMPONENTS_PORTED_SUCCESSFULLY = ported;
        } else {
            Object gson = Reflect.getField(ComponentSerializer.class, "gson");
            COMPONENTS_PORTED_SUCCESSFULLY = gson instanceof Gson ? Injector.injectGson((Gson)gson, gsonBuilder -> gsonBuilder.registerTypeHierarchyAdapter(BasePortedComponent.class, new PortedComponentSerializerOld<BasePortedComponent>(BasePortedComponent::write))) : false;
        }
    }
}

