/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bungee.spectator;

import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import net.md_5.bungee.chat.ComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import sba.sl.impl.bungee.spectator.AbstractBungeeBackend;
import sba.sl.impl.bungee.spectator.BungeeChatFeature;
import sba.sl.impl.bungee.spectator.BungeeColor;
import sba.sl.impl.bungee.spectator.BungeeShadowColor;
import sba.sl.impl.bungee.spectator.event.BungeeClickEvent;
import sba.sl.impl.bungee.spectator.event.BungeeHoverEvent;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.spectator.ShadowColor;
import sba.sl.spectator.event.HoverEvent;
import sba.sl.spectator.event.hover.EntityContent;
import sba.sl.spectator.event.hover.ItemContent;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;
import sba.sl.u.TriState;

public class BungeeComponent
extends BasicWrapper<BaseComponent>
implements Component {
    protected BungeeComponent(@NotNull BaseComponent wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public @Unmodifiable @NotNull List<@NotNull Component> children() {
        List extra = ((BaseComponent)this.wrappedObject).getExtra();
        if (extra == null || extra.isEmpty()) {
            return List.of();
        }
        return extra.stream().map(AbstractBungeeBackend::wrapComponent).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @NotNull
    public Component withChildren(@Nullable List<@NotNull Component> children) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setExtra(children == null ? null : children.stream().map(component -> component.as(BaseComponent.class).duplicate()).collect(Collectors.toList()));
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public Component withAppendix(@NotNull Component component) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.addExtra(component.as(BaseComponent.class).duplicate());
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public Component withAppendix(@NotNull ComponentLike component) {
        return this.withAppendix(component.asComponent());
    }

    @Override
    @NotNull
    public Component withAppendix(Component ... components) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        for (Component component : components) {
            duplicate.addExtra(component.as(BaseComponent.class).duplicate());
        }
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public Component withAppendix(ComponentLike ... components) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        for (ComponentLike component : components) {
            duplicate.addExtra(component.asComponent().as(BaseComponent.class).duplicate());
        }
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public Component withAppendix(@NotNull @NotNull Collection<@NotNull Component> components) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        for (Component component : components) {
            duplicate.addExtra(component.as(BaseComponent.class).duplicate());
        }
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @Nullable
    public sba.sl.spectator.Color color() {
        ChatColor color = ((BaseComponent)this.wrappedObject).getColorRaw();
        if (color == null) {
            return null;
        }
        return new BungeeColor(color);
    }

    @Override
    @Nullable
    public ShadowColor shadowColor() {
        if (BungeeChatFeature.SHADOW_COLORS.isSupported()) {
            Color shadowColor = ((BaseComponent)this.wrappedObject).getShadowColorRaw();
            return shadowColor == null ? null : new BungeeShadowColor(shadowColor);
        }
        return null;
    }

    @Override
    @NotNull
    public Component withColor(@Nullable sba.sl.spectator.Color color) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setColor(color == null ? null : color.as(ChatColor.class));
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public Component withShadowColor(@Nullable ShadowColor color) {
        if (!BungeeChatFeature.SHADOW_COLORS.isSupported()) {
            return this;
        }
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setShadowColor(color == null ? null : color.as(Color.class));
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @Nullable
    public ResourceLocation font() {
        if (BungeeChatFeature.FONT.isSupported()) {
            try {
                return ResourceLocation.of(((BaseComponent)this.wrappedObject).getFontRaw());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Component withFont(@Nullable ResourceLocation font) {
        if (BungeeChatFeature.FONT.isSupported()) {
            BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
            duplicate.setFont(font == null ? null : font.asString());
            return AbstractBungeeBackend.wrapComponent(duplicate);
        }
        return this;
    }

    @Override
    @NotNull
    public TriState bold() {
        return TriState.fromBoolean(((BaseComponent)this.wrappedObject).isBoldRaw());
    }

    @Override
    @NotNull
    public Component withBold(boolean bold) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setBold(Boolean.valueOf(bold));
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public Component withBold(@NotNull TriState bold) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setBold(bold.toBoxedBoolean());
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public TriState italic() {
        return TriState.fromBoolean(Boolean.TRUE == ((BaseComponent)this.wrappedObject).isItalicRaw());
    }

    @Override
    @NotNull
    public Component withItalic(boolean italic) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setItalic(Boolean.valueOf(italic));
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public Component withItalic(@NotNull TriState italic) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setItalic(italic.toBoxedBoolean());
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public TriState underlined() {
        return TriState.fromBoolean(((BaseComponent)this.wrappedObject).isUnderlinedRaw());
    }

    @Override
    @NotNull
    public Component withUnderlined(boolean underlined) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setUnderlined(Boolean.valueOf(underlined));
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public Component withUnderlined(@NotNull TriState underlined) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setUnderlined(underlined.toBoxedBoolean());
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public TriState strikethrough() {
        return TriState.fromBoolean(((BaseComponent)this.wrappedObject).isStrikethroughRaw());
    }

    @Override
    @NotNull
    public Component withStrikethrough(boolean strikethrough) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setStrikethrough(Boolean.valueOf(strikethrough));
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public Component withStrikethrough(@NotNull TriState strikethrough) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setStrikethrough(strikethrough.toBoxedBoolean());
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public TriState obfuscated() {
        return TriState.fromBoolean(((BaseComponent)this.wrappedObject).isObfuscatedRaw());
    }

    @Override
    @NotNull
    public Component withObfuscated(boolean obfuscated) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setObfuscated(Boolean.valueOf(obfuscated));
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public Component withObfuscated(@NotNull TriState obfuscated) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setObfuscated(obfuscated.toBoxedBoolean());
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @Nullable
    public String insertion() {
        return ((BaseComponent)this.wrappedObject).getInsertion();
    }

    @Override
    @NotNull
    public Component withInsertion(@Nullable String insertion) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setInsertion(insertion);
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @Nullable
    public sba.sl.spectator.event.HoverEvent hoverEvent() {
        HoverEvent hover = ((BaseComponent)this.wrappedObject).getHoverEvent();
        if (hover == null) {
            return null;
        }
        return new BungeeHoverEvent(hover);
    }

    @Override
    @NotNull
    public Component withHoverEvent(@Nullable sba.sl.spectator.event.HoverEvent hoverEvent) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setHoverEvent(hoverEvent == null ? null : hoverEvent.as(HoverEvent.class));
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public Component withHoverEvent(@Nullable ItemContent itemContent) {
        return this.withHoverEvent(itemContent == null ? null : sba.sl.spectator.event.HoverEvent.builder().action(HoverEvent.Action.SHOW_ITEM).content(itemContent).build());
    }

    @Override
    @NotNull
    public Component withHoverEvent(@Nullable EntityContent entityContent) {
        return this.withHoverEvent(entityContent == null ? null : sba.sl.spectator.event.HoverEvent.builder().action(HoverEvent.Action.SHOW_ENTITY).content(entityContent).build());
    }

    @Override
    @NotNull
    public Component withHoverEvent(@Nullable Component component) {
        return this.withHoverEvent(component == null ? null : sba.sl.spectator.event.HoverEvent.builder().action(HoverEvent.Action.SHOW_TEXT).content(component).build());
    }

    @Override
    @NotNull
    public Component withHoverEvent(@Nullable ComponentLike component) {
        return this.withHoverEvent(component == null ? null : sba.sl.spectator.event.HoverEvent.builder().action(HoverEvent.Action.SHOW_TEXT).content(component).build());
    }

    @Override
    @Nullable
    public sba.sl.spectator.event.ClickEvent clickEvent() {
        ClickEvent click = ((BaseComponent)this.wrappedObject).getClickEvent();
        if (click == null) {
            return null;
        }
        return new BungeeClickEvent(click);
    }

    @Override
    @NotNull
    public Component withClickEvent(@Nullable sba.sl.spectator.event.ClickEvent clickEvent) {
        BaseComponent duplicate = ((BaseComponent)this.wrappedObject).duplicate();
        duplicate.setClickEvent(clickEvent == null ? null : clickEvent.as(ClickEvent.class));
        return AbstractBungeeBackend.wrapComponent(duplicate);
    }

    @Override
    @NotNull
    public String toLegacy() {
        return ((BaseComponent)this.wrappedObject).toLegacyText();
    }

    @Override
    @NotNull
    public String toPlainText() {
        return ((BaseComponent)this.wrappedObject).toPlainText();
    }

    @Override
    @NotNull
    public String toJavaJson(boolean emitCompactComponents) {
        return ComponentSerializer.toString((BaseComponent)((BaseComponent)this.wrappedObject));
    }

    @Override
    public boolean hasStyling() {
        return ((BaseComponent)this.wrappedObject).hasFormatting();
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        try {
            if (BungeeChatFeature.MODERN_HOVER_CONTENTS.isSupported() && type == Content.class) {
                return (T)new Text(((BaseComponent)this.wrappedObject).duplicate());
            }
            return super.as(type);
        }
        catch (Throwable ignored) {
            return AbstractBungeeBackend.getAdditionalComponentConverter().convert(this, type);
        }
    }

    public static class BungeeBuilder<C extends Component, B extends Component.Builder<B, C>, A extends BaseComponent>
    implements Component.Builder<B, C> {
        @NotNull
        protected A component;

        @Override
        @NotNull
        public B color(@NotNull sba.sl.spectator.Color color) {
            this.component.setColor(color.as(ChatColor.class));
            return this.self();
        }

        @Override
        @NotNull
        public B shadowColor(@NotNull ShadowColor color) {
            if (BungeeChatFeature.SHADOW_COLORS.isSupported()) {
                this.component.setShadowColor(color.as(Color.class));
            }
            return this.self();
        }

        @Override
        @NotNull
        public B append(@NotNull Component component) {
            this.component.addExtra(component.as(BaseComponent.class).duplicate());
            return this.self();
        }

        @Override
        @NotNull
        public B append(@NotNull ComponentLike component) {
            this.component.addExtra(component.asComponent().as(BaseComponent.class).duplicate());
            return this.self();
        }

        @Override
        @NotNull
        public B append(Component ... components) {
            for (Component component : components) {
                this.append(component);
            }
            return this.self();
        }

        @Override
        @NotNull
        public B append(ComponentLike ... components) {
            for (ComponentLike component : components) {
                this.append(component);
            }
            return this.self();
        }

        @Override
        @NotNull
        public B append(@NotNull @NotNull Collection<@NotNull Component> components) {
            for (Component component : components) {
                this.append(component);
            }
            return this.self();
        }

        @Override
        @NotNull
        public B font(@Nullable ResourceLocation font) {
            if (BungeeChatFeature.FONT.isSupported()) {
                this.component.setFont(font == null ? null : font.asString());
            }
            return this.self();
        }

        @Override
        @NotNull
        public B bold(boolean bold) {
            this.component.setBold(Boolean.valueOf(bold));
            return this.self();
        }

        @Override
        @NotNull
        public B bold(@NotNull TriState bold) {
            this.component.setBold(bold.toBoxedBoolean());
            return this.self();
        }

        @Override
        @NotNull
        public B italic(boolean italic) {
            this.component.setItalic(Boolean.valueOf(italic));
            return this.self();
        }

        @Override
        @NotNull
        public B italic(@NotNull TriState italic) {
            this.component.setItalic(italic.toBoxedBoolean());
            return this.self();
        }

        @Override
        @NotNull
        public B underlined(boolean underlined) {
            this.component.setUnderlined(Boolean.valueOf(underlined));
            return this.self();
        }

        @Override
        @NotNull
        public B underlined(@NotNull TriState underlined) {
            this.component.setUnderlined(underlined.toBoxedBoolean());
            return this.self();
        }

        @Override
        @NotNull
        public B strikethrough(boolean strikethrough) {
            this.component.setStrikethrough(Boolean.valueOf(strikethrough));
            return this.self();
        }

        @Override
        @NotNull
        public B strikethrough(@NotNull TriState strikethrough) {
            this.component.setStrikethrough(strikethrough.toBoxedBoolean());
            return this.self();
        }

        @Override
        @NotNull
        public B obfuscated(@NotNull TriState obfuscated) {
            this.component.setObfuscated(obfuscated.toBoxedBoolean());
            return this.self();
        }

        @Override
        @NotNull
        public B obfuscated(boolean obfuscated) {
            this.component.setObfuscated(Boolean.valueOf(obfuscated));
            return this.self();
        }

        @Override
        @NotNull
        public B insertion(@Nullable String insertion) {
            this.component.setInsertion(insertion);
            return this.self();
        }

        @Override
        @NotNull
        public B hoverEvent(@Nullable sba.sl.spectator.event.HoverEvent event) {
            this.component.setHoverEvent(event == null ? null : event.as(HoverEvent.class));
            return this.self();
        }

        @Override
        @NotNull
        public B hoverEvent(@Nullable ItemContent itemContent) {
            this.hoverEvent(itemContent == null ? null : sba.sl.spectator.event.HoverEvent.builder().action(HoverEvent.Action.SHOW_ITEM).content(itemContent).build());
            return this.self();
        }

        @Override
        @NotNull
        public B hoverEvent(@Nullable EntityContent entityContent) {
            this.hoverEvent(entityContent == null ? null : sba.sl.spectator.event.HoverEvent.builder().action(HoverEvent.Action.SHOW_ENTITY).content(entityContent).build());
            return this.self();
        }

        @Override
        @NotNull
        public B hoverEvent(@Nullable ComponentLike component) {
            this.hoverEvent(component == null ? null : sba.sl.spectator.event.HoverEvent.builder().action(HoverEvent.Action.SHOW_TEXT).content(component).build());
            return this.self();
        }

        @Override
        @NotNull
        public B hoverEvent(@Nullable Component component) {
            this.hoverEvent(component == null ? null : sba.sl.spectator.event.HoverEvent.builder().action(HoverEvent.Action.SHOW_TEXT).content(component).build());
            return this.self();
        }

        @Override
        @NotNull
        public B clickEvent(@Nullable sba.sl.spectator.event.ClickEvent event) {
            this.component.setClickEvent(event == null ? null : event.as(ClickEvent.class));
            return this.self();
        }

        @Override
        public boolean hasStyling() {
            return this.component.hasFormatting();
        }

        @Override
        @NotNull
        public C build() {
            return (C)AbstractBungeeBackend.wrapComponent(this.component.duplicate());
        }

        @NotNull
        protected B self() {
            return (B)this;
        }

        @Generated
        public BungeeBuilder(@NotNull A component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            this.component = component;
        }

        @NotNull
        @Generated
        public A getComponent() {
            return this.component;
        }

        @Generated
        public void setComponent(@NotNull A component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            this.component = component;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BungeeBuilder)) {
                return false;
            }
            BungeeBuilder other = (BungeeBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            A this$component = this.getComponent();
            A other$component = other.getComponent();
            return !(this$component == null ? other$component != null : !this$component.equals(other$component));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BungeeBuilder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            A $component = this.getComponent();
            result = result * 59 + ($component == null ? 43 : $component.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BungeeComponent.BungeeBuilder(component=" + String.valueOf(this.getComponent()) + ")";
        }
    }
}

