/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bungee.spectator.backports;

import com.google.gson.JsonObject;
import net.md_5.bungee.api.chat.BaseComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import sba.sl.u.reflect.Reflect;

@ApiStatus.Internal
public abstract class BasePortedComponent
extends BaseComponent {
    private static final boolean HAS_COPY_FORMATTING = Reflect.hasMethod(BaseComponent.class, "copyFormatting", BaseComponent.class);
    private static final boolean HAS_INSERTION = Reflect.hasMethod(BaseComponent.class, "setInsertion", String.class);

    public BasePortedComponent() {
    }

    public BasePortedComponent(@NotNull BasePortedComponent old) {
        this.copyFrom(old);
    }

    public void copyFrom(@NotNull BaseComponent old) {
        if (HAS_COPY_FORMATTING) {
            this.copyFormatting(old);
        } else {
            this.setColor(old.getColorRaw());
            this.setBold(old.isBoldRaw());
            this.setItalic(old.isItalicRaw());
            this.setUnderlined(old.isUnderlinedRaw());
            this.setStrikethrough(old.isStrikethroughRaw());
            this.setObfuscated(old.isObfuscatedRaw());
            if (HAS_INSERTION) {
                this.setInsertion(old.getInsertion());
            }
            this.setClickEvent(old.getClickEvent());
            this.setHoverEvent(old.getHoverEvent());
        }
        if (old.getExtra() != null && (this.getExtra() == null || this.getExtra().size() != old.getExtra().size())) {
            for (BaseComponent extra : old.getExtra()) {
                this.addExtra(extra.duplicate());
            }
        }
    }

    @NotNull
    public abstract BasePortedComponent duplicate();

    public abstract void write(@NotNull JsonObject var1);
}

