/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bungee.spectator.event;

import lombok.Generated;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ClickEventCustom;
import net.md_5.bungee.api.dialog.chat.ShowDialogClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bungee.spectator.AbstractBungeeBackend;
import sba.sl.impl.bungee.spectator.BungeeChatFeature;
import sba.sl.impl.bungee.spectator.dialog.BungeeDialog;
import sba.sl.impl.bungee.spectator.dialog.BungeeDialogReference;
import sba.sl.impl.bungee.spectator.event.click.BungeeClickEventCustom;
import sba.sl.impl.bungee.spectator.event.click.BungeeShowDialogClickEvent;
import sba.sl.spectator.dialog.Dialog;
import sba.sl.spectator.event.ClickEvent;
import sba.sl.spectator.event.click.Payload;
import sba.sl.u.BasicWrapper;
import sba.sl.u.Preconditions;

public class BungeeClickEvent
extends BasicWrapper<ClickEvent>
implements sba.sl.spectator.event.ClickEvent {
    public BungeeClickEvent(@NotNull ClickEvent wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public ClickEvent.Action action() {
        try {
            return ClickEvent.Action.valueOf(((ClickEvent)this.wrappedObject).getAction().name());
        }
        catch (Throwable ignored) {
            return ClickEvent.Action.OPEN_URL;
        }
    }

    @Override
    @NotNull
    public sba.sl.spectator.event.ClickEvent withAction(@NotNull ClickEvent.Action action) {
        ClickEvent.Action bungeeAction;
        try {
            bungeeAction = ClickEvent.Action.valueOf((String)action.name());
        }
        catch (Throwable throwable) {
            bungeeAction = ClickEvent.Action.OPEN_URL;
        }
        if (BungeeChatFeature.NEW_CLICK_EVENTS.isSupported()) {
            if (action == ClickEvent.Action.CUSTOM) {
                if (this.wrappedObject instanceof ClickEventCustom) {
                    return this;
                }
                return new BungeeClickEvent((ClickEvent)new ClickEventCustom(((ClickEvent)this.wrappedObject).getValue(), null));
            }
            if (action == ClickEvent.Action.SHOW_DIALOG) {
                if (this.wrappedObject instanceof ShowDialogClickEvent) {
                    return this;
                }
                return new BungeeClickEvent((ClickEvent)new ShowDialogClickEvent(((ClickEvent)this.wrappedObject).getValue()));
            }
        }
        return new BungeeClickEvent(new ClickEvent(bungeeAction, ((ClickEvent)this.wrappedObject).getValue()));
    }

    @Override
    @NotNull
    public Payload payload() {
        String text;
        if (BungeeChatFeature.NEW_CLICK_EVENTS.isSupported()) {
            if (this.wrappedObject instanceof ClickEventCustom) {
                return new BungeeClickEventCustom((ClickEventCustom)this.wrappedObject);
            }
            if (this.wrappedObject instanceof ShowDialogClickEvent) {
                return new BungeeShowDialogClickEvent((ShowDialogClickEvent)this.wrappedObject);
            }
        }
        return Payload.text((text = ((ClickEvent)this.wrappedObject).getValue()) != null ? text : "");
    }

    @Override
    @NotNull
    public sba.sl.spectator.event.ClickEvent withPayload(@NotNull Payload payload) {
        String value;
        if (BungeeChatFeature.NEW_CLICK_EVENTS.isSupported()) {
            if (this.action() == ClickEvent.Action.CUSTOM) {
                if (payload instanceof BungeeClickEventCustom) {
                    return new BungeeClickEvent((ClickEvent)((BungeeClickEventCustom)payload).as(ClickEventCustom.class));
                }
                if (payload instanceof Payload.Custom) {
                    return new BungeeClickEvent((ClickEvent)new ClickEventCustom(((Payload.Custom)payload).location().toString(), AbstractBungeeBackend.getSnbtSerializer().serialize(((Payload.Custom)payload).tag())));
                }
                throw new IllegalArgumentException("Invalid payload type for action " + ((ClickEvent)this.wrappedObject).getAction().name() + ": " + String.valueOf(payload.getClass()));
            }
            if (this.action() == ClickEvent.Action.SHOW_DIALOG) {
                if (payload instanceof BungeeShowDialogClickEvent) {
                    return new BungeeClickEvent((ClickEvent)((BungeeShowDialogClickEvent)payload).as(ShowDialogClickEvent.class));
                }
                if (payload instanceof Payload.ShowDialog) {
                    Dialog dialog = ((Payload.ShowDialog)payload).dialog();
                    if (dialog instanceof BungeeDialog) {
                        return new BungeeClickEvent((ClickEvent)new ShowDialogClickEvent(dialog.as(net.md_5.bungee.api.dialog.Dialog.class)));
                    }
                    if (dialog instanceof BungeeDialogReference) {
                        return new BungeeClickEvent((ClickEvent)new ShowDialogClickEvent(((BungeeDialogReference)dialog).getReference()));
                    }
                }
                throw new IllegalArgumentException("Invalid payload type for action " + ((ClickEvent)this.wrappedObject).getAction().name() + ": " + String.valueOf(payload.getClass()));
            }
        }
        if (payload instanceof Payload.Text) {
            value = ((Payload.Text)payload).text();
        } else if (payload instanceof Payload.Int) {
            value = String.valueOf(((Payload.Int)payload).number());
        } else {
            throw new IllegalArgumentException("Invalid payload type for action " + ((ClickEvent)this.wrappedObject).getAction().name() + ": " + String.valueOf(payload.getClass()));
        }
        return new BungeeClickEvent(new ClickEvent(((ClickEvent)this.wrappedObject).getAction(), value));
    }

    @Override
    public  @NotNull ClickEvent.Builder toBuilder() {
        return new BungeeClickBuilder(this.action(), this.payload());
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        try {
            return super.as(type);
        }
        catch (Throwable ignored) {
            return AbstractBungeeBackend.getAdditionalClickEventConverter().convert(this, type);
        }
    }

    public static class BungeeClickBuilder
    implements ClickEvent.Builder {
        @NotNull
        private ClickEvent.Action action = ClickEvent.Action.OPEN_URL;
        @Nullable
        private Payload payload;

        @Override
        @NotNull
        public sba.sl.spectator.event.ClickEvent build() {
            String value;
            ClickEvent.Action action;
            Preconditions.checkNotNull(this.action, "Action is not specified!");
            Preconditions.checkNotNull(this.payload, "Payload is not specified!");
            try {
                action = ClickEvent.Action.valueOf((String)this.action.name());
            }
            catch (Throwable throwable) {
                action = ClickEvent.Action.OPEN_URL;
            }
            if (BungeeChatFeature.NEW_CLICK_EVENTS.isSupported()) {
                if (this.action == ClickEvent.Action.CUSTOM) {
                    if (this.payload instanceof BungeeClickEventCustom) {
                        return new BungeeClickEvent((ClickEvent)((BungeeClickEventCustom)this.payload).as(ClickEventCustom.class));
                    }
                    if (this.payload instanceof Payload.Custom) {
                        return new BungeeClickEvent((ClickEvent)new ClickEventCustom(((Payload.Custom)this.payload).location().toString(), AbstractBungeeBackend.getSnbtSerializer().serialize(((Payload.Custom)this.payload).tag())));
                    }
                    throw new IllegalArgumentException("Invalid payload type for action " + action.name() + ": " + String.valueOf(this.payload.getClass()));
                }
                if (this.action == ClickEvent.Action.SHOW_DIALOG) {
                    if (this.payload instanceof BungeeShowDialogClickEvent) {
                        return new BungeeClickEvent((ClickEvent)((BungeeShowDialogClickEvent)this.payload).as(ShowDialogClickEvent.class));
                    }
                    if (this.payload instanceof Payload.ShowDialog) {
                        Dialog dialog = ((Payload.ShowDialog)this.payload).dialog();
                        if (dialog instanceof BungeeDialog) {
                            return new BungeeClickEvent((ClickEvent)new ShowDialogClickEvent(dialog.as(net.md_5.bungee.api.dialog.Dialog.class)));
                        }
                        if (dialog instanceof BungeeDialogReference) {
                            return new BungeeClickEvent((ClickEvent)new ShowDialogClickEvent(((BungeeDialogReference)dialog).getReference()));
                        }
                    }
                    throw new IllegalArgumentException("Invalid payload type for action " + action.name() + ": " + String.valueOf(this.payload.getClass()));
                }
            }
            if (this.payload instanceof Payload.Text) {
                value = ((Payload.Text)this.payload).text();
            } else if (this.payload instanceof Payload.Int) {
                value = String.valueOf(((Payload.Int)this.payload).number());
            } else {
                throw new IllegalArgumentException("Invalid payload type for action " + action.name() + ": " + String.valueOf(this.payload.getClass()));
            }
            return new BungeeClickEvent(new ClickEvent(action, value));
        }

        @Generated
        public BungeeClickBuilder() {
        }

        @Generated
        public BungeeClickBuilder(@NotNull ClickEvent.Action action, @Nullable Payload payload) {
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.action = action;
            this.payload = payload;
        }

        @Override
        @Generated
        public BungeeClickBuilder action(@NotNull ClickEvent.Action action) {
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.action = action;
            return this;
        }

        @Override
        @Generated
        public BungeeClickBuilder payload(@Nullable Payload payload) {
            this.payload = payload;
            return this;
        }
    }
}

