/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bungee.spectator.event.hover;

import java.util.UUID;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.hover.content.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bungee.spectator.AbstractBungeeBackend;
import sba.sl.spectator.Component;
import sba.sl.spectator.event.hover.EntityContent;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;

public class BungeeEntityContent
extends BasicWrapper<Entity>
implements EntityContent {
    public BungeeEntityContent(@NotNull Entity wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public UUID id() {
        return UUID.fromString(((Entity)this.wrappedObject).getId());
    }

    @Override
    @NotNull
    public EntityContent withId(@NotNull UUID id) {
        return new BungeeEntityContent(new Entity(((Entity)this.wrappedObject).getType(), id.toString(), ((Entity)this.wrappedObject).getName()));
    }

    @Override
    @NotNull
    public ResourceLocation type() {
        String type = ((Entity)this.wrappedObject).getType();
        if (type == null) {
            return ResourceLocation.of("minecraft:pig");
        }
        return ResourceLocation.of(type);
    }

    @Override
    @NotNull
    public EntityContent withType(@NotNull ResourceLocation type) {
        return new BungeeEntityContent(new Entity(type.asString(), ((Entity)this.wrappedObject).getId(), ((Entity)this.wrappedObject).getName()));
    }

    @Override
    @Nullable
    public Component name() {
        return AbstractBungeeBackend.wrapComponent(((Entity)this.wrappedObject).getName());
    }

    @Override
    @NotNull
    public EntityContent withType(@Nullable Component name) {
        return new BungeeEntityContent(new Entity(((Entity)this.wrappedObject).getType(), ((Entity)this.wrappedObject).getId(), name == null ? null : name.as(BaseComponent.class)));
    }

    @Override
    public @NotNull EntityContent.Builder toBuilder() {
        return new BungeeEntityContentBuilder(this.id(), this.type(), this.name());
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        try {
            return super.as(type);
        }
        catch (Throwable ignored) {
            return AbstractBungeeBackend.getAdditionalEntityContentConverter().convert(this, type);
        }
    }

    public static class BungeeEntityContentBuilder
    implements EntityContent.Builder {
        private UUID id;
        private ResourceLocation type;
        private Component name;

        @Override
        @NotNull
        public EntityContent build() {
            return new BungeeEntityContent(new Entity(this.type != null ? this.type.asString() : "minecraft:pig", this.id != null ? this.id.toString() : UUID.randomUUID().toString(), this.name != null ? this.name.as(BaseComponent.class) : null));
        }

        @Generated
        public BungeeEntityContentBuilder() {
        }

        @Generated
        public BungeeEntityContentBuilder(UUID id, ResourceLocation type, Component name) {
            this.id = id;
            this.type = type;
            this.name = name;
        }

        @Override
        @Generated
        public BungeeEntityContentBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        @Override
        @Generated
        public BungeeEntityContentBuilder type(ResourceLocation type) {
            this.type = type;
            return this;
        }

        @Override
        @Generated
        public BungeeEntityContentBuilder name(Component name) {
            this.name = name;
            return this;
        }
    }
}

