/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bungee.spectator.event.hover;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bungee.spectator.AbstractBungeeBackend;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.NumericTag;
import sba.sl.nbt.StringTag;
import sba.sl.nbt.Tag;
import sba.sl.spectator.event.hover.ItemContent;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;

public class BungeeLegacyItemContent
extends BasicWrapper<CompoundTag>
implements ItemContent {
    public BungeeLegacyItemContent(@NotNull String snbt) {
        this(BungeeLegacyItemContent.readTag(snbt));
    }

    public BungeeLegacyItemContent(@NotNull CompoundTag tag) {
        super(tag);
    }

    @NotNull
    private static CompoundTag readTag(@NotNull String snbt) {
        Tag tag = AbstractBungeeBackend.getSnbtSerializer().deserialize(snbt);
        if (tag instanceof CompoundTag) {
            return (CompoundTag)tag;
        }
        return CompoundTag.EMPTY;
    }

    @Override
    @NotNull
    public ResourceLocation id() {
        Tag idTag;
        if (this.wrappedObject != null && (idTag = ((CompoundTag)this.wrappedObject).tag("id")) instanceof StringTag) {
            return ResourceLocation.of(((StringTag)idTag).value());
        }
        return ResourceLocation.of("minecraft", "air");
    }

    @Override
    @NotNull
    public ItemContent withId(@NotNull ResourceLocation id) {
        return new BungeeLegacyItemContent(((CompoundTag)this.wrappedObject).with("id", id.asString()));
    }

    @Override
    public int count() {
        Tag countTag;
        if (this.wrappedObject != null && (countTag = ((CompoundTag)this.wrappedObject).tag("Count")) instanceof NumericTag) {
            return ((NumericTag)countTag).intValue();
        }
        return 1;
    }

    @Override
    @NotNull
    public ItemContent withCount(int count) {
        return new BungeeLegacyItemContent(((CompoundTag)this.wrappedObject).with("Count", (byte)count));
    }

    @Override
    @Nullable
    public CompoundTag tag() {
        Tag tag;
        if (this.wrappedObject != null && (tag = ((CompoundTag)this.wrappedObject).tag("tag")) instanceof CompoundTag) {
            return (CompoundTag)tag;
        }
        return null;
    }

    @Override
    @NotNull
    public ItemContent withTag(@Nullable CompoundTag tag) {
        if (tag == null) {
            return new BungeeLegacyItemContent(((CompoundTag)this.wrappedObject).without("tag"));
        }
        return new BungeeLegacyItemContent(((CompoundTag)this.wrappedObject).with("tag", tag));
    }

    @Override
    public @NotNull ItemContent.Builder toBuilder() {
        return new BungeeLegacyItemContentBuilder(this.id(), this.count(), this.tag());
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type == String.class) {
            return (T)AbstractBungeeBackend.getSnbtSerializer().serialize((Tag)this.wrappedObject);
        }
        return super.as(type);
    }

    public static class BungeeLegacyItemContentBuilder
    implements ItemContent.Builder {
        @Nullable
        private ResourceLocation id;
        private int count = 1;
        @Nullable
        private CompoundTag tag;

        @Override
        @NotNull
        public ItemContent build() {
            CompoundTag compoundTag = CompoundTag.EMPTY.with("id", this.id == null ? "minecraft:air" : this.id.asString()).with("Count", (byte)this.count);
            if (this.tag != null) {
                compoundTag = compoundTag.with("tag", this.tag);
            }
            return new BungeeLegacyItemContent(compoundTag);
        }

        @Generated
        public BungeeLegacyItemContentBuilder() {
        }

        @Generated
        public BungeeLegacyItemContentBuilder(@Nullable ResourceLocation id, int count, @Nullable CompoundTag tag) {
            this.id = id;
            this.count = count;
            this.tag = tag;
        }

        @Override
        @Generated
        public BungeeLegacyItemContentBuilder id(@Nullable ResourceLocation id) {
            this.id = id;
            return this;
        }

        @Override
        @Generated
        public BungeeLegacyItemContentBuilder count(int count) {
            this.count = count;
            return this;
        }

        @Override
        @Generated
        public BungeeLegacyItemContentBuilder tag(@Nullable CompoundTag tag) {
            this.tag = tag;
            return this;
        }
    }
}

