/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.item.meta;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.sl.co.EnchantmentSerializer;
import sba.sl.i.meta.Enchantment;
import sba.sl.i.meta.EnchantmentType;
import sba.sl.u.Preconditions;
import sba.sl.u.ResourceLocation;
import sba.sl.u.RomanToDecimal;
import sba.sl.u.annotations.ProvidedService;

@ProvidedService
@ApiStatus.Internal
public abstract class EnchantmentRegistry {
    @NotNull
    private static final Pattern RESOLUTION_PATTERN = Pattern.compile("^(?<namespaced>[A-Za-z][A-Za-z0-9_.\\-/:]*)(\\s+(?<level>(\\d+|(?=[MDCLXVI])M*(C[MD]|D?C*)(X[CL]|L?X*)(I[XV]|V?I*)))?)?$");
    @Nullable
    private static EnchantmentRegistry registry;
    @NotNull
    private final @NotNull Map<@NotNull Class<?>, Function<@NotNull Object, @Nullable Enchantment>> specialMapping = new HashMap();

    protected EnchantmentRegistry() {
        Preconditions.checkArgument(registry == null, "EnchantmentRegistry is already initialized!");
        registry = this;
    }

    @Nullable
    public static Enchantment resolve(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Enchantment) {
            return (Enchantment)object;
        }
        Preconditions.checkNotNull(registry, "EnchantmentRegistry is not initialized yet!");
        if (!EnchantmentRegistry.registry.specialMapping.isEmpty()) {
            for (Map.Entry<Class<?>, Function<Object, Enchantment>> sm : EnchantmentRegistry.registry.specialMapping.entrySet()) {
                if (!sm.getKey().isInstance(object)) continue;
                return sm.getValue().apply(object);
            }
        }
        if (object instanceof ConfigurationNode) {
            try {
                return EnchantmentSerializer.INSTANCE.deserialize((Type)((Object)Enchantment.class), (ConfigurationNode)object);
            }
            catch (SerializationException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            EnchantmentType holder = EnchantmentType.ofNullable(entry.getKey());
            if (holder != null) {
                int level;
                if (entry.getValue() instanceof Number) {
                    level = ((Number)entry.getValue()).intValue();
                } else if (entry.getValue() instanceof ConfigurationNode) {
                    try {
                        level = Integer.parseInt(((ConfigurationNode)entry.getValue()).getString("1"));
                    }
                    catch (Throwable t) {
                        level = RomanToDecimal.romanToDecimal(((ConfigurationNode)entry.getValue()).getString("I"));
                    }
                } else {
                    try {
                        level = Integer.parseInt(entry.getValue().toString());
                    }
                    catch (Throwable t) {
                        level = RomanToDecimal.romanToDecimal(entry.getValue().toString());
                    }
                }
                return holder.asEnchantment(level);
            }
            return null;
        }
        @Nullable ResourceLocation location = null;
        @Nullable String levelStr = null;
        if (object instanceof ResourceLocation) {
            location = (ResourceLocation)object;
        } else {
            String enchantment = object.toString().trim();
            Matcher matcher = RESOLUTION_PATTERN.matcher(enchantment);
            if (matcher.matches() && matcher.group("namespaced") != null) {
                location = ResourceLocation.of(matcher.group("namespaced"));
                levelStr = matcher.group("level");
            }
        }
        if (location == null) {
            return null;
        }
        EnchantmentType result = EnchantmentType.ofNullable(location);
        if (result != null) {
            if (levelStr != null && !levelStr.isEmpty()) {
                int level;
                try {
                    level = Integer.parseInt(levelStr);
                }
                catch (Throwable t) {
                    level = RomanToDecimal.romanToDecimal(levelStr);
                }
                return result.asEnchantment(level);
            }
            return result.asEnchantment();
        }
        return null;
    }

    @ApiStatus.Internal
    protected <E> void specialType(@NotNull Class<E> eClass, @NotNull @NotNull Function<@NotNull E, @Nullable Enchantment> function) {
        this.specialMapping.put(eClass, function);
    }
}

