/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class Primitives {
    @NotNull
    private static final @NotNull Map<@NotNull Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;
    @NotNull
    private static final @NotNull Map<@NotNull Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPE;

    private static void add(@NotNull @NotNull Map<@NotNull Class<?>, Class<?>> forward, @NotNull @NotNull Map<@NotNull Class<?>, Class<?>> backward, @NotNull Class<?> key, @NotNull Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    @NotNull
    public static @NotNull Set<@NotNull Class<?>> allPrimitiveTypes() {
        return PRIMITIVE_TO_WRAPPER_TYPE.keySet();
    }

    @NotNull
    public static @NotNull Set<@NotNull Class<?>> allWrapperTypes() {
        return WRAPPER_TO_PRIMITIVE_TYPE.keySet();
    }

    public static boolean isWrapperType(@NotNull Class<?> type) {
        return WRAPPER_TO_PRIMITIVE_TYPE.containsKey(type);
    }

    @NotNull
    public static <T> Class<T> wrap(@NotNull Class<T> type) {
        Class<?> wrapped = PRIMITIVE_TO_WRAPPER_TYPE.get(type);
        return wrapped == null ? type : wrapped;
    }

    @NotNull
    public static <T> Class<T> unwrap(@NotNull Class<T> type) {
        Class<?> unwrapped = WRAPPER_TO_PRIMITIVE_TYPE.get(type);
        return unwrapped == null ? type : unwrapped;
    }

    @Generated
    private Primitives() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        @NotNull @NotNull HashMap<@NotNull Class<?>, Class<?>> primToWrap = new HashMap(16);
        @NotNull @NotNull HashMap<@NotNull Class<?>, Class<?>> wrapToPrim = new HashMap(16);
        Primitives.add(primToWrap, wrapToPrim, Boolean.TYPE, Boolean.class);
        Primitives.add(primToWrap, wrapToPrim, Byte.TYPE, Byte.class);
        Primitives.add(primToWrap, wrapToPrim, Character.TYPE, Character.class);
        Primitives.add(primToWrap, wrapToPrim, Double.TYPE, Double.class);
        Primitives.add(primToWrap, wrapToPrim, Float.TYPE, Float.class);
        Primitives.add(primToWrap, wrapToPrim, Integer.TYPE, Integer.class);
        Primitives.add(primToWrap, wrapToPrim, Long.TYPE, Long.class);
        Primitives.add(primToWrap, wrapToPrim, Short.TYPE, Short.class);
        Primitives.add(primToWrap, wrapToPrim, Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(primToWrap);
        WRAPPER_TO_PRIMITIVE_TYPE = Collections.unmodifiableMap(wrapToPrim);
    }
}

