/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.utils.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class ImmutableCollectionLinkedToCollection<L, O>
implements Collection<L> {
    @NotNull
    protected final Collection<O> original;
    @NotNull
    protected final Function<L, O> linkToOriginal;
    @NotNull
    protected final Function<O, L> originalToLink;

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.original.contains(this.linkToOriginal.apply(o));
    }

    @Override
    @NotNull
    public Iterator<L> iterator() {
        final Iterator<O> realIterator = this.original.iterator();
        return new Iterator<L>(){

            @Override
            public boolean hasNext() {
                return realIterator.hasNext();
            }

            @Override
            public L next() {
                return ImmutableCollectionLinkedToCollection.this.originalToLink.apply(realIterator.next());
            }
        };
    }

    @Override
    public Object @NotNull [] toArray() {
        return this.original.stream().map(this.originalToLink).toArray();
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] a) {
        return this.original.stream().map(this.originalToLink).toArray((int value) -> (Object[])Array.newInstance(a.getClass().getComponentType(), value));
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.original.containsAll(c.stream().map(o -> this.linkToOriginal.apply(o)).collect(Collectors.toList()));
    }

    @Override
    public boolean add(L e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends L> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Generated
    public ImmutableCollectionLinkedToCollection(@NotNull Collection<O> original, @NotNull Function<L, O> linkToOriginal, @NotNull Function<O, L> originalToLink) {
        if (original == null) {
            throw new NullPointerException("original is marked non-null but is null");
        }
        if (linkToOriginal == null) {
            throw new NullPointerException("linkToOriginal is marked non-null but is null");
        }
        if (originalToLink == null) {
            throw new NullPointerException("originalToLink is marked non-null but is null");
        }
        this.original = original;
        this.linkToOriginal = linkToOriginal;
        this.originalToLink = originalToLink;
    }
}

