/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.utils.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import sba.sl.u.ResourceLocation;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

@ApiStatus.Internal
public final class SimpleRegistryItemStream<O, T extends RegistryItem>
implements RegistryItemStream<T> {
    @NotNull
    private final @NotNull Supplier<@NotNull Stream<@NotNull O>> streamSupplier;
    @NotNull
    private final @NotNull Function<@NotNull O, @NotNull T> converter;
    @NotNull
    private final @NotNull Function<@NotNull O, @NotNull ResourceLocation> locationSupplier;
    @NotNull
    private final @NotNull BiPredicate<@NotNull O, @NotNull String> literalInLocationPathChecker;
    @NotNull
    private final @NotNull BiPredicate<@NotNull O, @NotNull String> namespaceEqualityChecker;
    @NotNull
    private final @NotNull List<@NotNull Predicate<O>> operations;

    public SimpleRegistryItemStream(@NotNull @NotNull Supplier<@NotNull Stream<@NotNull O>> streamSupplier, @NotNull @NotNull Function<@NotNull O, @NotNull T> converter, @NotNull @NotNull Function<@NotNull O, @NotNull ResourceLocation> locationSupplier, @NotNull @NotNull BiPredicate<@NotNull O, @NotNull String> literalInLocationPathChecker, @NotNull @NotNull BiPredicate<@NotNull O, @NotNull String> namespaceChecker, @NotNull @NotNull List<@NotNull Predicate<O>> operations) {
        this.streamSupplier = streamSupplier;
        this.converter = converter;
        this.locationSupplier = locationSupplier;
        this.literalInLocationPathChecker = literalInLocationPathChecker;
        this.namespaceEqualityChecker = namespaceChecker;
        this.operations = List.copyOf(operations);
    }

    @NotNull
    public static <T extends RegistryItem> SimpleRegistryItemStream<?, T> createDummy() {
        return new SimpleRegistryItemStream<Object, RegistryItem>(Stream::empty, o -> null, a -> null, (o, literal) -> false, (o, namespace) -> false, List.of());
    }

    @Override
    @NotNull
    public RegistryItemStream<T> filterByLocation(@NotNull @NotNull Predicate<@NotNull ResourceLocation> predicate) {
        return this.expand(o -> predicate.test(this.locationSupplier.apply(o)));
    }

    @Override
    @NotNull
    public RegistryItemStream<T> filterByLiteralInPath(@NotNull String literal) {
        String lowerCaseLiteral = literal.toLowerCase(Locale.ROOT);
        return this.expand(o -> this.literalInLocationPathChecker.test(o, lowerCaseLiteral));
    }

    @Override
    @NotNull
    public RegistryItemStream<T> filterByNamespace(@NotNull String namespace) {
        String lowerCaseNamespace = namespace.toLowerCase(Locale.ROOT);
        return this.expand(o -> this.namespaceEqualityChecker.test(o, lowerCaseNamespace));
    }

    @Override
    @NotNull
    public RegistryItemStream<T> filter(@NotNull @NotNull Predicate<@NotNull T> predicate) {
        return this.expand(o -> predicate.test((RegistryItem)this.converter.apply(o)));
    }

    @Override
    @NotNull
    public RegistryItemStream<T> is(@NotNull Object object) {
        return this.expand(o -> ((RegistryItem)this.converter.apply(o)).is(object));
    }

    @Override
    @NotNull
    public RegistryItemStream<T> is(Object ... objects) {
        return this.expand(o -> ((RegistryItem)this.converter.apply(o)).is(objects));
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull T> collect() {
        return this.javaStream().collect(Collectors.toList());
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull ResourceLocation> collectLocations() {
        return this.javaStreamOfLocations().collect(Collectors.toList());
    }

    @NotNull
    private @NotNull Stream<@NotNull O> filter() {
        Stream<O> stream = this.streamSupplier.get();
        for (Predicate<O> filter : this.operations) {
            stream = stream.filter(filter);
        }
        return stream;
    }

    @Override
    @NotNull
    public @NotNull Stream<@NotNull T> javaStream() {
        return this.filter().map(this.converter);
    }

    @Override
    @NotNull
    public @NotNull Stream<@NotNull ResourceLocation> javaStreamOfLocations() {
        return this.filter().map(this.locationSupplier);
    }

    @NotNull
    private RegistryItemStream<T> expand(@NotNull Predicate<O> operation) {
        ArrayList<Predicate<O>> newOperations = new ArrayList<Predicate<O>>(this.operations);
        newOperations.add(operation);
        return new SimpleRegistryItemStream<O, T>(this.streamSupplier, this.converter, this.locationSupplier, this.literalInLocationPathChecker, this.namespaceEqualityChecker, newOperations);
    }
}

