/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.vanilla.packet;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.impl.nms.accessors.network.ProtocolInfo$DetailsAccessor;
import sba.sl.impl.nms.accessors.network.ProtocolInfoAccessor;
import sba.sl.impl.nms.accessors.network.codec.IdDispatchCodecAccessor;
import sba.sl.impl.nms.accessors.network.protocol.PacketFlowAccessor;
import sba.sl.impl.nms.accessors.network.protocol.PacketTypeAccessor;
import sba.sl.impl.nms.accessors.network.protocol.SimpleUnboundProtocolAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.GameProtocolsAccessor;
import sba.sl.p.AbstractPacket;
import sba.sl.p.ClientboundAddEntityPacket;
import sba.sl.p.ClientboundMoveEntityPacket;
import sba.sl.p.ClientboundPlayerInfoPacket;
import sba.sl.p.ClientboundRemoveEntitiesPacket;
import sba.sl.p.ClientboundRemoveMobEffectPacket;
import sba.sl.p.ClientboundRotateHeadPacket;
import sba.sl.p.ClientboundSetDisplayObjectivePacket;
import sba.sl.p.ClientboundSetEntityDataPacket;
import sba.sl.p.ClientboundSetEntityMotionPacket;
import sba.sl.p.ClientboundSetEquipmentPacket;
import sba.sl.p.ClientboundSetExperiencePacket;
import sba.sl.p.ClientboundSetObjectivePacket;
import sba.sl.p.ClientboundSetPlayerTeamPacket;
import sba.sl.p.ClientboundSetScorePacket;
import sba.sl.p.ClientboundTeleportEntityPacket;
import sba.sl.p.ClientboundUpdateMobEffectPacket;
import sba.sl.u.Preconditions;
import sba.sl.u.reflect.Reflect;

public final class PacketIdMapping1_20_5 {
    @NotNull
    private static final @NotNull Map<@NotNull Class<? extends AbstractPacket>, String> PACKET_RESOURCE_LOCATION = new ConcurrentHashMap<Class<? extends AbstractPacket>, String>();
    @NotNull
    private static final @NotNull Map<@NotNull Class<? extends AbstractPacket>, Integer> ID_CACHE = new ConcurrentHashMap<Class<? extends AbstractPacket>, Integer>();
    @Nullable
    private static Map<Object, Integer> map;

    public static Integer getPacketId(@NotNull Class<? extends AbstractPacket> packetClass) {
        Preconditions.checkNotNull(packetClass, "Cannot get packet id of null class!");
        Integer cachedId = ID_CACHE.get(packetClass);
        if (cachedId != null) {
            return cachedId;
        }
        String resourceLocation = PACKET_RESOURCE_LOCATION.get(packetClass);
        if (resourceLocation == null) {
            return null;
        }
        if (map == null) {
            Object protocolInfo;
            Object playProtocol;
            if (GameProtocolsAccessor.CONST_CLIENTBOUND_TEMPLATE_1.get() != null) {
                playProtocol = GameProtocolsAccessor.CONST_CLIENTBOUND_TEMPLATE_1.get();
                protocolInfo = Reflect.fastInvoke(playProtocol, SimpleUnboundProtocolAccessor.METHOD_BIND.get(), input -> null);
            } else {
                playProtocol = GameProtocolsAccessor.CONST_CLIENTBOUND_TEMPLATE.get();
                protocolInfo = Reflect.fastInvoke(playProtocol, ProtocolInfo$DetailsAccessor.METHOD_BIND.get(), input -> null);
            }
            Object codec = Reflect.fastInvoke(protocolInfo, ProtocolInfoAccessor.METHOD_CODEC.get());
            if (!IdDispatchCodecAccessor.TYPE.get().isInstance(codec)) {
                throw new UnsupportedOperationException("Unable to get Packet ID from object " + String.valueOf(codec));
            }
            map = Reflect.getFieldResulted(codec, IdDispatchCodecAccessor.FIELD_TO_ID.get()).as(Map.class);
        }
        Integer id = map.entrySet().stream().filter(entry -> Reflect.fastInvoke(entry.getKey(), PacketTypeAccessor.METHOD_FLOW.get()) == PacketFlowAccessor.CONST_CLIENTBOUND.get() && resourceLocation.equals(Reflect.fastInvoke(entry.getKey(), PacketTypeAccessor.METHOD_ID.get()).toString())).findFirst().map(Map.Entry::getValue).orElseThrow(() -> new UnsupportedOperationException("Unable to get Packet ID for PLAY packet " + resourceLocation));
        ID_CACHE.put(packetClass, id);
        return id;
    }

    @Generated
    private PacketIdMapping1_20_5() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        PACKET_RESOURCE_LOCATION.put(ClientboundAddEntityPacket.class, "minecraft:add_entity");
        PACKET_RESOURCE_LOCATION.put(ClientboundMoveEntityPacket.Rot.class, "minecraft:move_entity_rot");
        PACKET_RESOURCE_LOCATION.put(ClientboundMoveEntityPacket.Pos.class, "minecraft:move_entity_pos");
        PACKET_RESOURCE_LOCATION.put(ClientboundMoveEntityPacket.PosRot.class, "minecraft:move_entity_pos_rot");
        PACKET_RESOURCE_LOCATION.put(ClientboundPlayerInfoPacket.class, "minecraft:player_info_update");
        PACKET_RESOURCE_LOCATION.put(ClientboundPlayerInfoPacket.PlayerInfoRemovePacket1_19_3.class, "minecraft:player_info_remove");
        PACKET_RESOURCE_LOCATION.put(ClientboundRemoveEntitiesPacket.class, "minecraft:remove_entities");
        PACKET_RESOURCE_LOCATION.put(ClientboundRemoveMobEffectPacket.class, "minecraft:remove_mob_effect");
        PACKET_RESOURCE_LOCATION.put(ClientboundRotateHeadPacket.class, "minecraft:rotate_head");
        PACKET_RESOURCE_LOCATION.put(ClientboundSetDisplayObjectivePacket.class, "minecraft:set_display_objective");
        PACKET_RESOURCE_LOCATION.put(ClientboundSetEntityDataPacket.class, "minecraft:set_entity_data");
        PACKET_RESOURCE_LOCATION.put(ClientboundSetEntityMotionPacket.class, "minecraft:set_entity_motion");
        PACKET_RESOURCE_LOCATION.put(ClientboundSetEquipmentPacket.class, "minecraft:set_equipment");
        PACKET_RESOURCE_LOCATION.put(ClientboundSetExperiencePacket.class, "minecraft:set_experience");
        PACKET_RESOURCE_LOCATION.put(ClientboundSetObjectivePacket.class, "minecraft:set_objective");
        PACKET_RESOURCE_LOCATION.put(ClientboundSetPlayerTeamPacket.class, "minecraft:set_player_team");
        PACKET_RESOURCE_LOCATION.put(ClientboundSetScorePacket.class, "minecraft:set_score");
        PACKET_RESOURCE_LOCATION.put(ClientboundSetScorePacket.ClientboundResetScorePacket1_20_3.class, "minecraft:reset_score");
        PACKET_RESOURCE_LOCATION.put(ClientboundTeleportEntityPacket.class, Server.isVersion(1, 21, 2) ? "minecraft:entity_position_sync" : "minecraft:teleport_entity");
        PACKET_RESOURCE_LOCATION.put(ClientboundUpdateMobEffectPacket.class, "minecraft:update_mob_effect");
    }
}

