/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.nbt;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import sba.sl.nbt.ByteArrayTag;
import sba.sl.nbt.ByteTag;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.CompoundTagLike;
import sba.sl.nbt.DoubleTag;
import sba.sl.nbt.FloatTag;
import sba.sl.nbt.IntArrayTag;
import sba.sl.nbt.IntTag;
import sba.sl.nbt.ListTag;
import sba.sl.nbt.LongArrayTag;
import sba.sl.nbt.LongTag;
import sba.sl.nbt.ShortTag;
import sba.sl.nbt.StringTag;
import sba.sl.nbt.Tag;
import sba.sl.nbt.TreeInspectorKey;

public interface CompoundTagModifier {
    @NotNull
    public CompoundTag with(@NotNull Tag var1, String ... var2);

    @NotNull
    public <T extends Tag> CompoundTag with(@NotNull TreeInspectorKey<T> var1, @NotNull T var2);

    @NotNull
    default public CompoundTag with(boolean value, String ... tagKeys) {
        return this.with(value ? ByteTag.TRUE : ByteTag.FALSE, tagKeys);
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<ByteTag> key, boolean value) {
        return this.with(key, value ? ByteTag.TRUE : ByteTag.FALSE);
    }

    @NotNull
    default public CompoundTag with(byte @NotNull [] value, String ... tagKeys) {
        return this.with(new ByteArrayTag(value), tagKeys);
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<ByteArrayTag> key, byte @NotNull [] value) {
        return this.with(key, new ByteArrayTag(value));
    }

    @NotNull
    default public CompoundTag with(byte value, String ... tagKeys) {
        return this.with(new ByteTag(value), tagKeys);
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<ByteTag> key, byte value) {
        return this.with(key, new ByteTag(value));
    }

    @NotNull
    default public CompoundTag with(@NotNull @NotNull Map<@NotNull String, Tag> value, String ... tagKeys) {
        return this.with(new CompoundTag(value), tagKeys);
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<CompoundTag> key, @NotNull @NotNull Map<@NotNull String, Tag> value) {
        return this.with(key, new CompoundTag(value));
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<CompoundTag> key, @NotNull CompoundTagLike value) {
        return this.with(key, value.asCompoundTag());
    }

    @NotNull
    default public CompoundTag with(double value, String ... tagKeys) {
        return this.with(new DoubleTag(value), tagKeys);
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<DoubleTag> key, double value) {
        return this.with(key, new DoubleTag(value));
    }

    @NotNull
    default public CompoundTag with(float value, String ... tagKeys) {
        return this.with(new FloatTag(value), tagKeys);
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<FloatTag> key, float value) {
        return this.with(key, new FloatTag(value));
    }

    @NotNull
    default public CompoundTag with(int @NotNull [] value, String ... tagKeys) {
        return this.with(new IntArrayTag(value), tagKeys);
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<IntArrayTag> key, int @NotNull [] value) {
        return this.with(key, new IntArrayTag(value));
    }

    @NotNull
    default public CompoundTag with(int value, String ... tagKeys) {
        return this.with(new IntTag(value), tagKeys);
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<IntTag> key, int value) {
        return this.with(key, new IntTag(value));
    }

    @NotNull
    default public CompoundTag with(@NotNull @NotNull List<@NotNull Tag> value, String ... tagKeys) {
        return this.with(new ListTag(value), tagKeys);
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<ListTag> key, @NotNull @NotNull List<? extends @NotNull Tag> value) {
        return this.with(key, new ListTag(value));
    }

    @NotNull
    default public CompoundTag with(long @NotNull [] value, String ... tagKeys) {
        return this.with(new LongArrayTag(value), tagKeys);
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<LongArrayTag> key, long @NotNull [] value) {
        return this.with(key, new LongArrayTag(value));
    }

    @NotNull
    default public CompoundTag with(long value, String ... tagKeys) {
        return this.with(new LongTag(value), tagKeys);
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<LongTag> key, long value) {
        return this.with(key, new LongTag(value));
    }

    @NotNull
    default public CompoundTag with(short value, String ... tagKeys) {
        return this.with(new ShortTag(value), tagKeys);
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<ShortTag> key, short value) {
        return this.with(key, new ShortTag(value));
    }

    @NotNull
    default public CompoundTag withStringTag(@NotNull String value, String ... tagKeys) {
        return this.with(new StringTag(value), tagKeys);
    }

    @NotNull
    default public CompoundTag with(@NotNull TreeInspectorKey<StringTag> key, @NotNull String value) {
        return this.with(key, new StringTag(value));
    }

    @NotNull
    public CompoundTag without(String ... var1);

    @NotNull
    public <T extends Tag> CompoundTag without(@NotNull TreeInspectorKey<T> var1);
}

