/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.i.ItemStack;
import sba.sl.p.AbstractPacket;
import sba.sl.p.PacketWriter;
import sba.sl.sl.EquipmentSlot;

public class ClientboundSetEquipmentPacket
extends AbstractPacket {
    private final int entityId;
    @NotNull
    private final @NotNull Map<@NotNull EquipmentSlot, ItemStack> slots;

    @Override
    public void write(@NotNull PacketWriter writer) {
        writer.writeVarInt(this.entityId);
        Iterator<Map.Entry<EquipmentSlot, ItemStack>> iterator = this.slots.entrySet().iterator();
        boolean hasNext = iterator.hasNext();
        boolean first = false;
        while (hasNext) {
            Map.Entry<EquipmentSlot, ItemStack> next = iterator.next();
            hasNext = iterator.hasNext();
            if (writer.protocol() >= 732) {
                if (hasNext) {
                    writer.writeByte((byte)(writer.getEquipmentSlotId(next.getKey()) | 0x80));
                } else {
                    writer.writeByte((byte)writer.getEquipmentSlotId(next.getKey()));
                }
                writer.writeItem(next.getValue());
                continue;
            }
            if (!first) {
                if (writer.protocol() >= 49) {
                    writer.writeVarInt(writer.getEquipmentSlotId(next.getKey()));
                } else {
                    writer.writeShort(writer.getEquipmentSlotId(next.getKey()));
                }
                writer.writeItem(next.getValue());
                first = true;
                continue;
            }
            writer.append(ClientboundSetEquipmentPacket.builder().entityId(this.entityId).slots(Map.of(next.getKey(), next.getValue())).build());
        }
    }

    @Generated
    private static Map<@NotNull EquipmentSlot, ItemStack> $default$slots() {
        return Map.of();
    }

    @Generated
    ClientboundSetEquipmentPacket(int entityId, @NotNull @NotNull Map<@NotNull EquipmentSlot, ItemStack> slots) {
        if (slots == null) {
            throw new NullPointerException("slots is marked non-null but is null");
        }
        this.entityId = entityId;
        this.slots = slots;
    }

    @Generated
    public static ClientboundSetEquipmentPacketBuilder builder() {
        return new ClientboundSetEquipmentPacketBuilder();
    }

    @Generated
    public ClientboundSetEquipmentPacketBuilder toBuilder() {
        return new ClientboundSetEquipmentPacketBuilder().entityId(this.entityId).slots(this.slots);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetEquipmentPacket)) {
            return false;
        }
        ClientboundSetEquipmentPacket other = (ClientboundSetEquipmentPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        Map<EquipmentSlot, ItemStack> this$slots = this.slots();
        Map<EquipmentSlot, ItemStack> other$slots = other.slots();
        return !(this$slots == null ? other$slots != null : !((Object)this$slots).equals(other$slots));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetEquipmentPacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        Map<EquipmentSlot, ItemStack> $slots = this.slots();
        result = result * 59 + ($slots == null ? 43 : ((Object)$slots).hashCode());
        return result;
    }

    @Generated
    public int entityId() {
        return this.entityId;
    }

    @NotNull
    @Generated
    public @NotNull Map<@NotNull EquipmentSlot, ItemStack> slots() {
        return this.slots;
    }

    @Generated
    public String toString() {
        return "ClientboundSetEquipmentPacket(entityId=" + this.entityId() + ", slots=" + String.valueOf(this.slots()) + ")";
    }

    @Generated
    public static class ClientboundSetEquipmentPacketBuilder {
        @Generated
        private int entityId;
        @Generated
        private boolean slots$set;
        @Generated
        private Map<@NotNull EquipmentSlot, ItemStack> slots$value;

        @Generated
        ClientboundSetEquipmentPacketBuilder() {
        }

        @Generated
        public ClientboundSetEquipmentPacketBuilder entityId(int entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public ClientboundSetEquipmentPacketBuilder slots(@NotNull @NotNull Map<@NotNull EquipmentSlot, ItemStack> slots) {
            if (slots == null) {
                throw new NullPointerException("slots is marked non-null but is null");
            }
            this.slots$value = slots;
            this.slots$set = true;
            return this;
        }

        @Generated
        public ClientboundSetEquipmentPacket build() {
            Map<@NotNull EquipmentSlot, ItemStack> slots$value = this.slots$value;
            if (!this.slots$set) {
                slots$value = ClientboundSetEquipmentPacket.$default$slots();
            }
            return new ClientboundSetEquipmentPacket(this.entityId, slots$value);
        }

        @Generated
        public String toString() {
            return "ClientboundSetEquipmentPacket.ClientboundSetEquipmentPacketBuilder(entityId=" + this.entityId + ", slots$value=" + String.valueOf(this.slots$value) + ")";
        }
    }
}

