/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import java.util.Locale;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.p.AbstractPacket;
import sba.sl.p.ClientboundSetScorePacket;
import sba.sl.p.PacketWriter;
import sba.sl.spectator.Component;
import sba.sl.u.Preconditions;
import sba.sl.u.annotations.ide.LimitedVersionSupport;

public class ClientboundSetObjectivePacket
extends AbstractPacket {
    @NotNull
    private final String objectiveKey;
    @Nullable
    private final Component title;
    @Nullable
    private final Type criteriaType;
    @NotNull
    private final Mode mode;
    @LimitedVersionSupport(value=">= 1.20.3")
    @Nullable
    private final ClientboundSetScorePacket.NumberFormat numberFormat;
    @LimitedVersionSupport(value=">= 1.20.3")
    @ApiStatus.Experimental
    @Nullable
    private final Component numberFormatComponent;

    @Override
    public void write(@NotNull PacketWriter writer) {
        writer.writeSizedString(this.objectiveKey);
        writer.writeByte((byte)this.mode.ordinal());
        if (this.mode == Mode.CREATE || this.mode == Mode.UPDATE) {
            Preconditions.checkNotNull(this.title);
            Preconditions.checkNotNull(this.criteriaType);
            if (writer.protocol() >= 390) {
                writer.writeComponent(this.title);
            } else {
                writer.writeSizedString(this.title.toLegacy());
            }
            if (writer.protocol() >= 349) {
                writer.writeVarInt(this.criteriaType.ordinal());
                if (writer.protocol() >= 765) {
                    writer.writeBoolean(this.numberFormat != null);
                    if (this.numberFormat != null) {
                        writer.writeVarInt(this.numberFormat.ordinal());
                        if (this.numberFormat == ClientboundSetScorePacket.NumberFormat.STYLED) {
                            writer.writeComponent(this.numberFormatComponent);
                        } else if (this.numberFormat == ClientboundSetScorePacket.NumberFormat.FIXED) {
                            writer.writeComponent(this.numberFormatComponent);
                        }
                    }
                }
            } else {
                writer.writeSizedString(this.criteriaType.name().toLowerCase(Locale.ROOT));
            }
        }
    }

    @Generated
    ClientboundSetObjectivePacket(@NotNull String objectiveKey, @Nullable Component title, @Nullable Type criteriaType, @NotNull Mode mode, @Nullable ClientboundSetScorePacket.NumberFormat numberFormat, @Nullable Component numberFormatComponent) {
        if (objectiveKey == null) {
            throw new NullPointerException("objectiveKey is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        this.objectiveKey = objectiveKey;
        this.title = title;
        this.criteriaType = criteriaType;
        this.mode = mode;
        this.numberFormat = numberFormat;
        this.numberFormatComponent = numberFormatComponent;
    }

    @Generated
    public static ClientboundSetObjectivePacketBuilder builder() {
        return new ClientboundSetObjectivePacketBuilder();
    }

    @Generated
    public ClientboundSetObjectivePacketBuilder toBuilder() {
        return new ClientboundSetObjectivePacketBuilder().objectiveKey(this.objectiveKey).title(this.title).criteriaType(this.criteriaType).mode(this.mode).numberFormat(this.numberFormat).numberFormatComponent(this.numberFormatComponent);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetObjectivePacket)) {
            return false;
        }
        ClientboundSetObjectivePacket other = (ClientboundSetObjectivePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$objectiveKey = this.objectiveKey();
        String other$objectiveKey = other.objectiveKey();
        if (this$objectiveKey == null ? other$objectiveKey != null : !this$objectiveKey.equals(other$objectiveKey)) {
            return false;
        }
        Component this$title = this.title();
        Component other$title = other.title();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Type this$criteriaType = this.criteriaType();
        Type other$criteriaType = other.criteriaType();
        if (this$criteriaType == null ? other$criteriaType != null : !((Object)((Object)this$criteriaType)).equals((Object)other$criteriaType)) {
            return false;
        }
        Mode this$mode = this.mode();
        Mode other$mode = other.mode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        ClientboundSetScorePacket.NumberFormat this$numberFormat = this.numberFormat();
        ClientboundSetScorePacket.NumberFormat other$numberFormat = other.numberFormat();
        if (this$numberFormat == null ? other$numberFormat != null : !((Object)((Object)this$numberFormat)).equals((Object)other$numberFormat)) {
            return false;
        }
        Component this$numberFormatComponent = this.numberFormatComponent();
        Component other$numberFormatComponent = other.numberFormatComponent();
        return !(this$numberFormatComponent == null ? other$numberFormatComponent != null : !this$numberFormatComponent.equals(other$numberFormatComponent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetObjectivePacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $objectiveKey = this.objectiveKey();
        result = result * 59 + ($objectiveKey == null ? 43 : $objectiveKey.hashCode());
        Component $title = this.title();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Type $criteriaType = this.criteriaType();
        result = result * 59 + ($criteriaType == null ? 43 : ((Object)((Object)$criteriaType)).hashCode());
        Mode $mode = this.mode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        ClientboundSetScorePacket.NumberFormat $numberFormat = this.numberFormat();
        result = result * 59 + ($numberFormat == null ? 43 : ((Object)((Object)$numberFormat)).hashCode());
        Component $numberFormatComponent = this.numberFormatComponent();
        result = result * 59 + ($numberFormatComponent == null ? 43 : $numberFormatComponent.hashCode());
        return result;
    }

    @NotNull
    @Generated
    public String objectiveKey() {
        return this.objectiveKey;
    }

    @Nullable
    @Generated
    public Component title() {
        return this.title;
    }

    @Nullable
    @Generated
    public Type criteriaType() {
        return this.criteriaType;
    }

    @NotNull
    @Generated
    public Mode mode() {
        return this.mode;
    }

    @Nullable
    @Generated
    public ClientboundSetScorePacket.NumberFormat numberFormat() {
        return this.numberFormat;
    }

    @Nullable
    @Generated
    public Component numberFormatComponent() {
        return this.numberFormatComponent;
    }

    @Generated
    public String toString() {
        return "ClientboundSetObjectivePacket(objectiveKey=" + this.objectiveKey() + ", title=" + String.valueOf(this.title()) + ", criteriaType=" + String.valueOf((Object)this.criteriaType()) + ", mode=" + String.valueOf((Object)this.mode()) + ", numberFormat=" + String.valueOf((Object)this.numberFormat()) + ", numberFormatComponent=" + String.valueOf(this.numberFormatComponent()) + ")";
    }

    public static enum Mode {
        CREATE,
        DESTROY,
        UPDATE;

    }

    public static enum Type {
        INTEGER,
        HEARTS;

    }

    @Generated
    public static class ClientboundSetObjectivePacketBuilder {
        @Generated
        private String objectiveKey;
        @Generated
        private Component title;
        @Generated
        private Type criteriaType;
        @Generated
        private Mode mode;
        @Generated
        private ClientboundSetScorePacket.NumberFormat numberFormat;
        @Generated
        private Component numberFormatComponent;

        @Generated
        ClientboundSetObjectivePacketBuilder() {
        }

        @Generated
        public ClientboundSetObjectivePacketBuilder objectiveKey(@NotNull String objectiveKey) {
            if (objectiveKey == null) {
                throw new NullPointerException("objectiveKey is marked non-null but is null");
            }
            this.objectiveKey = objectiveKey;
            return this;
        }

        @Generated
        public ClientboundSetObjectivePacketBuilder title(@Nullable Component title) {
            this.title = title;
            return this;
        }

        @Generated
        public ClientboundSetObjectivePacketBuilder criteriaType(@Nullable Type criteriaType) {
            this.criteriaType = criteriaType;
            return this;
        }

        @Generated
        public ClientboundSetObjectivePacketBuilder mode(@NotNull Mode mode) {
            if (mode == null) {
                throw new NullPointerException("mode is marked non-null but is null");
            }
            this.mode = mode;
            return this;
        }

        @Generated
        public ClientboundSetObjectivePacketBuilder numberFormat(@Nullable ClientboundSetScorePacket.NumberFormat numberFormat) {
            this.numberFormat = numberFormat;
            return this;
        }

        @Generated
        public ClientboundSetObjectivePacketBuilder numberFormatComponent(@Nullable Component numberFormatComponent) {
            this.numberFormatComponent = numberFormatComponent;
            return this;
        }

        @Generated
        public ClientboundSetObjectivePacket build() {
            return new ClientboundSetObjectivePacket(this.objectiveKey, this.title, this.criteriaType, this.mode, this.numberFormat, this.numberFormatComponent);
        }

        @Generated
        public String toString() {
            return "ClientboundSetObjectivePacket.ClientboundSetObjectivePacketBuilder(objectiveKey=" + this.objectiveKey + ", title=" + String.valueOf(this.title) + ", criteriaType=" + String.valueOf((Object)this.criteriaType) + ", mode=" + String.valueOf((Object)this.mode) + ", numberFormat=" + String.valueOf((Object)this.numberFormat) + ", numberFormatComponent=" + String.valueOf(this.numberFormatComponent) + ")";
        }
    }
}

