/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.p.AbstractPacket;
import sba.sl.p.PacketWriter;
import sba.sl.spectator.Component;
import sba.sl.u.annotations.ide.LimitedVersionSupport;

public class ClientboundSetScorePacket
extends AbstractPacket {
    @NotNull
    private final String entityName;
    @NotNull
    private final ScoreboardAction action;
    @NotNull
    private final String objectiveKey;
    private final int score;
    @LimitedVersionSupport(value=">= 1.20.3")
    @Nullable
    private final Component displayName;
    @LimitedVersionSupport(value=">= 1.20.3")
    @Nullable
    private final NumberFormat numberFormat;
    @LimitedVersionSupport(value=">= 1.20.3")
    @ApiStatus.Experimental
    @Nullable
    private final Component numberFormatComponent;

    @Override
    public void write(@NotNull PacketWriter writer) {
        if (writer.protocol() >= 765 && this.action == ScoreboardAction.REMOVE) {
            writer.setCancelled(true);
            writer.append(new ClientboundResetScorePacket1_20_3(this.entityName, this.objectiveKey));
            return;
        }
        writer.writeSizedString(this.entityName);
        if (writer.protocol() < 765) {
            writer.writeByte((byte)this.action.ordinal());
        }
        writer.writeSizedString(this.objectiveKey);
        if (this.action == ScoreboardAction.CHANGE) {
            writer.writeVarInt(this.score);
        }
        if (writer.protocol() >= 765) {
            writer.writeBoolean(this.displayName != null);
            if (this.displayName != null) {
                writer.writeComponent(this.displayName);
            }
            writer.writeBoolean(this.numberFormat != null);
            if (this.numberFormat != null) {
                writer.writeVarInt(this.numberFormat.ordinal());
                if (this.numberFormat == NumberFormat.STYLED) {
                    writer.writeComponent(this.numberFormatComponent);
                } else if (this.numberFormat == NumberFormat.FIXED) {
                    writer.writeComponent(this.numberFormatComponent);
                }
            }
        }
    }

    @Generated
    ClientboundSetScorePacket(@NotNull String entityName, @NotNull ScoreboardAction action, @NotNull String objectiveKey, int score, @Nullable Component displayName, @Nullable NumberFormat numberFormat, @Nullable Component numberFormatComponent) {
        if (entityName == null) {
            throw new NullPointerException("entityName is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (objectiveKey == null) {
            throw new NullPointerException("objectiveKey is marked non-null but is null");
        }
        this.entityName = entityName;
        this.action = action;
        this.objectiveKey = objectiveKey;
        this.score = score;
        this.displayName = displayName;
        this.numberFormat = numberFormat;
        this.numberFormatComponent = numberFormatComponent;
    }

    @Generated
    public static ClientboundSetScorePacketBuilder builder() {
        return new ClientboundSetScorePacketBuilder();
    }

    @Generated
    public ClientboundSetScorePacketBuilder toBuilder() {
        return new ClientboundSetScorePacketBuilder().entityName(this.entityName).action(this.action).objectiveKey(this.objectiveKey).score(this.score).displayName(this.displayName).numberFormat(this.numberFormat).numberFormatComponent(this.numberFormatComponent);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetScorePacket)) {
            return false;
        }
        ClientboundSetScorePacket other = (ClientboundSetScorePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.score() != other.score()) {
            return false;
        }
        String this$entityName = this.entityName();
        String other$entityName = other.entityName();
        if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
            return false;
        }
        ScoreboardAction this$action = this.action();
        ScoreboardAction other$action = other.action();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        String this$objectiveKey = this.objectiveKey();
        String other$objectiveKey = other.objectiveKey();
        if (this$objectiveKey == null ? other$objectiveKey != null : !this$objectiveKey.equals(other$objectiveKey)) {
            return false;
        }
        Component this$displayName = this.displayName();
        Component other$displayName = other.displayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        NumberFormat this$numberFormat = this.numberFormat();
        NumberFormat other$numberFormat = other.numberFormat();
        if (this$numberFormat == null ? other$numberFormat != null : !((Object)((Object)this$numberFormat)).equals((Object)other$numberFormat)) {
            return false;
        }
        Component this$numberFormatComponent = this.numberFormatComponent();
        Component other$numberFormatComponent = other.numberFormatComponent();
        return !(this$numberFormatComponent == null ? other$numberFormatComponent != null : !this$numberFormatComponent.equals(other$numberFormatComponent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetScorePacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.score();
        String $entityName = this.entityName();
        result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
        ScoreboardAction $action = this.action();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        String $objectiveKey = this.objectiveKey();
        result = result * 59 + ($objectiveKey == null ? 43 : $objectiveKey.hashCode());
        Component $displayName = this.displayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        NumberFormat $numberFormat = this.numberFormat();
        result = result * 59 + ($numberFormat == null ? 43 : ((Object)((Object)$numberFormat)).hashCode());
        Component $numberFormatComponent = this.numberFormatComponent();
        result = result * 59 + ($numberFormatComponent == null ? 43 : $numberFormatComponent.hashCode());
        return result;
    }

    @NotNull
    @Generated
    public String entityName() {
        return this.entityName;
    }

    @NotNull
    @Generated
    public ScoreboardAction action() {
        return this.action;
    }

    @NotNull
    @Generated
    public String objectiveKey() {
        return this.objectiveKey;
    }

    @Generated
    public int score() {
        return this.score;
    }

    @Nullable
    @Generated
    public Component displayName() {
        return this.displayName;
    }

    @Nullable
    @Generated
    public NumberFormat numberFormat() {
        return this.numberFormat;
    }

    @Nullable
    @Generated
    public Component numberFormatComponent() {
        return this.numberFormatComponent;
    }

    @Generated
    public String toString() {
        return "ClientboundSetScorePacket(entityName=" + this.entityName() + ", action=" + String.valueOf((Object)this.action()) + ", objectiveKey=" + this.objectiveKey() + ", score=" + this.score() + ", displayName=" + String.valueOf(this.displayName()) + ", numberFormat=" + String.valueOf((Object)this.numberFormat()) + ", numberFormatComponent=" + String.valueOf(this.numberFormatComponent()) + ")";
    }

    public static enum ScoreboardAction {
        CHANGE,
        REMOVE;

    }

    @ApiStatus.Internal
    @LimitedVersionSupport(value=">= 1.20.3")
    public static class ClientboundResetScorePacket1_20_3
    extends AbstractPacket {
        @NotNull
        private final String entityName;
        @NotNull
        private final String objectiveKey;

        @Override
        public void write(@NotNull PacketWriter writer) {
            writer.writeSizedString(this.entityName);
            writer.writeBoolean(true);
            writer.writeSizedString(this.objectiveKey);
        }

        @Generated
        public ClientboundResetScorePacket1_20_3(@NotNull String entityName, @NotNull String objectiveKey) {
            if (entityName == null) {
                throw new NullPointerException("entityName is marked non-null but is null");
            }
            if (objectiveKey == null) {
                throw new NullPointerException("objectiveKey is marked non-null but is null");
            }
            this.entityName = entityName;
            this.objectiveKey = objectiveKey;
        }
    }

    @LimitedVersionSupport(value=">= 1.20.3")
    public static enum NumberFormat {
        BLANK,
        STYLED,
        FIXED;

    }

    @Generated
    public static class ClientboundSetScorePacketBuilder {
        @Generated
        private String entityName;
        @Generated
        private ScoreboardAction action;
        @Generated
        private String objectiveKey;
        @Generated
        private int score;
        @Generated
        private Component displayName;
        @Generated
        private NumberFormat numberFormat;
        @Generated
        private Component numberFormatComponent;

        @Generated
        ClientboundSetScorePacketBuilder() {
        }

        @Generated
        public ClientboundSetScorePacketBuilder entityName(@NotNull String entityName) {
            if (entityName == null) {
                throw new NullPointerException("entityName is marked non-null but is null");
            }
            this.entityName = entityName;
            return this;
        }

        @Generated
        public ClientboundSetScorePacketBuilder action(@NotNull ScoreboardAction action) {
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.action = action;
            return this;
        }

        @Generated
        public ClientboundSetScorePacketBuilder objectiveKey(@NotNull String objectiveKey) {
            if (objectiveKey == null) {
                throw new NullPointerException("objectiveKey is marked non-null but is null");
            }
            this.objectiveKey = objectiveKey;
            return this;
        }

        @Generated
        public ClientboundSetScorePacketBuilder score(int score) {
            this.score = score;
            return this;
        }

        @Generated
        public ClientboundSetScorePacketBuilder displayName(@Nullable Component displayName) {
            this.displayName = displayName;
            return this;
        }

        @Generated
        public ClientboundSetScorePacketBuilder numberFormat(@Nullable NumberFormat numberFormat) {
            this.numberFormat = numberFormat;
            return this;
        }

        @Generated
        public ClientboundSetScorePacketBuilder numberFormatComponent(@Nullable Component numberFormatComponent) {
            this.numberFormatComponent = numberFormatComponent;
            return this;
        }

        @Generated
        public ClientboundSetScorePacket build() {
            return new ClientboundSetScorePacket(this.entityName, this.action, this.objectiveKey, this.score, this.displayName, this.numberFormat, this.numberFormatComponent);
        }

        @Generated
        public String toString() {
            return "ClientboundSetScorePacket.ClientboundSetScorePacketBuilder(entityName=" + this.entityName + ", action=" + String.valueOf((Object)this.action) + ", objectiveKey=" + this.objectiveKey + ", score=" + this.score + ", displayName=" + String.valueOf(this.displayName) + ", numberFormat=" + String.valueOf((Object)this.numberFormat) + ", numberFormatComponent=" + String.valueOf(this.numberFormatComponent) + ")";
        }
    }
}

