/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.p.AbstractPacket;
import sba.sl.p.PacketWriter;

public class ClientboundUpdateMobEffectPacket
extends AbstractPacket {
    private final int entityId;
    private final byte effect;
    private final byte amplifier;
    private final int duration;
    private final boolean ambient;
    private final boolean showParticles;
    private final boolean showIcons;

    @Override
    public void write(@NotNull PacketWriter writer) {
        writer.writeVarInt(this.entityId);
        writer.writeByte(this.effect);
        writer.writeByte(this.amplifier);
        writer.writeVarInt(this.duration);
        if (writer.protocol() >= 210) {
            byte flags = 0;
            if (this.ambient) {
                flags = (byte)(flags | 1);
            }
            if (this.showParticles) {
                flags = (byte)(flags | 2);
            }
            if (this.showIcons) {
                flags = (byte)(flags | 4);
            }
            writer.writeByte(flags);
        } else {
            writer.writeBoolean(!this.showParticles);
        }
    }

    @Generated
    ClientboundUpdateMobEffectPacket(int entityId, byte effect, byte amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcons) {
        this.entityId = entityId;
        this.effect = effect;
        this.amplifier = amplifier;
        this.duration = duration;
        this.ambient = ambient;
        this.showParticles = showParticles;
        this.showIcons = showIcons;
    }

    @Generated
    public static ClientboundUpdateMobEffectPacketBuilder builder() {
        return new ClientboundUpdateMobEffectPacketBuilder();
    }

    @Generated
    public ClientboundUpdateMobEffectPacketBuilder toBuilder() {
        return new ClientboundUpdateMobEffectPacketBuilder().entityId(this.entityId).effect(this.effect).amplifier(this.amplifier).duration(this.duration).ambient(this.ambient).showParticles(this.showParticles).showIcons(this.showIcons);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateMobEffectPacket)) {
            return false;
        }
        ClientboundUpdateMobEffectPacket other = (ClientboundUpdateMobEffectPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        if (this.effect() != other.effect()) {
            return false;
        }
        if (this.amplifier() != other.amplifier()) {
            return false;
        }
        if (this.duration() != other.duration()) {
            return false;
        }
        if (this.ambient() != other.ambient()) {
            return false;
        }
        if (this.showParticles() != other.showParticles()) {
            return false;
        }
        return this.showIcons() == other.showIcons();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientboundUpdateMobEffectPacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        result = result * 59 + this.effect();
        result = result * 59 + this.amplifier();
        result = result * 59 + this.duration();
        result = result * 59 + (this.ambient() ? 79 : 97);
        result = result * 59 + (this.showParticles() ? 79 : 97);
        result = result * 59 + (this.showIcons() ? 79 : 97);
        return result;
    }

    @Generated
    public int entityId() {
        return this.entityId;
    }

    @Generated
    public byte effect() {
        return this.effect;
    }

    @Generated
    public byte amplifier() {
        return this.amplifier;
    }

    @Generated
    public int duration() {
        return this.duration;
    }

    @Generated
    public boolean ambient() {
        return this.ambient;
    }

    @Generated
    public boolean showParticles() {
        return this.showParticles;
    }

    @Generated
    public boolean showIcons() {
        return this.showIcons;
    }

    @Generated
    public String toString() {
        return "ClientboundUpdateMobEffectPacket(entityId=" + this.entityId() + ", effect=" + this.effect() + ", amplifier=" + this.amplifier() + ", duration=" + this.duration() + ", ambient=" + this.ambient() + ", showParticles=" + this.showParticles() + ", showIcons=" + this.showIcons() + ")";
    }

    @Generated
    public static class ClientboundUpdateMobEffectPacketBuilder {
        @Generated
        private int entityId;
        @Generated
        private byte effect;
        @Generated
        private byte amplifier;
        @Generated
        private int duration;
        @Generated
        private boolean ambient;
        @Generated
        private boolean showParticles;
        @Generated
        private boolean showIcons;

        @Generated
        ClientboundUpdateMobEffectPacketBuilder() {
        }

        @Generated
        public ClientboundUpdateMobEffectPacketBuilder entityId(int entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public ClientboundUpdateMobEffectPacketBuilder effect(byte effect) {
            this.effect = effect;
            return this;
        }

        @Generated
        public ClientboundUpdateMobEffectPacketBuilder amplifier(byte amplifier) {
            this.amplifier = amplifier;
            return this;
        }

        @Generated
        public ClientboundUpdateMobEffectPacketBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        @Generated
        public ClientboundUpdateMobEffectPacketBuilder ambient(boolean ambient) {
            this.ambient = ambient;
            return this;
        }

        @Generated
        public ClientboundUpdateMobEffectPacketBuilder showParticles(boolean showParticles) {
            this.showParticles = showParticles;
            return this;
        }

        @Generated
        public ClientboundUpdateMobEffectPacketBuilder showIcons(boolean showIcons) {
            this.showIcons = showIcons;
            return this;
        }

        @Generated
        public ClientboundUpdateMobEffectPacket build() {
            return new ClientboundUpdateMobEffectPacket(this.entityId, this.effect, this.amplifier, this.duration, this.ambient, this.showParticles, this.showIcons);
        }

        @Generated
        public String toString() {
            return "ClientboundUpdateMobEffectPacket.ClientboundUpdateMobEffectPacketBuilder(entityId=" + this.entityId + ", effect=" + this.effect + ", amplifier=" + this.amplifier + ", duration=" + this.duration + ", ambient=" + this.ambient + ", showParticles=" + this.showParticles + ", showIcons=" + this.showIcons + ")";
        }
    }
}

