/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.p.AbstractPacket;
import sba.sl.p.ProtocolInjector;
import sba.sl.pa.Player;
import sba.sl.u.annotations.AbstractService;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.ide.LimitedVersionSupport;

@AbstractService(value="sba.sl.impl.{platform}.packet.{Platform}PacketMapper")
@ServiceDependencies(dependsOn={ProtocolInjector.class})
public abstract class PacketMapper {
    @Nullable
    private static PacketMapper packetMapper;

    public PacketMapper() {
        if (packetMapper != null) {
            throw new UnsupportedOperationException("PacketMapper is already initialized.");
        }
        packetMapper = this;
    }

    public static boolean isInitialized() {
        return packetMapper != null;
    }

    public static void sendPacket(@NotNull Player player, @NotNull AbstractPacket packet) {
        if (packetMapper == null) {
            throw new UnsupportedOperationException("PacketMapper isn't initialized yet.");
        }
        packetMapper.sendPacket0(player, packet);
    }

    public abstract void sendPacket0(@NotNull Player var1, @NotNull AbstractPacket var2);

    public static void sendPacket(@NotNull @NotNull Collection<@NotNull Player> players, @NotNull AbstractPacket packet) {
        if (packetMapper == null) {
            throw new UnsupportedOperationException("PacketMapper isn't initialized yet.");
        }
        players.forEach(player -> packetMapper.sendPacket0((Player)player, packet));
    }

    public static int getId(@NotNull Class<? extends AbstractPacket> clazz) {
        if (packetMapper == null) {
            throw new UnsupportedOperationException("PacketMapper isn't initialized yet.");
        }
        return packetMapper.getId0(clazz);
    }

    public static int getArmorStandTypeId() {
        if (packetMapper == null) {
            throw new UnsupportedOperationException("PacketMapper isn't initialized yet.");
        }
        return packetMapper.getArmorStandTypeId0();
    }

    @LimitedVersionSupport(value=">= 1.19.4")
    public static int getTextDisplayTypeId() {
        if (packetMapper == null) {
            throw new UnsupportedOperationException("PacketMapper isn't initialized yet.");
        }
        return packetMapper.getTextDisplayTypeId0();
    }

    @LimitedVersionSupport(value=">= 1.20.2")
    public static int getPlayerTypeId() {
        if (packetMapper == null) {
            throw new UnsupportedOperationException("PacketMapper isn't initialized yet.");
        }
        return packetMapper.getPlayerTypeId0();
    }

    public abstract int getId0(@NotNull Class<? extends AbstractPacket> var1);

    public abstract int getArmorStandTypeId0();

    public abstract int getTextDisplayTypeId0();

    public abstract int getPlayerTypeId0();
}

