/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.e.Entities;
import sba.sl.p.AbstractPacket;
import sba.sl.p.ClientboundAddMobPacket;
import sba.sl.p.ClientboundSetEntityDataPacket;
import sba.sl.p.ClientboundTeleportEntityPacket;
import sba.sl.p.MetadataItem;
import sba.sl.pa.Player;
import sba.sl.spectator.AudienceComponentLike;
import sba.sl.spectator.Component;
import sba.sl.u.math.Vector3D;
import sba.sl.w.Location;

public class FakeEntity {
    private final int id;
    @NotNull
    private Location location;
    private final int typeId;
    @NotNull
    private final UUID uuid;
    @NotNull
    private final @NotNull List<@NotNull MetadataItem> metadataItems;
    private byte entityFlags;
    @NotNull
    private Component customName;
    @Nullable
    private AudienceComponentLike customNameSenderMessage;
    private boolean isOnGround;

    public FakeEntity(@NotNull Location location, int typeId) {
        if (!Server.isServerThread()) {
            try {
                this.id = Entities.getNewEntityIdSynchronously().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.id = Entities.getNewEntityId();
        }
        this.typeId = typeId;
        this.location = location;
        this.uuid = UUID.randomUUID();
        this.metadataItems = Collections.synchronizedList(new ArrayList());
        this.entityFlags = 0;
        this.customName = Component.empty();
        this.isOnGround = true;
        this.setEntityFlags();
    }

    public void setCustomName(@NotNull Component name) {
        if (Server.isVersion(1, 13)) {
            this.put(MetadataItem.ofOpt(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME), name));
        } else {
            String str = name.toLegacy();
            if (str.length() > 256) {
                str = str.substring(0, 256);
            }
            this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME), str));
        }
        this.customName = name;
    }

    public void put(@NotNull MetadataItem metadataItem) {
        this.metadataItems.removeIf(metadataItem1 -> metadataItem1.getIndex() == metadataItem.getIndex());
        this.metadataItems.add(metadataItem);
    }

    public void setEntityFlags() {
        this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.ENTITY_FLAGS), this.entityFlags));
    }

    public void setAirTicks(int airTicks) {
        if (Server.isVersion(1, 9)) {
            this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.AIR_TICKS), airTicks));
        } else {
            this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.AIR_TICKS), (short)airTicks));
        }
    }

    public void setCustomNameVisible(boolean customNameVisible) {
        this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME_VISIBLE), customNameVisible));
    }

    public void setSilent(boolean silent) {
        this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.IS_SILENT), silent));
    }

    public void setGravity(boolean gravity) {
        if (Server.isVersion(1, 10)) {
            this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.HAS_NO_GRAVITY), !gravity));
        }
    }

    public void setPose(int poseOrdinal) {
        if (Server.isVersion(1, 14)) {
            this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.POSE), poseOrdinal));
        }
    }

    public void setTicksFrozen(int ticksFrozen) {
        if (Server.isVersion(1, 17)) {
            MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.TICKS_FROZEN), ticksFrozen);
        }
    }

    public void setInvisible(boolean invisible) {
        this.setEntityFlagsFromValue(5, invisible);
        this.put(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.ENTITY_FLAGS), this.entityFlags));
    }

    public void setEntityFlagsFromValue(int index, boolean value) {
        this.entityFlags = value ? (byte)(this.entityFlags | 1 << index) : (byte)(this.entityFlags & ~(1 << index));
    }

    public void spawn(@NotNull Player player) {
        this.getSpawnPackets().forEach(packet -> packet.sendPacket(player));
    }

    public void teleport(@NotNull Player player) {
        this.getTeleportPacket().sendPacket(player);
    }

    @NotNull
    public @NotNull List<@NotNull AbstractPacket> getSpawnPackets() {
        return this.getSpawnPackets(List.of());
    }

    @NotNull
    public @NotNull List<@NotNull AbstractPacket> getSpawnPackets(@NotNull Player viewer) {
        if (this.customNameSenderMessage != null) {
            if (Server.isVersion(1, 13)) {
                return this.getSpawnPackets(List.of(MetadataItem.ofOpt(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME), this.customNameSenderMessage.asComponent(viewer))));
            }
            String str = this.customNameSenderMessage.asComponent(viewer).toLegacy();
            if (str.length() > 256) {
                str = str.substring(0, 256);
            }
            return this.getSpawnPackets(List.of(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME), str)));
        }
        return this.getSpawnPackets(List.of());
    }

    @NotNull
    public @NotNull List<@NotNull AbstractPacket> getSpawnPackets(@NotNull @NotNull List<@NotNull MetadataItem> additionalMetadata) {
        LinkedList<AbstractPacket> toReturn = new LinkedList<AbstractPacket>();
        ClientboundAddMobPacket spawnPacket = ClientboundAddMobPacket.builder().entityId(this.id).uuid(this.uuid).typeId(this.typeId).velocity(new Vector3D(0.0, 0.0, 0.0)).headYaw((byte)3).location(this.location).metadata(this.metadataItems).build();
        additionalMetadata.forEach(metadataItem -> {
            spawnPacket.metadata().removeIf(metadataItem1 -> metadataItem1.getIndex() == metadataItem.getIndex());
            spawnPacket.metadata().add((MetadataItem)metadataItem);
        });
        toReturn.add(spawnPacket);
        return toReturn;
    }

    @NotNull
    public ClientboundTeleportEntityPacket getTeleportPacket() {
        return ClientboundTeleportEntityPacket.builder().entityId(this.id).location(this.location).onGround(this.isOnGround).build();
    }

    @NotNull
    public ClientboundSetEntityDataPacket getMetadataPacket() {
        return this.getMetadataPacket(List.of());
    }

    @NotNull
    public ClientboundSetEntityDataPacket getMetadataPacket(@NotNull Player viewer) {
        if (this.customNameSenderMessage != null) {
            if (Server.isVersion(1, 13)) {
                return this.getMetadataPacket(List.of(MetadataItem.ofOpt(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME), this.customNameSenderMessage.asComponent(viewer))));
            }
            String str = this.customNameSenderMessage.asComponent(viewer).toLegacy();
            if (str.length() > 256) {
                str = str.substring(0, 256);
            }
            return this.getMetadataPacket(List.of(MetadataItem.of(EntityMetadata.Registry.getId(EntityMetadata.CUSTOM_NAME), str)));
        }
        return this.getMetadataPacket(List.of());
    }

    @NotNull
    public ClientboundSetEntityDataPacket getMetadataPacket(@NotNull @NotNull List<@NotNull MetadataItem> additionalMetadata) {
        ArrayList<MetadataItem> newMetadataItems = new ArrayList<MetadataItem>(this.metadataItems);
        additionalMetadata.forEach(metadataItem -> {
            newMetadataItems.removeIf(metadataItem1 -> metadataItem1.getIndex() == metadataItem.getIndex());
            newMetadataItems.add((MetadataItem)metadataItem);
        });
        return ClientboundSetEntityDataPacket.builder().entityId(this.id).metadata(newMetadataItems).build();
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @NotNull
    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public int getTypeId() {
        return this.typeId;
    }

    @NotNull
    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull MetadataItem> getMetadataItems() {
        return this.metadataItems;
    }

    @Generated
    public byte getEntityFlags() {
        return this.entityFlags;
    }

    @NotNull
    @Generated
    public Component getCustomName() {
        return this.customName;
    }

    @Generated
    public boolean isOnGround() {
        return this.isOnGround;
    }

    @Generated
    public void setLocation(@NotNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.location = location;
    }

    @Nullable
    @Generated
    public AudienceComponentLike getCustomNameSenderMessage() {
        return this.customNameSenderMessage;
    }

    @Generated
    public void setCustomNameSenderMessage(@Nullable AudienceComponentLike customNameSenderMessage) {
        this.customNameSenderMessage = customNameSenderMessage;
    }

    @Generated
    public void setOnGround(boolean isOnGround) {
        this.isOnGround = isOnGround;
    }

    protected static enum EntityMetadata {
        ENTITY_FLAGS,
        AIR_TICKS,
        CUSTOM_NAME,
        CUSTOM_NAME_VISIBLE,
        IS_SILENT,
        HAS_NO_GRAVITY,
        POSE,
        TICKS_FROZEN,
        HAND_STATES,
        HEALTH,
        POTION_EFFECT_COLOR,
        POTION_AMBIENCY,
        BODY_ARROW_COUNT,
        BEE_STINGER_COUNT,
        BED_BLOCK_POSITION,
        ARMOR_STAND_FLAGS,
        HEAD_ROTATION,
        BODY_ROTATION,
        LEFT_ARM_ROTATION,
        RIGHT_ARM_ROTATION,
        LEFT_LEG_ROTATION,
        RIGHT_LEG_ROTATION;


        @Generated
        private EntityMetadata() {
        }

        public static final class Registry {
            @NotNull
            private static final @NotNull Map<@NotNull EntityMetadata, Byte> idMap = new HashMap<EntityMetadata, Byte>();
            private static byte SEQUENTIAL_INDEXING = (byte)-1;

            public static Optional<EntityMetadata> fromId(byte id) {
                for (Map.Entry<EntityMetadata, Byte> entry : idMap.entrySet()) {
                    EntityMetadata entryKey = entry.getKey();
                    Byte entryId = entry.getValue();
                    if (entryId != id) continue;
                    return Optional.of(entryKey);
                }
                return Optional.empty();
            }

            public static byte getId(@NotNull EntityMetadata metadata) {
                return Objects.requireNonNull(idMap.get((Object)metadata), "Has: " + metadata.name() + " not been registered into registry?");
            }

            public static void register(@NotNull EntityMetadata indices) {
                if (idMap.containsKey((Object)indices)) {
                    return;
                }
                SEQUENTIAL_INDEXING = (byte)(SEQUENTIAL_INDEXING + 1);
                idMap.put(indices, SEQUENTIAL_INDEXING);
            }

            @Generated
            private Registry() {
                throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
            }

            static {
                Registry.register(ENTITY_FLAGS);
                Registry.register(AIR_TICKS);
                Registry.register(CUSTOM_NAME);
                Registry.register(CUSTOM_NAME_VISIBLE);
                Registry.register(IS_SILENT);
                if (Server.isVersion(1, 10)) {
                    Registry.register(HAS_NO_GRAVITY);
                }
                if (Server.isVersion(1, 14)) {
                    Registry.register(POSE);
                }
                if (Server.isVersion(1, 17)) {
                    Registry.register(TICKS_FROZEN);
                }
                if (Server.isVersion(1, 9)) {
                    Registry.register(HAND_STATES);
                } else {
                    SEQUENTIAL_INDEXING = (byte)(SEQUENTIAL_INDEXING + 1);
                }
                Registry.register(HEALTH);
                Registry.register(POTION_EFFECT_COLOR);
                Registry.register(POTION_AMBIENCY);
                Registry.register(BODY_ARROW_COUNT);
                if (Server.isVersion(1, 15)) {
                    Registry.register(BEE_STINGER_COUNT);
                }
                if (Server.isVersion(1, 14)) {
                    Registry.register(BED_BLOCK_POSITION);
                }
                Registry.register(ARMOR_STAND_FLAGS);
                Registry.register(HEAD_ROTATION);
                Registry.register(BODY_ROTATION);
                Registry.register(LEFT_ARM_ROTATION);
                Registry.register(RIGHT_ARM_ROTATION);
                Registry.register(LEFT_LEG_ROTATION);
                Registry.register(RIGHT_LEG_ROTATION);
            }
        }
    }
}

