/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p.entity;

import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.p.ClientboundSetEntityDataPacket;
import sba.sl.p.MetadataItem;
import sba.sl.p.entity.FakeDisplayEntity;
import sba.sl.pa.Player;
import sba.sl.spectator.AudienceComponentLike;
import sba.sl.spectator.Component;
import sba.sl.w.Location;

public class FakeTextDisplayEntity
extends FakeDisplayEntity {
    private static byte textMetadata;
    @Nullable
    private Component text;
    @Nullable
    private AudienceComponentLike textSenderMessage;

    public FakeTextDisplayEntity(@NotNull Location location, int typeId) {
        super(location, typeId);
        if (textMetadata == 0) {
            textMetadata = Server.isVersion(1, 20, 2) ? (byte)23 : (byte)22;
        }
    }

    public void setText(@NotNull Component component) {
        this.text = component;
        this.put(MetadataItem.of(textMetadata, component));
    }

    @Override
    @NotNull
    public ClientboundSetEntityDataPacket getMetadataPacket(@NotNull Player viewer) {
        if (this.textSenderMessage != null) {
            return this.getMetadataPacket(List.of(MetadataItem.of(textMetadata, this.textSenderMessage.asComponent(viewer))));
        }
        return this.getMetadataPacket(List.of());
    }

    @Nullable
    @Generated
    public Component getText() {
        return this.text;
    }

    @Nullable
    @Generated
    public AudienceComponentLike getTextSenderMessage() {
        return this.textSenderMessage;
    }

    @Generated
    public void setTextSenderMessage(@Nullable AudienceComponentLike textSenderMessage) {
        this.textSenderMessage = textSenderMessage;
    }
}

