/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.pa;

import io.netty.channel.Channel;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.types.CommandSenderHolder;
import sba.sl.api.types.OfflinePlayerHolder;
import sba.sl.api.types.PlayerHolder;
import sba.sl.pa.OfflinePlayer;
import sba.sl.pa.Player;
import sba.sl.s.CommandSender;
import sba.sl.s.permissions.Permission;
import sba.sl.u.BidirectionalConverter;
import sba.sl.u.annotations.ProvidedService;

@ProvidedService
public abstract class Players {
    @NotNull
    protected final BidirectionalConverter<OfflinePlayer> offlinePlayerConverter = BidirectionalConverter.build();
    @NotNull
    protected final BidirectionalConverter<Player> specialPlayerConverter = BidirectionalConverter.build();
    @Nullable
    private static Players players;

    @ApiStatus.Internal
    public Players() {
        if (players != null) {
            throw new UnsupportedOperationException("Players is already initialized.");
        }
        players = this;
    }

    @NotNull
    public static <T> Player wrapPlayer(@NotNull T player) {
        if (players == null) {
            throw new UnsupportedOperationException("Players isn't initialized yet.");
        }
        try {
            CommandSender sender = players.wrapSender0(player);
            if (sender instanceof Player) {
                return (Player)sender;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return Players.players.specialPlayerConverter.convert(player);
    }

    public static <T> OfflinePlayer wrapOfflinePlayer(@NotNull T player) {
        if (players == null) {
            throw new UnsupportedOperationException("Players isn't initialized yet.");
        }
        return Players.players.offlinePlayerConverter.convert(player);
    }

    @NotNull
    public static <T> CommandSender wrapSender(@NotNull T sender) {
        if (players == null) {
            throw new UnsupportedOperationException("Players isn't initialized yet.");
        }
        return players.wrapSender0(sender);
    }

    public static <T> T convertOfflinePlayer(@NotNull OfflinePlayer player, @NotNull Class<T> type) {
        if (players == null) {
            throw new UnsupportedOperationException("Players isn't initialized yet.");
        }
        return Players.players.offlinePlayerConverter.convert(player, type);
    }

    @Contract(value="null -> null")
    @Nullable
    public static Player getPlayer(@Nullable String name) {
        if (players == null) {
            throw new UnsupportedOperationException("Players isn't initialized yet.");
        }
        if (name == null) {
            return null;
        }
        return players.getPlayer0(name);
    }

    @Nullable
    public abstract Player getPlayer0(@NotNull String var1);

    @Contract(value="null -> null")
    @Nullable
    public static Player getPlayer(@Nullable UUID uuid) {
        if (players == null) {
            throw new UnsupportedOperationException("Players isn't initialized yet.");
        }
        if (uuid == null) {
            return null;
        }
        return players.getPlayer0(uuid);
    }

    @Nullable
    public abstract Player getPlayer0(@NotNull UUID var1);

    @Contract(value="null -> null")
    @Nullable
    public static Player getPlayerExact(@Nullable String name) {
        if (players == null) {
            throw new UnsupportedOperationException("Players isn't initialized yet.");
        }
        if (name == null) {
            return null;
        }
        return players.getPlayerExact0(name);
    }

    public static boolean hasPermission(@NotNull CommandSender wrapper, @NotNull Permission permission) {
        if (players == null) {
            throw new UnsupportedOperationException("Players isn't initialized yet.");
        }
        return players.hasPermission0(wrapper, permission);
    }

    public static boolean isPermissionSet(@NotNull CommandSender wrapper, @NotNull Permission permission) {
        if (players == null) {
            throw new UnsupportedOperationException("Players isn't initialized yet.");
        }
        return players.isPermissionSet0(wrapper, permission);
    }

    @NotNull
    public static OfflinePlayer getOfflinePlayer(@NotNull UUID uuid) {
        if (players == null) {
            throw new UnsupportedOperationException("Players isn't initialized yet.");
        }
        return players.getOfflinePlayer0(uuid);
    }

    @Deprecated
    @Contract(value="null -> null")
    @Nullable
    public static OfflinePlayer getOfflinePlayer(@Nullable String name) {
        if (players == null) {
            throw new UnsupportedOperationException("Players isn't initialized yet.");
        }
        if (name == null) {
            return null;
        }
        return players.getOfflinePlayer0(name);
    }

    @NotNull
    public static BidirectionalConverter<Player> UNSAFE_getPlayerConverter() {
        if (players == null) {
            throw new UnsupportedOperationException("Players isn't initialized yet.");
        }
        return Players.players.specialPlayerConverter;
    }

    @Nullable
    public static Channel getNettyChannel(@NotNull Player player) {
        if (players == null) {
            throw new UnsupportedOperationException("Players isn't initialized yet.");
        }
        return players.getNettyChannel0(player);
    }

    @Nullable
    protected abstract Channel getNettyChannel0(@NotNull Player var1);

    @NotNull
    protected abstract <T> CommandSender wrapSender0(@NotNull T var1);

    public abstract boolean hasPermission0(@NotNull CommandSender var1, @NotNull Permission var2);

    public abstract boolean isPermissionSet0(@NotNull CommandSender var1, @NotNull Permission var2);

    @NotNull
    public abstract OfflinePlayer getOfflinePlayer0(@NotNull UUID var1);

    @Nullable
    public abstract OfflinePlayer getOfflinePlayer0(@NotNull String var1);

    @Nullable
    public abstract Player getPlayerExact0(@NotNull String var1);

    static {
        CommandSenderHolder.Provider.registerProvider(Players::wrapSender);
        PlayerHolder.Provider.registerProvider(Players::wrapPlayer);
        OfflinePlayerHolder.Provider.registerProvider(Players::wrapOfflinePlayer);
    }
}

