/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.pa.gamemode;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.player.gamemode.GameModeRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface GameMode
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    public int id();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.GAME_MODE) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static GameMode of(@MinecraftType(value=MinecraftType.Type.GAME_MODE) @NotNull Object gameMode) {
        GameMode result = GameMode.ofNullable(gameMode);
        Preconditions.checkNotNullIllegal(result, "Could not find game mode: " + String.valueOf(gameMode));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static GameMode ofNullable(@MinecraftType(value=MinecraftType.Type.GAME_MODE) @Nullable Object gameMode) {
        if (gameMode instanceof GameMode) {
            return (GameMode)gameMode;
        }
        return (GameMode)GameModeRegistry.getInstance().resolveMapping(gameMode);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull GameMode> all() {
        return GameModeRegistry.getInstance().getRegistryItemStream();
    }
}

