/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.si;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Core;
import sba.sl.p.PacketMapper;
import sba.sl.si.ScoreSidebar;
import sba.sl.si.ScoreSidebarImpl;
import sba.sl.si.Sidebar;
import sba.sl.si.SidebarImpl;
import sba.sl.si.TeamedSidebar;
import sba.sl.u.Controllable;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.vi.Visual;

@Service
@ServiceDependencies(dependsOn={Core.class, PacketMapper.class})
public class SidebarManager {
    @Nullable
    private static SidebarManager manager;
    @NotNull
    protected final @NotNull Map<@NotNull UUID, TeamedSidebar<?>> activeSidebars = new HashMap();

    @ApiStatus.Internal
    public SidebarManager(@NotNull Controllable controllable) {
        if (manager != null) {
            throw new UnsupportedOperationException("SidebarManager is already initialized!");
        }
        manager = this;
        controllable.disable(this::destroy);
    }

    @NotNull
    public static @NotNull Map<@NotNull UUID, @NotNull TeamedSidebar<?>> getActiveSidebars() {
        if (manager == null) {
            throw new UnsupportedOperationException("SidebarManager is not initialized yet!");
        }
        return Map.copyOf(SidebarManager.manager.activeSidebars);
    }

    @Contract(value="null -> null")
    @Nullable
    public static <T extends TeamedSidebar<T>> TeamedSidebar<T> getSidebar(@Nullable UUID uuid) {
        if (manager == null) {
            throw new UnsupportedOperationException("SidebarManager is not initialized yet!");
        }
        return SidebarManager.manager.activeSidebars.get(uuid);
    }

    public static void addSidebar(@NotNull TeamedSidebar<?> sidebar) {
        if (manager == null) {
            throw new UnsupportedOperationException("SidebarManager is not initialized yet!");
        }
        SidebarManager.manager.activeSidebars.put(sidebar.uuid(), sidebar);
    }

    public static void removeSidebar(@Nullable UUID uuid) {
        TeamedSidebar sidebar = SidebarManager.getSidebar(uuid);
        if (sidebar != null) {
            SidebarManager.removeSidebar(sidebar);
        }
    }

    public static void removeSidebar(@NotNull TeamedSidebar<?> scoreboard) {
        if (manager == null) {
            throw new UnsupportedOperationException("SidebarManager is not initialized yet!");
        }
        SidebarManager.manager.activeSidebars.remove(scoreboard.uuid());
    }

    @NotNull
    public static Sidebar sidebar() {
        return SidebarManager.sidebar(UUID.randomUUID());
    }

    @NotNull
    public static ScoreSidebar scoreboard() {
        return SidebarManager.scoreboard(UUID.randomUUID());
    }

    @NotNull
    public static Sidebar sidebar(@NotNull UUID uuid) {
        if (manager == null) {
            throw new UnsupportedOperationException("SidebarManager is not initialized yet!");
        }
        SidebarImpl scoreboard = new SidebarImpl(uuid);
        SidebarManager.addSidebar(scoreboard);
        return scoreboard;
    }

    @NotNull
    public static ScoreSidebar scoreboard(@NotNull UUID uuid) {
        if (manager == null) {
            throw new UnsupportedOperationException("SidebarManager is not initialized yet!");
        }
        ScoreSidebarImpl scoreboard = new ScoreSidebarImpl(uuid);
        SidebarManager.addSidebar(scoreboard);
        return scoreboard;
    }

    protected void destroy() {
        Map.copyOf(SidebarManager.getActiveSidebars()).values().forEach(Visual::destroy);
        this.activeSidebars.clear();
    }
}

