/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import sba.sl.api.Wrapper;
import sba.sl.api.types.ComponentHolder;
import sba.sl.impl.spectator.Spectator;
import sba.sl.spectator.BlockNBTComponent;
import sba.sl.spectator.Color;
import sba.sl.spectator.ComponentBuilderApplicable;
import sba.sl.spectator.ComponentLike;
import sba.sl.spectator.EntityNBTComponent;
import sba.sl.spectator.KeybindComponent;
import sba.sl.spectator.ScoreComponent;
import sba.sl.spectator.SelectorComponent;
import sba.sl.spectator.ShadowColor;
import sba.sl.spectator.StorageNBTComponent;
import sba.sl.spectator.TextComponent;
import sba.sl.spectator.TranslatableComponent;
import sba.sl.spectator.event.ClickEvent;
import sba.sl.spectator.event.HoverEvent;
import sba.sl.spectator.event.hover.Content;
import sba.sl.spectator.event.hover.EntityContent;
import sba.sl.spectator.event.hover.EntityContentLike;
import sba.sl.spectator.event.hover.ItemContent;
import sba.sl.spectator.event.hover.ItemContentLike;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.Placeholder;
import sba.sl.spectator.utils.ComponentUtils;
import sba.sl.spectator.utils.SimpleTextReplacement;
import sba.sl.spectator.utils.TextToComponentReplacement;
import sba.sl.u.RawValueHolder;
import sba.sl.u.ResourceLocation;
import sba.sl.u.TriState;
import sba.sl.u.annotations.ide.LimitedVersionSupport;

public interface Component
extends ComponentLike,
Wrapper,
Content,
RawValueHolder,
ComponentHolder {
    @NotNull
    public static Component empty() {
        return Spectator.getBackend().empty();
    }

    @NotNull
    public static Component newLine() {
        return Spectator.getBackend().newLine();
    }

    @NotNull
    public static Component space() {
        return Spectator.getBackend().space();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static Component fromLegacy(@Nullable String legacy) {
        return Spectator.getBackend().fromLegacy(legacy);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static Component fromLegacy(@Nullable String legacy, char colorChar) {
        return Spectator.getBackend().fromLegacy(legacy, colorChar);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static Component fromJavaJson(@Nullable String json) {
        return Spectator.getBackend().fromJson(json);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static Component fromMiniMessage(@NotNull String miniMessage) {
        return MiniMessageParser.INSTANCE.parse(miniMessage, new Placeholder[0]);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static Component fromMiniMessage(@NotNull String miniMessage, Placeholder ... placeholders) {
        return MiniMessageParser.INSTANCE.parse(miniMessage, placeholders);
    }

    public static BlockNBTComponent.Builder blockNBT() {
        return Spectator.getBackend().blockNBT();
    }

    public static EntityNBTComponent.Builder entityNBT() {
        return Spectator.getBackend().entityNBT();
    }

    public static KeybindComponent.Builder keybind() {
        return Spectator.getBackend().keybind();
    }

    public static ScoreComponent.Builder score() {
        return Spectator.getBackend().score();
    }

    public static SelectorComponent.Builder selector() {
        return Spectator.getBackend().selector();
    }

    public static StorageNBTComponent.Builder storageNBT() {
        return Spectator.getBackend().storageNBT();
    }

    public static @NotNull TextComponent.Builder text() {
        return Spectator.getBackend().text();
    }

    @NotNull
    public static TextComponent text(@NotNull String text) {
        return (TextComponent)Spectator.getBackend().text().content(text).build();
    }

    @NotNull
    public static TextComponent text(byte value) {
        return (TextComponent)Spectator.getBackend().text().content(value).build();
    }

    @NotNull
    public static TextComponent text(short value) {
        return (TextComponent)Spectator.getBackend().text().content(value).build();
    }

    @NotNull
    public static TextComponent text(int value) {
        return (TextComponent)Spectator.getBackend().text().content(value).build();
    }

    @NotNull
    public static TextComponent text(long value) {
        return (TextComponent)Spectator.getBackend().text().content(value).build();
    }

    @NotNull
    public static TextComponent text(float value) {
        return (TextComponent)Spectator.getBackend().text().content(value).build();
    }

    @NotNull
    public static TextComponent text(double value) {
        return (TextComponent)Spectator.getBackend().text().content(value).build();
    }

    @NotNull
    public static TextComponent text(@NotNull Number value) {
        return (TextComponent)Spectator.getBackend().text().content(value).build();
    }

    @NotNull
    public static TextComponent text(boolean value) {
        return (TextComponent)Spectator.getBackend().text().content(value).build();
    }

    @NotNull
    public static TextComponent text(char value) {
        return (TextComponent)Spectator.getBackend().text().content(value).build();
    }

    @NotNull
    public static TextComponent text(@NotNull String text, @NotNull Color color) {
        return (TextComponent)((TextComponent.Builder)Spectator.getBackend().text().content(text).color(color)).build();
    }

    @NotNull
    public static TextComponent text(byte value, @NotNull Color color) {
        return (TextComponent)((TextComponent.Builder)Spectator.getBackend().text().content(value).color(color)).build();
    }

    @NotNull
    public static TextComponent text(short value, @NotNull Color color) {
        return (TextComponent)((TextComponent.Builder)Spectator.getBackend().text().content(value).color(color)).build();
    }

    @NotNull
    public static TextComponent text(int value, @NotNull Color color) {
        return (TextComponent)((TextComponent.Builder)Spectator.getBackend().text().content(value).color(color)).build();
    }

    @NotNull
    public static TextComponent text(long value, @NotNull Color color) {
        return (TextComponent)((TextComponent.Builder)Spectator.getBackend().text().content(value).color(color)).build();
    }

    @NotNull
    public static TextComponent text(float value, @NotNull Color color) {
        return (TextComponent)((TextComponent.Builder)Spectator.getBackend().text().content(value).color(color)).build();
    }

    @NotNull
    public static TextComponent text(double value, @NotNull Color color) {
        return (TextComponent)((TextComponent.Builder)Spectator.getBackend().text().content(value).color(color)).build();
    }

    @NotNull
    public static TextComponent text(@NotNull Number value, @NotNull Color color) {
        return (TextComponent)((TextComponent.Builder)Spectator.getBackend().text().content(value).color(color)).build();
    }

    @NotNull
    public static TextComponent text(boolean value, @NotNull Color color) {
        return (TextComponent)((TextComponent.Builder)Spectator.getBackend().text().content(value).color(color)).build();
    }

    @NotNull
    public static TextComponent text(char value, @NotNull Color color) {
        return (TextComponent)((TextComponent.Builder)Spectator.getBackend().text().content(value).color(color)).build();
    }

    public static @NotNull TranslatableComponent.Builder translatable() {
        return Spectator.getBackend().translatable();
    }

    @NotNull
    public static Component join(@NotNull Component separator, @NotNull @NotNull Collection<@NotNull Component> components) {
        return Component.join(separator, (Component[])components.toArray(Component[]::new));
    }

    @NotNull
    public static Component join(@NotNull Component separator, Component ... components) {
        ArrayList<Component> finalComponents = new ArrayList<Component>();
        for (Component comp : components) {
            if (!finalComponents.isEmpty()) {
                finalComponents.add(separator);
            }
            finalComponents.add(comp);
        }
        return ((TextComponent.Builder)Component.text().append(finalComponents)).build();
    }

    @NotNull
    public @Unmodifiable @NotNull List<@NotNull Component> children();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Component withChildren(@Nullable List<@NotNull Component> var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public Component withAppendix(@NotNull String text) {
        return this.withAppendix((Component)Component.text(text));
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Component withAppendix(@NotNull Component var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Component withAppendix(@NotNull ComponentLike var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Component withAppendix(Component ... var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Component withAppendix(ComponentLike ... var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Component withAppendix(@NotNull @NotNull Collection<@NotNull Component> var1);

    @Nullable
    public Color color();

    @LimitedVersionSupport(value=">= 1.21.4")
    @Nullable
    public ShadowColor shadowColor();

    @Contract(pure=true)
    @NotNull
    public Component withColor(@Nullable Color var1);

    @Contract(pure=true)
    @NotNull
    default public Component withColorIfAbsent(@Nullable Color color) {
        if (this.color() == null) {
            return this.withColor(color);
        }
        return this;
    }

    @LimitedVersionSupport(value=">= 1.21.4")
    @Contract(pure=true)
    @NotNull
    public Component withShadowColor(@Nullable ShadowColor var1);

    @LimitedVersionSupport(value=">= 1.21.4")
    @Contract(pure=true)
    @NotNull
    default public Component withShadowColorIfAbsent(@Nullable ShadowColor color) {
        if (this.shadowColor() == null) {
            return this.withShadowColor(color);
        }
        return this;
    }

    @LimitedVersionSupport(value=">= 1.16")
    @Nullable
    public ResourceLocation font();

    @LimitedVersionSupport(value=">= 1.16")
    @Contract(pure=true)
    @NotNull
    public Component withFont(@Nullable ResourceLocation var1);

    @NotNull
    public TriState bold();

    @Contract(pure=true)
    @NotNull
    public Component withBold(boolean var1);

    @Contract(pure=true)
    @NotNull
    public Component withBold(@NotNull TriState var1);

    @NotNull
    public TriState italic();

    @Contract(pure=true)
    @NotNull
    public Component withItalic(boolean var1);

    @Contract(pure=true)
    @NotNull
    public Component withItalic(@NotNull TriState var1);

    @NotNull
    public TriState underlined();

    @Contract(pure=true)
    @NotNull
    public Component withUnderlined(boolean var1);

    @Contract(pure=true)
    @NotNull
    public Component withUnderlined(@NotNull TriState var1);

    @NotNull
    public TriState strikethrough();

    @Contract(pure=true)
    @NotNull
    public Component withStrikethrough(boolean var1);

    @Contract(pure=true)
    @NotNull
    public Component withStrikethrough(@NotNull TriState var1);

    @NotNull
    public TriState obfuscated();

    @Contract(pure=true)
    @NotNull
    public Component withObfuscated(boolean var1);

    @Contract(pure=true)
    @NotNull
    public Component withObfuscated(@NotNull TriState var1);

    @Nullable
    public String insertion();

    @Contract(pure=true)
    @NotNull
    public Component withInsertion(@Nullable String var1);

    @Nullable
    public HoverEvent hoverEvent();

    @Contract(pure=true)
    @NotNull
    public Component withHoverEvent(@Nullable HoverEvent var1);

    @Contract(pure=true)
    @NotNull
    public Component withHoverEvent(@Nullable ItemContent var1);

    @Contract(pure=true)
    @NotNull
    default public Component withHoverEvent(@Nullable ItemContentLike itemContent) {
        return this.withHoverEvent(itemContent == null ? null : itemContent.asItemContent());
    }

    @Contract(pure=true)
    @NotNull
    public Component withHoverEvent(@Nullable EntityContent var1);

    @Contract(pure=true)
    @NotNull
    default public Component withHoverEvent(@Nullable EntityContentLike entityContent) {
        return this.withHoverEvent(entityContent == null ? null : entityContent.asEntityContent());
    }

    @Contract(pure=true)
    @NotNull
    public Component withHoverEvent(@Nullable Component var1);

    @Contract(pure=true)
    @NotNull
    public Component withHoverEvent(@Nullable ComponentLike var1);

    @Nullable
    public ClickEvent clickEvent();

    @Contract(pure=true)
    @NotNull
    public Component withClickEvent(@Nullable ClickEvent var1);

    @Contract(pure=true)
    @NotNull
    default public Component replaceText(@NotNull Pattern pattern, @NotNull String replacement) {
        return SimpleTextReplacement.builder().matchPattern(pattern).replacement(matchResult -> replacement).build().replace(this);
    }

    @Contract(pure=true)
    @NotNull
    default public Component replace(@NotNull Pattern pattern, @NotNull Component replacement) {
        return TextToComponentReplacement.builder().matchPattern(pattern).replacement(matchResult -> replacement).build().replace(this);
    }

    @Contract(pure=true)
    @NotNull
    default public Component replaceText(@NotNull Pattern pattern, @NotNull @NotNull Function<@NotNull MatchResult, @Nullable String> replacement) {
        return SimpleTextReplacement.builder().matchPattern(pattern).replacement(replacement).build().replace(this);
    }

    @Contract(pure=true)
    @NotNull
    default public Component replace(@NotNull Pattern pattern, @NotNull @NotNull Function<@NotNull MatchResult, @Nullable Component> replacement) {
        return TextToComponentReplacement.builder().matchPattern(pattern).replacement(replacement).build().replace(this);
    }

    @Contract(pure=true)
    @NotNull
    default public Component replaceText(@NotNull String literal, @NotNull String replacement) {
        return SimpleTextReplacement.builder().matchPattern(Pattern.compile(literal, 16)).replacement(matchResult -> replacement).build().replace(this);
    }

    @Contract(pure=true)
    @NotNull
    default public Component replace(@NotNull String literal, @NotNull Component replacement) {
        return TextToComponentReplacement.builder().matchPattern(Pattern.compile(literal, 16)).replacement(matchResult -> replacement).build().replace(this);
    }

    @Contract(pure=true)
    @NotNull
    default public Component replaceText(@NotNull String literal, @NotNull @NotNull Function<@NotNull MatchResult, @Nullable String> replacement) {
        return SimpleTextReplacement.builder().matchPattern(Pattern.compile(literal, 16)).replacement(replacement).build().replace(this);
    }

    @Contract(pure=true)
    @NotNull
    default public Component replace(@NotNull String literal, @NotNull @NotNull Function<@NotNull MatchResult, @Nullable Component> replacement) {
        return TextToComponentReplacement.builder().matchPattern(Pattern.compile(literal, 16)).replacement(replacement).build().replace(this);
    }

    @Override
    @NotNull
    default public Component asComponent() {
        return this;
    }

    @Override
    @NotNull
    default public Content asContent() {
        return this;
    }

    @Contract(pure=true)
    @NotNull
    default public Component repeat(int repetitions) {
        return ComponentUtils.repeat(this, repetitions, null);
    }

    @Contract(pure=true)
    @NotNull
    default public Component repeat(int repetitions, @Nullable Component separator) {
        return ComponentUtils.repeat(this, repetitions, separator);
    }

    @Contract(pure=true)
    @NotNull
    default public Component linear(ComponentBuilderApplicable ... applicables) {
        ComponentBuilderApplicable[] newArr = new ComponentBuilderApplicable[applicables.length + 1];
        newArr[0] = this;
        System.arraycopy(applicables, 0, newArr, 1, applicables.length);
        return ComponentUtils.linear(newArr);
    }

    @NotNull
    public String toLegacy();

    @NotNull
    public String toPlainText();

    @NotNull
    default public String toJavaJson() {
        return this.toJavaJson(true);
    }

    @NotNull
    public String toJavaJson(boolean var1);

    public boolean hasStyling();

    public static interface Builder<B extends Builder<B, C>, C extends Component>
    extends ComponentLike {
        @Contract(value="_ -> this")
        @NotNull
        public B color(@NotNull Color var1);

        @LimitedVersionSupport(value=">= 1.21.4")
        @Contract(value="_ -> this")
        @NotNull
        public B shadowColor(@NotNull ShadowColor var1);

        @Contract(value="_ -> this")
        @NotNull
        default public B append(@NotNull String text) {
            return this.append((Component)Component.text(text));
        }

        @Contract(value="_ -> this")
        @NotNull
        public B append(@NotNull Component var1);

        @Contract(value="_ -> this")
        @NotNull
        public B append(@NotNull ComponentLike var1);

        @Contract(value="_ -> this")
        @NotNull
        public B append(Component ... var1);

        @Contract(value="_ -> this")
        @NotNull
        public B append(ComponentLike ... var1);

        @Contract(value="_ -> this")
        @NotNull
        public B append(@NotNull @NotNull Collection<@NotNull Component> var1);

        @LimitedVersionSupport(value=">= 1.16")
        @Contract(value="_ -> this")
        @NotNull
        public B font(@Nullable ResourceLocation var1);

        @Contract(value="-> this")
        @NotNull
        default public B bold() {
            return this.bold(true);
        }

        @Contract(value="_ -> this")
        @NotNull
        public B bold(boolean var1);

        @Contract(value="_ -> this")
        @NotNull
        public B bold(@NotNull TriState var1);

        @Contract(value="-> this")
        @NotNull
        default public B italic() {
            return this.italic(true);
        }

        @Contract(value="_ -> this")
        @NotNull
        public B italic(boolean var1);

        @Contract(value="_ -> this")
        @NotNull
        public B italic(@NotNull TriState var1);

        @Contract(value="-> this")
        @NotNull
        default public B underlined() {
            return this.underlined(true);
        }

        @Contract(value="_ -> this")
        @NotNull
        public B underlined(boolean var1);

        @Contract(value="_ -> this")
        @NotNull
        public B underlined(@NotNull TriState var1);

        @Contract(value="-> this")
        @NotNull
        default public B strikethrough() {
            return this.strikethrough(true);
        }

        @Contract(value="_ -> this")
        @NotNull
        public B strikethrough(boolean var1);

        @Contract(value="_ -> this")
        @NotNull
        public B strikethrough(@NotNull TriState var1);

        @Contract(value="-> this")
        @NotNull
        default public B obfuscated() {
            return this.obfuscated(true);
        }

        @Contract(value="_ -> this")
        @NotNull
        public B obfuscated(@NotNull TriState var1);

        @Contract(value="_ -> this")
        @NotNull
        public B obfuscated(boolean var1);

        @Contract(value="_ -> this")
        @NotNull
        public B insertion(@Nullable String var1);

        @Contract(value="_ -> this")
        @NotNull
        public B hoverEvent(@Nullable HoverEvent var1);

        @Contract(value="_ -> this")
        @NotNull
        default public B hoverEvent(@Nullable HoverEvent.Builder event) {
            return this.hoverEvent(event != null ? event.build() : null);
        }

        @Contract(value="_ -> this")
        @NotNull
        public B hoverEvent(@Nullable ItemContent var1);

        @Contract(value="_ -> this")
        @NotNull
        default public B hoverEvent(@Nullable ItemContent.Builder itemContent) {
            return this.hoverEvent(itemContent != null ? itemContent.build() : null);
        }

        @Contract(value="_ -> this")
        @NotNull
        public B hoverEvent(@Nullable EntityContent var1);

        @Contract(value="_ -> this")
        @NotNull
        default public B hoverEvent(@Nullable EntityContent.Builder entityContent) {
            return this.hoverEvent(entityContent != null ? entityContent.build() : null);
        }

        @Contract(value="_ -> this")
        @NotNull
        public B hoverEvent(@Nullable ComponentLike var1);

        @Contract(value="_ -> this")
        @NotNull
        public B hoverEvent(@Nullable Component var1);

        @Contract(value="_ -> this")
        @NotNull
        public B clickEvent(@Nullable ClickEvent var1);

        public boolean hasStyling();

        @Contract(value="-> new", pure=true)
        @NotNull
        public C build();

        @Override
        @NotNull
        default public Component asComponent() {
            return this.build();
        }
    }
}

